/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.h5;

import java.util.HashMap;
import java.util.Map;

public class BinBase {
    protected Map<String, Long> groupIndex;
    protected Map<String, Integer> entityIdMap = new HashMap<String, Integer>();
    protected Map<Integer, Group> groupCache = new HashMap<Integer, Group>();
    protected Map<Integer, Dataset> datasetCache = new HashMap<Integer, Dataset>();

    protected String getFullName(int locId, String name) {
        if (name.startsWith("/")) {
            return name;
        }
        String entityName = this.groupCache.get((Object)Integer.valueOf((int)locId)).fullName;
        if (!entityName.endsWith("/")) {
            entityName = entityName + "/";
        }
        String fullName = entityName + name;
        return fullName;
    }

    protected Group getParentGroup(int locId, String name) {
        String fullPath = this.getFullName(locId, name);
        int idx = fullPath.lastIndexOf("/");
        String parentName = fullPath.substring(0, idx);
        if (!this.entityIdMap.containsKey(idx)) {
            throw new IllegalArgumentException("No parent group found for: " + fullPath);
        }
        int parentId = this.entityIdMap.get(parentName);
        return this.groupCache.get(parentId);
    }

    protected void addEntity(Integer id, String name) {
        this.groupCache.put(id, new Group(name));
        this.entityIdMap.put(name, id);
    }

    protected int getEntityId(String name) {
        if (!this.entityIdMap.containsKey(name)) {
            System.out.println();
        }
        return this.entityIdMap.get(name);
    }

    protected Group getEntity(int id) {
        return this.groupCache.get(id);
    }

    protected String getEntityName(int id) {
        return this.groupCache.get((Object)Integer.valueOf((int)id)).fullName;
    }

    protected void removeEntity(int id) {
        Group entity = this.groupCache.get(id);
        this.groupCache.remove(id);
        this.entityIdMap.remove(entity.fullName);
    }

    public static class Dataset
    extends Entity {
        String fullName;
        int nRows;
        int nColumns;
        DataType type;
        long[] rowPositions;

        Dataset(String fullName, int nRows, int nColumns, DataType type) {
            this.fullName = fullName;
            this.type = type;
            this.nRows = nRows;
            this.nColumns = nColumns;
            this.rowPositions = new long[nRows];
        }
    }

    public static class Group
    extends Entity {
        Group(String fullName) {
            this.fullName = fullName;
        }

        boolean isEmpty() {
            return this.attributes.isEmpty();
        }
    }

    public static class Entity {
        String fullName;
        Map<String, String> attributes = new HashMap<String, String>();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum DataType {
        BYTE,
        SHORT,
        INT,
        FLOAT,
        DOUBLE,
        STRING;

    }
}

