/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature;

import java.util.Collection;
import java.util.LinkedHashMap;
import org.broad.igv.feature.Chromosome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Genome {
    private String name;
    private LinkedHashMap<String, Chromosome> chromosomeMap;
    long length = -1L;

    public Genome(String name) {
        this.name = name;
        this.setChromosomeMap(new LinkedHashMap<String, Chromosome>(24));
    }

    public void setChromosomeMap(LinkedHashMap<String, Chromosome> chromosomeMap) {
        this.chromosomeMap = chromosomeMap;
    }

    public Chromosome getChromosome(String chrName) {
        return this.chromosomeMap.get(chrName);
    }

    public Collection<String> getChromosomeNames() {
        return this.chromosomeMap.keySet();
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomeMap.values();
    }

    public long getLength() {
        if (this.length < 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomeMap.values()) {
                this.length += (long)chr.getLength();
            }
        }
        return this.length;
    }

    public long getCumulativeOffset(String chr) {
        long offset = 0L;
        for (String c : this.getChromosomeNames()) {
            if (chr.equals(c)) break;
            offset += (long)this.getChromosome(chr).getLength();
        }
        return offset;
    }

    public String getName() {
        return this.name;
    }
}

