/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.wgs;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.wgs.SequenceDataset;
import org.broad.igv.data.wgs.WGSBaseProcessor;
import org.broad.igv.preprocess.Bin;
import org.broad.igv.preprocess.RangeBin;
import org.broad.igv.preprocess.StatusMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WGSProcessor
extends WGSBaseProcessor {
    private static Logger log = Logger.getLogger(WGSProcessor.class);
    private static int maxNumberWarnings = 200;
    private static int numberWarnings = 0;

    public WGSProcessor(SequenceDataset ds, StatusMonitor sm) {
        super(ds, sm);
    }

    public WGSProcessor(SequenceDataset ds) {
        super(ds);
    }

    public static void main(String[] args) {
        SequenceDataset ds = new SequenceDataset(args[0]);
        WGSProcessor proc = new WGSProcessor(ds);
        proc.setZoomMax(2);
        proc.process(args[1]);
    }

    @Override
    protected List<Bin> allocateBins(int chrLength, int nBins, double binSize) {
        ArrayList<RangeBin> allBins = new ArrayList<RangeBin>(nBins);
        for (int i = 0; i < nBins; ++i) {
            int location = (int)((double)i * binSize);
            allBins.add(new RangeBin(location));
        }
        RangeBin lastBin = null;
        for (int i = 0; i < chrLength; ++i) {
            int start = i;
            int bStart = (int)((double)start / binSize);
            if (bStart >= allBins.size()) continue;
            RangeBin bin = (RangeBin)allBins.get(bStart);
            if (lastBin == null) {
                bin.setStartIndex(i);
            } else if (bin != lastBin) {
                bin.setStartIndex(i);
                lastBin.setEndIndex(i);
            }
            lastBin = bin;
        }
        if (lastBin != null && lastBin.getEndIndex() <= 0) {
            lastBin.setEndIndex(chrLength);
        }
        ArrayList<Bin> occupiedBins = new ArrayList<Bin>(allBins.size());
        for (RangeBin bin : allBins) {
            if (bin.getFeatureCount() <= 0) continue;
            occupiedBins.add(bin);
        }
        return occupiedBins;
    }

    @Override
    protected float[] getDataForBin(float[] data, Bin bin) {
        RangeBin rBin = (RangeBin)bin;
        int nDataPts = 0;
        for (int i = rBin.getStartIndex(); i < rBin.getEndIndex() && i < data.length; ++i) {
            if (Float.isNaN(data[i])) continue;
            ++nDataPts;
        }
        if (nDataPts > 0) {
            float[] binData = new float[nDataPts];
            int binDataIndex = 0;
            for (int i = rBin.getStartIndex(); i < rBin.getEndIndex() && binDataIndex < binData.length; ++i) {
                if (Float.isNaN(data[i])) continue;
                binData[binDataIndex] = data[i];
                ++binDataIndex;
            }
            return binData;
        }
        return null;
    }
}

