/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data.wgs;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.broad.igv.feature.Genome;
import org.broad.igv.feature.GenomeManager;
import org.broad.igv.track.TrackType;

public class SequenceDataset {
    String genomeId;
    Genome genome;
    String trackName;
    int[] locations;
    float[] data;
    File directory;
    String color;
    String[] chromosomes;

    public SequenceDataset(String path) {
        this.directory = new File(path);
        this.readProperties();
        this.scanForChromosomes();
        this.genome = GenomeManager.getInstance().getGenome(this.genomeId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readProperties() {
        File propFile = new File(this.directory, "property.txt");
        if (propFile.exists()) {
            InputStream is = null;
            try {
                Properties props = new Properties();
                is = new FileInputStream(propFile);
                props.load(is);
                is.close();
                this.genomeId = props.getProperty("genome");
                this.trackName = props.getProperty("name");
                this.color = props.getProperty("color");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            this.genomeId = "hg18";
            this.trackName = this.directory.getName();
            this.color = "0,0,255";
        }
    }

    private void scanForChromosomes() {
        File[] files = this.directory.listFiles(new FileFilter(){

            public boolean accept(File arg0) {
                return arg0.getName().startsWith("chr") && arg0.getName().endsWith(".bin");
            }
        });
        this.chromosomes = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            this.chromosomes[i] = files[i].getName().replace(".bin", "").trim();
        }
    }

    public String getName() {
        return this.trackName;
    }

    public TrackType getType() {
        return TrackType.OTHER;
    }

    public Genome getGenome() {
        return this.genome;
    }

    public String[] getChromosomes() {
        return this.chromosomes;
    }

    public String getTrackName() {
        return this.trackName;
    }

    public int getWindowSpan() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float[] getData(String chr) {
        FilterInputStream dis = null;
        File inputFile = new File(this.directory, chr + ".bin");
        if (!inputFile.exists()) {
            return null;
        }
        int chrLength = this.genome.getChromosome(chr).getLength();
        float[] data = new float[chrLength];
        try {
            dis = new DataInputStream(new BufferedInputStream(new FileInputStream(inputFile)));
            for (int i = 0; i < chrLength; ++i) {
                if (dis.available() < 2) continue;
                data[i] = ((DataInputStream)dis).readShort();
            }
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                dis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return data;
    }

    public static void main(String[] args) {
        SequenceDataset ds = new SequenceDataset("/Users/jrobinso/IGV/SeqTrack/");
        float[] data = ds.getData("chrX");
        System.out.println(data.length);
    }
}

