/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import org.broad.igv.data.FloatArrayList;
import org.broad.igv.data.IntArrayList;
import org.broad.igv.data.ResourceLocator;
import org.broad.igv.data.WiggleDataset;
import org.broad.igv.feature.ParsingUtils;
import org.broad.igv.util.AsciiLineReader;

public class WiggleParser {
    WiggleDataset dataset;
    private Type type = Type.BED;
    private String chr;
    String lastChr = "";
    private int start;
    private int step;
    private int windowSpan;
    IntArrayList startLocations = null;
    IntArrayList endLocations = null;
    FloatArrayList data = null;
    private double minValue;
    private double maxValue;
    ResourceLocator resourceLocator;

    public WiggleParser(ResourceLocator locator, String genomeId) {
        this.resourceLocator = locator;
        this.dataset = new WiggleDataset(genomeId, locator.getDisplayName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isWiggle(ResourceLocator file) {
        AsciiLineReader reader = null;
        try {
            reader = WiggleParser.openAsciiReader(file);
            String nextLine = null;
            int lineNo = 0;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("track") && nextLine.contains("wilggle_0")) {
                    boolean bl = true;
                    return bl;
                }
                if (lineNo++ <= 100) continue;
                break;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(WiggleParser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WiggleDataset parse() {
        String[] tokens = new String[10];
        AsciiLineReader reader = null;
        try {
            reader = WiggleParser.openAsciiReader(this.resourceLocator);
            String nextLine = null;
            int position = -1;
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                if (nextLine.startsWith("#") || nextLine.startsWith("data") || nextLine.startsWith("browser")) continue;
                if (nextLine.startsWith("track")) {
                    this.type = Type.BED;
                    continue;
                }
                if (nextLine.startsWith("fixedStep")) {
                    this.type = Type.FIXED;
                    this.parseStepLine(nextLine);
                    position = this.start;
                    continue;
                }
                if (nextLine.startsWith("variableStep")) {
                    this.type = Type.VARIABLE;
                    this.parseStepLine(nextLine);
                    continue;
                }
                int nTokens = ParsingUtils.split(nextLine, tokens, '\t');
                if (nTokens == 0) continue;
                try {
                    if (this.type.equals((Object)Type.BED)) {
                        if (nTokens <= 3) continue;
                        this.chr = tokens[0].trim();
                        if (!this.chr.equals(this.lastChr)) {
                            this.changedChromosome(this.dataset, this.lastChr);
                        }
                        this.lastChr = this.chr;
                        this.startLocations.add(Integer.parseInt(tokens[1]));
                        this.endLocations.add(Integer.parseInt(tokens[2]));
                        this.data.add(Float.parseFloat(tokens[3]));
                        continue;
                    }
                    if (this.type.equals((Object)Type.VARIABLE)) {
                        if (nTokens <= 1) continue;
                        this.start = Integer.parseInt(tokens[0]) - 1;
                        int end = this.start + this.windowSpan;
                        this.startLocations.add(this.start);
                        this.endLocations.add(end);
                        this.data.add(Float.parseFloat(tokens[1]));
                        continue;
                    }
                    if (position >= 0) {
                        this.startLocations.add(position);
                        this.endLocations.add(position + this.windowSpan);
                        this.data.add(Float.parseFloat(tokens[0]));
                    }
                    position += this.step;
                }
                catch (NumberFormatException e) {
                    System.out.println("Cannot parse: " + nextLine);
                }
            }
            this.changedChromosome(this.dataset, this.lastChr);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(WiggleParser.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        this.dataset.sort();
        return this.dataset;
    }

    private void parseStepLine(String header) {
        String[] tokens;
        for (String token : tokens = header.split(" ")) {
            String[] keyValue = token.split("=");
            if (keyValue.length < 2) continue;
            if (keyValue[0].equalsIgnoreCase("chrom")) {
                this.chr = keyValue[1];
                if (!this.chr.equals(this.lastChr)) {
                    this.changedChromosome(this.dataset, this.lastChr);
                }
                this.lastChr = this.chr;
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("start")) {
                this.start = Integer.parseInt(keyValue[1]) - 1;
                continue;
            }
            if (keyValue[0].equalsIgnoreCase("step")) {
                this.step = Integer.parseInt(keyValue[1]);
                continue;
            }
            if (!keyValue[0].equalsIgnoreCase("span")) continue;
            this.windowSpan = Integer.parseInt(keyValue[1]);
        }
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    private void changedChromosome(WiggleDataset dataset, String lastChr) {
        int sz = 1000000;
        if (this.startLocations != null && this.startLocations.size() > 0) {
            dataset.addDataChunk(lastChr, this.startLocations, this.endLocations, this.data);
            sz = this.startLocations.size();
        }
        this.startLocations = new IntArrayList(sz);
        this.endLocations = new IntArrayList(sz);
        this.data = new FloatArrayList(sz);
    }

    public static AsciiLineReader openAsciiReader(ResourceLocator locator) throws FileNotFoundException, IOException {
        InputStream stream = WiggleParser.openInputStream(locator);
        return new AsciiLineReader(stream);
    }

    public static InputStream openInputStream(ResourceLocator locator) throws FileNotFoundException, IOException {
        Object reader = null;
        if (locator.isLocal()) {
            File file = new File(locator.getPath());
            FileInputStream fileInput = new FileInputStream(file);
            if (file.getName().endsWith("gz")) {
                return new GZIPInputStream(fileInput);
            }
            return fileInput;
        }
        URL url = new URL(locator.getServerURL() + "?method=getContents&file=" + locator.getPath());
        URLConnection connection = url.openConnection();
        return new GZIPInputStream(connection.getInputStream());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Type {
        FIXED,
        VARIABLE,
        BED;

    }
}

