/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

public class IntArrayList {
    static final int maxGrowIncrement = 0xCCCCCCC;
    private int sz = 0;
    private int[] values;

    public IntArrayList(int maxSize) {
        this.values = new int[maxSize];
    }

    public int size() {
        return this.sz;
    }

    public void add(int v) {
        if (this.sz >= this.values.length) {
            this.grow();
        }
        this.values[this.sz] = v;
        ++this.sz;
    }

    public void addAll(int[] array) {
        if (this.values.length - this.sz < array.length) {
            this.grow(array.length);
        }
        System.arraycopy(array, 0, this.values, this.sz, array.length);
        this.sz += array.length;
    }

    public int[] toArray() {
        this.trim();
        return this.values;
    }

    public int get(int idx) {
        if (idx >= this.sz) {
            throw new IndexOutOfBoundsException("Index out of bounds.  Size = " + this.sz + " Index = " + idx);
        }
        return this.values[idx];
    }

    private void grow() {
        this.grow((int)Math.max(1000.0, 0.2 * (double)this.values.length));
    }

    private void grow(int increment) {
        if (this.values.length >= Integer.MAX_VALUE) {
            throw new RuntimeException("Maximum array size exceeded");
        }
        int newSize = Math.min(Integer.MAX_VALUE, this.values.length + increment);
        this.resize(newSize);
    }

    private void resize(int newSize) {
        int[] tmp = new int[newSize];
        System.arraycopy(this.values, 0, tmp, 0, Math.min(tmp.length, this.values.length));
        this.values = tmp;
    }

    private void trim() {
        this.resize(this.sz);
    }

    public void reorder(int[] indeces) {
        if (indeces.length != this.sz) {
            throw new IllegalArgumentException("Index array length not equal to size");
        }
        int[] reorderedValues = new int[this.sz];
        for (int i = 0; i < this.sz; ++i) {
            reorderedValues[i] = this.values[indeces[i]];
        }
        this.values = reorderedValues;
    }
}

