/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.data;

import java.awt.Color;
import org.apache.log4j.Logger;
import org.broad.igv.data.TrackProperties;
import org.broad.igv.data.WindowFunction;
import org.broad.igv.util.ColorUtilities;

public class DatasetParserUtils {
    private static Logger log = Logger.getLogger(DatasetParserUtils.class);

    public static void parseTrackLine(String nextLine, TrackProperties trackProperties) throws NumberFormatException {
        try {
            String[] tokens;
            for (String pair : tokens = nextLine.split(" ")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) continue;
                String key = kv[0].toLowerCase().trim();
                String value = kv[1].toLowerCase().trim();
                if (key.equals("name")) {
                    trackProperties.setName(value);
                    continue;
                }
                if (key.equals("description")) {
                    trackProperties.setDescription(value);
                    continue;
                }
                if (key.equals("color")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setColor(color);
                    continue;
                }
                if (key.equals("altcolor")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setAltColor(color);
                    continue;
                }
                if (key.equals("midcolor")) {
                    Color color = ColorUtilities.convertRGBStringToColor(value);
                    trackProperties.setMidColor(color);
                    continue;
                }
                if (key.equals("autoscale")) {
                    boolean autoscale = value.equals("on");
                    trackProperties.setAutoScale(autoscale);
                    continue;
                }
                if (key.equals("maxheightpixels")) {
                    String[] maxDefMin = value.split(":");
                    trackProperties.setHeight(Integer.parseInt(maxDefMin[1].trim()));
                    continue;
                }
                if (key.equals("graphtype")) {
                    if (value.equals("bar") || value.equals("points") || !value.equals("heatmap")) continue;
                    continue;
                }
                if (key.toLowerCase().equals("viewlimits")) {
                    String[] limits = value.split(":");
                    if (limits.length != 2) continue;
                    float min = Float.parseFloat(limits[0].trim());
                    float max = Float.parseFloat(limits[1].trim());
                    trackProperties.setMinValue(min);
                    trackProperties.setMaxValue(max);
                    float mid = min;
                    if (min * max < 0.0f) {
                        mid = 0.0f;
                    }
                    trackProperties.setMidValue(mid);
                    continue;
                }
                if (key.equals("ylinemark")) {
                    try {
                        float midValue = Float.parseFloat(value);
                        trackProperties.setMidValue(midValue);
                    }
                    catch (NumberFormatException e) {
                        log.error("Number format exception in track line (ylinemark): " + nextLine);
                    }
                    continue;
                }
                if (key.equals("ylineonoff")) {
                    trackProperties.setDrawMidValue(value.equals("on"));
                    continue;
                }
                if (!key.equals("windowingfunction")) continue;
                if (value.equals("maximum")) {
                    trackProperties.setWindowingFunction(WindowFunction.max);
                    continue;
                }
                if (value.equals("minimum")) {
                    trackProperties.setWindowingFunction(WindowFunction.min);
                    continue;
                }
                if (value.equals("mean")) {
                    trackProperties.setWindowingFunction(WindowFunction.mean);
                    continue;
                }
                if (value.equals("median")) {
                    trackProperties.setWindowingFunction(WindowFunction.median);
                    continue;
                }
                if (value.equals("percentile10")) {
                    trackProperties.setWindowingFunction(WindowFunction.percentile10);
                    continue;
                }
                if (!value.equals("percentile90")) continue;
                trackProperties.setWindowingFunction(WindowFunction.percentile90);
            }
        }
        catch (Exception exception) {
            System.err.println("Error parsing track line: " + nextLine + " (" + exception.getMessage() + ")");
        }
    }
}

