/*
 * Decompiled with CFR 0.152.
 */
package ncsa.hdf.hdflib;

import ncsa.hdf.hdflib.HDFException;
import ncsa.hdf.hdflib.HDFJavaException;

public class HDFNativeData {
    public static native int[] byteToInt(byte[] var0);

    public static native float[] byteToFloat(byte[] var0);

    public static native short[] byteToShort(byte[] var0);

    public static native long[] byteToLong(byte[] var0);

    public static native double[] byteToDouble(byte[] var0);

    public static native int[] byteToInt(int var0, int var1, byte[] var2);

    public static int byteToInt(byte[] byArray, int n) {
        int[] nArray = new int[1];
        nArray = HDFNativeData.byteToInt(n, 1, byArray);
        return nArray[0];
    }

    public static native short[] byteToShort(int var0, int var1, byte[] var2);

    public static short byteToShort(byte[] byArray, int n) {
        short[] sArray = new short[1];
        sArray = HDFNativeData.byteToShort(n, 1, byArray);
        return sArray[0];
    }

    public static native float[] byteToFloat(int var0, int var1, byte[] var2);

    public static float byteToFloat(byte[] byArray, int n) {
        float[] fArray = new float[1];
        fArray = HDFNativeData.byteToFloat(n, 1, byArray);
        return fArray[0];
    }

    public static native long[] byteToLong(int var0, int var1, byte[] var2);

    public static long byteToLong(byte[] byArray, int n) {
        long[] lArray = new long[1];
        lArray = HDFNativeData.byteToLong(n, 1, byArray);
        return lArray[0];
    }

    public static native double[] byteToDouble(int var0, int var1, byte[] var2);

    public static double byteToDouble(byte[] byArray, int n) {
        double[] dArray = new double[1];
        dArray = HDFNativeData.byteToDouble(n, 1, byArray);
        return dArray[0];
    }

    public static native byte[] intToByte(int var0, int var1, int[] var2);

    public static native byte[] shortToByte(int var0, int var1, short[] var2);

    public static native byte[] floatToByte(int var0, int var1, float[] var2);

    public static native byte[] longToByte(int var0, int var1, long[] var2);

    public static native byte[] doubleToByte(int var0, int var1, double[] var2);

    public static native byte[] byteToByte(byte var0);

    static byte[] byteToByte(Byte by) {
        return HDFNativeData.byteToByte((byte)by);
    }

    public static native byte[] intToByte(int var0);

    static byte[] intToByte(Integer n) {
        return HDFNativeData.intToByte((int)n);
    }

    public static native byte[] shortToByte(short var0);

    static byte[] shortToByte(Short s) {
        return HDFNativeData.shortToByte((short)s);
    }

    public static native byte[] floatToByte(float var0);

    static byte[] floatToByte(Float f) {
        return HDFNativeData.floatToByte(f.floatValue());
    }

    public static native byte[] longToByte(long var0);

    static byte[] longToByte(Long l) {
        return HDFNativeData.longToByte((long)l);
    }

    public static native byte[] doubleToByte(double var0);

    static byte[] doubleToByte(Double d) {
        return HDFNativeData.doubleToByte((double)d);
    }

    public Object byteToNumber(byte[] byArray, Object object) throws HDFException {
        Class<?> clazz = object.getClass();
        String string = clazz.getName();
        Number number = null;
        if (string.equals("java.lang.Integer")) {
            int[] nArray = HDFNativeData.byteToInt(0, 1, byArray);
            number = new Integer(nArray[0]);
        } else if (string.equals("java.lang.Byte")) {
            number = new Byte(byArray[0]);
        } else if (string.equals("java.lang.Short")) {
            short[] sArray = HDFNativeData.byteToShort(0, 1, byArray);
            number = new Short(sArray[0]);
        } else if (string.equals("java.lang.Float")) {
            float[] fArray = HDFNativeData.byteToFloat(0, 1, byArray);
            number = new Float(fArray[0]);
        } else if (string.equals("java.lang.Long")) {
            long[] lArray = HDFNativeData.byteToLong(0, 1, byArray);
            number = new Long(lArray[0]);
        } else if (string.equals("java.lang.Double")) {
            double[] dArray = HDFNativeData.byteToDouble(0, 1, byArray);
            number = new Double(dArray[0]);
        } else {
            HDFJavaException hDFJavaException = new HDFJavaException("byteToNumber: setfield bad type: " + object + " " + string);
            throw hDFJavaException;
        }
        return number;
    }

    public static Object defineDataObject(int n, int n2) {
        Object[] objectArray = null;
        if ((n & 0x4000) != 0) {
            n -= 16384;
        }
        switch (n) {
            case 22: 
            case 23: {
                objectArray = new short[n2];
                break;
            }
            case 24: 
            case 25: {
                objectArray = new int[n2];
                break;
            }
            case 26: 
            case 27: {
                objectArray = new long[n2];
                break;
            }
            case 5: {
                objectArray = new float[n2];
                break;
            }
            case 6: {
                objectArray = new double[n2];
                break;
            }
            default: {
                objectArray = new byte[n2];
            }
        }
        return objectArray;
    }
}

