/*
 * Decompiled with CFR 0.152.
 */
package org.igv.variant.util;

import htsjdk.tribble.AbstractFeatureReader;
import htsjdk.tribble.FeatureCodec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFCodec;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.igv.feature.genome.Genome;
import org.igv.feature.tribble.CodecFactory;

public class VCFtoBed {
    public static void main(String[] args) throws IOException {
        VCFtoBed.convert(args[0], args[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(String vcfFile, String bedFile) throws IOException {
        AbstractFeatureReader basicReader = null;
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(bedFile)));
            Genome genome = null;
            FeatureCodec codec = CodecFactory.getCodec(vcfFile, genome);
            boolean isVCF = codec.getClass().isAssignableFrom(VCFCodec.class);
            basicReader = AbstractFeatureReader.getFeatureReader((String)vcfFile, (FeatureCodec)codec, (boolean)true);
            for (VariantContext vc : basicReader) {
                Object chr = vc.getChr();
                if (!((String)chr).startsWith("chr")) {
                    chr = "chr" + (String)chr;
                }
                int start = vc.getStart() - 1;
                int end = vc.getEnd();
                String id = vc.getID();
                if (id == null) {
                    id = ".";
                }
                String af = vc.getAttributeAsString("AF", "");
                writer.println((String)chr + "\t" + start + "\t" + end + "\t" + id + "\t" + af);
            }
        }
        finally {
            if (basicReader != null) {
                basicReader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }
}

