/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.collections;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class CaseInsensitiveMap<V>
implements Map<String, V> {
    private final Map<String, V> map = new HashMap<String, V>();
    private final Map<String, String> originalKeys = new HashMap<String, String>();

    private static String lowerKey(Object key) {
        return key == null ? null : key.toString().toLowerCase();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(CaseInsensitiveMap.lowerKey(key));
    }

    @Override
    public boolean containsValue(Object value) {
        return this.map.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.map.get(CaseInsensitiveMap.lowerKey(key));
    }

    @Override
    public V put(String key, V value) {
        this.originalKeys.put(CaseInsensitiveMap.lowerKey(key), key);
        return this.map.put(CaseInsensitiveMap.lowerKey(key), value);
    }

    @Override
    public V remove(Object key) {
        this.originalKeys.remove(CaseInsensitiveMap.lowerKey(key));
        return this.map.remove(CaseInsensitiveMap.lowerKey(key));
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> m) {
        for (Map.Entry<String, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.map.clear();
        this.originalKeys.clear();
    }

    @Override
    public Set<String> keySet() {
        return new LinkedHashSet<String>(this.originalKeys.values());
    }

    @Override
    public Collection<V> values() {
        return this.map.values();
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        return this.map.entrySet().stream().map(e -> new AbstractMap.SimpleEntry(this.originalKeys.get(e.getKey()), e.getValue())).collect(Collectors.toSet());
    }
}

