/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class ObjectCache<K, V> {
    private int maxSize = 1000;
    private LinkedHashMap<K, SoftReference<V>> map;

    public ObjectCache() {
        this(50);
    }

    public ObjectCache(int maxSize) {
        this.maxSize = maxSize;
        this.map = new LinkedHashMap(maxSize);
    }

    public void put(K key, V image) {
        Iterator<K> iterator;
        if (this.map.size() == this.maxSize && (iterator = this.map.keySet().iterator()).hasNext()) {
            K k = iterator.next();
            this.map.remove(k);
        }
        SoftReference<V> SoftReference2 = new SoftReference<V>(image);
        this.map.put(key, SoftReference2);
    }

    public V get(K key) {
        V image = null;
        SoftReference<V> SoftReference2 = this.map.get(key);
        if (SoftReference2 != null) {
            image = SoftReference2.get();
        }
        return image;
    }

    public Collection<K> getKeys() {
        return this.map.keySet();
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public void clear() {
        this.map.clear();
    }

    public int size() {
        return this.map.size();
    }

    public Iterator<K> iterator() {
        return this.map.keySet().iterator();
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

