/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.GoogleUtils;
import org.igv.util.URLUtils;

public class HttpMappings {
    private static Logger log = LogManager.getLogger(HttpMappings.class);
    private static Map<String, String> mappedURLCache = new HashMap<String, String>();
    static Map<String, String> urlMappings;

    private HttpMappings() {
    }

    public static String mapURL(String urlString) throws MalformedURLException {
        if (mappedURLCache.containsKey(urlString)) {
            return mappedURLCache.get(urlString);
        }
        if (urlMappings.isEmpty()) {
            HttpMappings.loadMappings();
        }
        String key = (urlString = HttpMappings.checkStaticMappings(urlString)).startsWith("s3://") || urlString.contains("amazonaws.com") ? HttpMappings.getAmazonKey(urlString) : urlString;
        String mappedURL = urlMappings.containsKey(key) ? urlMappings.get(key) : urlString;
        mappedURLCache.put(urlString, mappedURL);
        return mappedURL;
    }

    private static void loadMappings() {
        try {
            URL fileUrl = new URL("https://raw.githubusercontent.com/igvteam/igv-data/refs/heads/main/data/url_mappings.tsv");
            try (InputStream inputStream = fileUrl.openStream();
                 BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] columns;
                    if (line.startsWith("#") || line.trim().isEmpty() || (columns = line.split("\t")).length != 2) continue;
                    String key = columns[0].trim();
                    if (key.startsWith("s3://") || key.contains("amazonaws.com")) {
                        key = HttpMappings.getAmazonKey(key);
                    }
                    urlMappings.put(key, columns[1].trim());
                }
            }
        }
        catch (IOException e) {
            log.error("Error loading URL mappings", e);
        }
    }

    private static String getAmazonKey(String url) throws MalformedURLException {
        return "S3::: " + new URL(url.replace("s3://", "https://")).getPath();
    }

    private static String checkStaticMappings(String urlString) throws MalformedURLException {
        String host;
        if (urlString.startsWith("htsget://")) {
            urlString = urlString.replace("htsget://", "https://");
        } else if (urlString.startsWith("gs://")) {
            urlString = GoogleUtils.translateGoogleCloudURL(urlString);
        }
        if (GoogleUtils.isGoogleURL(urlString) && urlString.indexOf("alt=media") < 0) {
            urlString = URLUtils.addParameter(urlString, "alt=media");
        }
        if ((host = URLUtils.getHost(urlString)).equals("igv.broadinstitute.org")) {
            urlString = urlString.replace("igv.broadinstitute.org", "s3.amazonaws.com/igv.broadinstitute.org");
        } else if (host.equals("igvdata.broadinstitute.org")) {
            urlString = urlString.replace("igvdata.broadinstitute.org", "s3.amazonaws.com/igv.broadinstitute.org");
        } else if (host.equals("dn7ywbm9isq8j.cloudfront.net")) {
            urlString = urlString.replace("dn7ywbm9isq8j.cloudfront.net", "s3.amazonaws.com/igv.broadinstitute.org");
        } else if (host.equals("www.broadinstitute.org")) {
            urlString = urlString.replace("www.broadinstitute.org/igvdata", "data.broadinstitute.org/igvdata");
        } else if (host.equals("www.dropbox.com")) {
            urlString = urlString.replace("//www.dropbox.com", "//dl.dropboxusercontent.com");
        } else if (host.equals("drive.google.com")) {
            urlString = GoogleUtils.driveDownloadURL(urlString);
        } else if (host.equals("igv.genepattern.org")) {
            urlString = urlString.replace("//igv.genepattern.org", "//igv-genepattern-org.s3.amazonaws.com");
        }
        urlString = urlString.replace("http://data.broadinstitute.org", "https://data.broadinstitute.org");
        return urlString;
    }

    static {
        mappedURLCache.put("https://raw.githubusercontent.com/igvteam/igv-data/refs/heads/main/data/url_mappings.tsv", "https://raw.githubusercontent.com/igvteam/igv-data/refs/heads/main/data/url_mappings.tsv");
        urlMappings = new HashMap<String, String>();
    }
}

