/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.util.MessageUtils;
import org.igv.util.HttpUtils;
import org.json.JSONObject;

public class GoogleUtils {
    private static Logger log = LogManager.getLogger(GoogleUtils.class);
    private static String ProjectID;
    public static final String GOOGLE_API_HOST = "www.googleapis.com";
    public static final String GOOGLE_DRIVE_HOST = "drive.google.com";
    static Map<Character, String> encodings;

    public static boolean isGoogleURL(String url) {
        return url != null && (GoogleUtils.isGoogleDrive(url) || GoogleUtils.isGoogleStorageURL(url));
    }

    public static boolean isGoogleDrive(String url) {
        return url != null && (url.contains(GOOGLE_DRIVE_HOST) || url.contains("www.googleapis.com/drive"));
    }

    public static boolean isGoogleStorageURL(String url) {
        return url != null && (url.startsWith("gs://") || url.startsWith("https://www.googleapis.com/storage") || url.startsWith("https://storage.cloud.google.com") || url.startsWith("https://storage.googleapis.com"));
    }

    public static String translateGoogleCloudURL(String gsUrl) {
        int i = gsUrl.indexOf(47, 5);
        if (i < 0) {
            log.error("Invalid gs url: " + gsUrl);
            return gsUrl;
        }
        String bucket = gsUrl.substring(5, i);
        String object = GoogleUtils.googleObjectEncode(gsUrl.substring(i + 1));
        return "https://storage.googleapis.com/storage/v1/b/" + bucket + "/o/" + object + "?alt=media";
    }

    public static void enterGoogleProjectID() {
        String projectID = MessageUtils.showInputDialog("Enter Google project ID (for \"Requestor Pays\")", GoogleUtils.getProjectID());
        if (projectID != null) {
            GoogleUtils.setProjectID(projectID);
        }
    }

    public static String getProjectID() {
        if (ProjectID == null && PreferencesManager.getPreferences().getAsBoolean("SAVE_GOOGLE_CREDENTIALS")) {
            ProjectID = PreferencesManager.getPreferences().get("GOOGLE_PROJECT");
        }
        return ProjectID;
    }

    public static void setProjectID(String projectID) {
        ProjectID = projectID;
        if (ProjectID != null && PreferencesManager.getPreferences().getAsBoolean("SAVE_GOOGLE_CREDENTIALS")) {
            PreferencesManager.getPreferences().put("GOOGLE_PROJECT", projectID);
        }
    }

    public static String driveDownloadURL(String link) {
        String id = GoogleUtils.getGoogleDriveFileID(link);
        return id == null ? link : "https://www.googleapis.com/drive/v3/files/" + id + "?alt=media&supportsTeamDrives=true";
    }

    public static String getGoogleDriveFileID(String link) {
        if (link.contains("/open?id=")) {
            int i1 = link.indexOf("/open?id=") + 9;
            int i2 = link.indexOf("&");
            if (i1 > 0 && i2 > i1) {
                return link.substring(i1, i2);
            }
            if (i1 > 0) {
                return link.substring(i1);
            }
        } else if (link.contains("/file/d/")) {
            int i1 = link.indexOf("/file/d/") + 8;
            int i2 = link.lastIndexOf("/");
            return link.substring(i1, i2);
        }
        return null;
    }

    public static JSONObject getDriveFileInfo(String googleDriveURL) {
        try {
            String id = GoogleUtils.getGoogleDriveFileID(googleDriveURL);
            String endPoint = "https://www.googleapis.com/drive/v3/files/" + id + "?supportsTeamDrives=true";
            String json = HttpUtils.getInstance().getContentsAsJSON(new URL(endPoint));
            JSONObject obj = new JSONObject(json);
            return obj;
        }
        catch (IOException e) {
            log.error("Error fetching google drive info", e);
            return null;
        }
    }

    static String googleObjectEncode(String objectName) {
        Object result = "";
        for (int i = 0; i < objectName.length(); ++i) {
            Character c = Character.valueOf(objectName.charAt(i));
            result = encodings.containsKey(c) ? (String)result + encodings.get(c) : (String)result + c;
        }
        return result;
    }

    static {
        encodings = new HashMap<Character, String>();
        encodings.put(Character.valueOf(' '), "%20");
        encodings.put(Character.valueOf('!'), "%21");
        encodings.put(Character.valueOf('#'), "%23");
        encodings.put(Character.valueOf('$'), "%24");
        encodings.put(Character.valueOf('%'), "%25");
        encodings.put(Character.valueOf('&'), "%26");
        encodings.put(Character.valueOf('\''), "%27");
        encodings.put(Character.valueOf('('), "%28");
        encodings.put(Character.valueOf(')'), "%29");
        encodings.put(Character.valueOf('*'), "%2A");
        encodings.put(Character.valueOf('+'), "%2B");
        encodings.put(Character.valueOf(','), "%2C");
        encodings.put(Character.valueOf('/'), "%2F");
        encodings.put(Character.valueOf(':'), "%3A");
        encodings.put(Character.valueOf(';'), "%3B");
        encodings.put(Character.valueOf('='), "%3D");
        encodings.put(Character.valueOf('?'), "%3F");
        encodings.put(Character.valueOf('@'), "%40");
        encodings.put(Character.valueOf('['), "%5B");
        encodings.put(Character.valueOf(']'), "%5D");
    }
}

