/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ultima;

import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import org.igv.sam.Alignment;
import org.igv.sam.SAMAlignment;

public class FlowUtil {
    public static final String TAG_T0 = "t0";
    public static final double MIN_PROB_DEFAULT = 0.01;
    public static String ATTR_TP = "tp";
    private static String RG_ATTR_PL = "PL";
    private static String RG_ATTR_MC = "mc";
    private static String RG_ATTR_PL_ULTIMA = "ULTIMA";

    public static boolean isFlow(SAMRecord record) {
        return FlowUtil.isUltimaFlowReadGroup(record.getReadGroup()) && record.hasAttribute(ATTR_TP);
    }

    public static boolean isFlow(Alignment alignment) {
        return alignment instanceof SAMAlignment && FlowUtil.isFlow(((SAMAlignment)alignment).getRecord());
    }

    public static boolean isUltimaFlowReadGroup(SAMReadGroupRecord readGroup) {
        if (readGroup == null) {
            return false;
        }
        if (RG_ATTR_PL_ULTIMA.equals(readGroup.getAttribute(RG_ATTR_PL))) {
            return true;
        }
        return readGroup.getAttribute(RG_ATTR_MC) != null;
    }
}

