/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.util;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class ProgressMonitor {
    public static final String PROGRESS_PROPERTY = "PROGRESS_PROPERTY";
    public static final String STATUS_PROPERTY = "STATUS_STATUS";
    private boolean isReady = false;
    private int oldValue = 0;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String oldStatus = "";

    public ProgressMonitor() {
        this.setReady(true);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void fireProgressChange(int value) {
        if (this.isReady) {
            int newValue = this.oldValue + value;
            PropertyChangeEvent event = new PropertyChangeEvent(this, PROGRESS_PROPERTY, this.oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(event);
            this.oldValue = newValue;
        }
    }

    public void fireProgress(int newValue) {
        if (this.isReady) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, PROGRESS_PROPERTY, this.oldValue, newValue);
            this.propertyChangeSupport.firePropertyChange(event);
            this.oldValue = newValue;
        }
    }

    public void updateStatus(String newStatus) {
        if (this.isReady) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, STATUS_PROPERTY, this.oldStatus, newStatus);
            this.propertyChangeSupport.firePropertyChange(event);
            this.oldStatus = newStatus;
        }
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public boolean isReady() {
        return this.isReady;
    }
}

