/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.panel;

import java.awt.Cursor;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import org.igv.feature.Chromosome;
import org.igv.feature.RegionOfInterest;
import org.igv.ui.AbstractDataPanelTool;
import org.igv.ui.IGV;
import org.igv.ui.panel.DataPanel;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.util.UIUtilities;

public class RegionOfInterestTool
extends AbstractDataPanelTool {
    Integer roiStart = null;
    JButton roiButton;

    public RegionOfInterestTool(DataPanel owner, JButton roiButton) {
        super(owner, Cursor.getPredefinedCursor(1));
        this.roiButton = roiButton;
        this.setName("Region of Interest");
    }

    public int getRoiStart() {
        return this.roiStart == null ? 0 : this.roiStart;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        String chromosomeName;
        Chromosome chromosome;
        if (e.isPopupTrigger()) {
            return;
        }
        if (e.getClickCount() > 1) {
            return;
        }
        ReferenceFrame referenceFrame = this.getReferenceFame();
        if (e.getButton() == 1 && e.getClickCount() == 1 && (chromosome = referenceFrame.getChromosome()) != null && (chromosomeName = referenceFrame.getChrName()) != null) {
            int x = e.getX();
            if (this.roiStart == null) {
                this.roiStart = (int)referenceFrame.getChromosomePosition(x);
                UIUtilities.invokeOnEventThread(() -> this.getOwner().paintImmediately(this.getOwner().getBounds()));
            } else {
                try {
                    int roiEnd = (int)referenceFrame.getChromosomePosition(x);
                    int start = Math.min(this.roiStart, roiEnd);
                    int end = Math.max(this.roiStart, roiEnd);
                    if (start == end) {
                        ++end;
                    }
                    RegionOfInterest regionOfInterest = new RegionOfInterest(chromosomeName, start, end, null);
                    IGV.getInstance().endROI();
                    IGV.getInstance().addRegionOfInterest(regionOfInterest);
                    IGV.getInstance().repaint();
                }
                finally {
                    this.roiButton.setSelected(false);
                }
            }
        }
    }
}

