/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.genome;

import java.util.HashMap;
import java.util.Map;

public class GenomeListItem {
    String id;
    String path;
    String displayableName;
    Map<String, String> attributes;

    public GenomeListItem(String displayableName, String path, String id, Map<String, String> attributes) {
        this.id = id;
        this.path = path;
        this.displayableName = displayableName;
        this.attributes = attributes;
    }

    public GenomeListItem(String displayableName, String path, String id) {
        this.id = id;
        this.path = path;
        this.displayableName = displayableName;
        this.attributes = new HashMap<String, String>();
        this.attributes.put("common name", displayableName);
        this.attributes.put("url", path);
        this.attributes.put("assembly", id);
    }

    public String getAttributeValue(String name) {
        return this.attributes.get(name);
    }

    public String getId() {
        return this.id;
    }

    public String getPath() {
        return this.path;
    }

    public String getDisplayableName() {
        return this.displayableName;
    }

    public String toString() {
        return this.displayableName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenomeListItem)) {
            return false;
        }
        GenomeListItem that = (GenomeListItem)o;
        return this.id != null && this.id.equals(that.id) && this.path != null && this.path.equals(that.path);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }
}

