/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.commandbar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DropMode;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import org.igv.event.GenomeResetEvent;
import org.igv.event.IGVEventBus;
import org.igv.feature.genome.DotGenomeUtils;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.IGVDialog;
import org.igv.ui.genome.GenomeListItem;
import org.igv.ui.genome.GenomeListManager;
import org.igv.ui.util.MessageUtils;
import org.igv.util.LongRunningTask;

public class RemoveGenomesDialog
extends IGVDialog {
    public static final String LOCAL_SEQUENCE_CHAR = "*";
    private static final Logger log = LogManager.getLogger(RemoveGenomesDialog.class);
    private List<GenomeListItem> allListItems;
    private boolean haveLocalSequence = false;
    private JList<GenomeListItem> genomeList;
    private JLabel label2;

    public RemoveGenomesDialog(Frame owner) {
        super(owner);
        this.initComponents();
        this.initData();
        this.genomeList.setCellRenderer(new GenomeCellRenderer());
    }

    private void initData() {
        this.allListItems = new ArrayList<GenomeListItem>(GenomeListManager.getInstance().getGenomeTableRecords());
        for (GenomeListItem item : this.allListItems) {
            if (DotGenomeUtils.getLocalFasta(item.getId()) == null) continue;
            this.haveLocalSequence = true;
            break;
        }
        this.buildList();
        this.label2.setVisible(this.haveLocalSequence);
    }

    private void buildList() {
        String currentId = GenomeManager.getInstance().getGenomeId();
        List<GenomeListItem> filteredList = this.allListItems.stream().filter(item -> !item.getId().equals(currentId)).toList();
        this.genomeList.setListData((GenomeListItem[])filteredList.toArray(new GenomeListItem[0]));
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void saveButtonActionPerformed(ActionEvent event) {
        List<GenomeListItem> selectedValuesList = this.genomeList.getSelectedValuesList();
        Runnable runnable = () -> {
            if (selectedValuesList != null && !selectedValuesList.isEmpty()) {
                GenomeListManager.getInstance().removeItems(selectedValuesList);
                try {
                    GenomeManager.getInstance().deleteDownloadedGenomes(selectedValuesList);
                }
                catch (IOException e) {
                    log.error("Error deleting genome files", e);
                    MessageUtils.showErrorMessage("Error deleting genome files", e);
                }
                String lastGenomeKey = PreferencesManager.getPreferences().get("DEFAULT_GENOME_KEY");
                if (lastGenomeKey != null) {
                    for (GenomeListItem item : selectedValuesList) {
                        if (!lastGenomeKey.equals(item.getId())) continue;
                        PreferencesManager.getPreferences().remove("DEFAULT_GENOME_KEY");
                        break;
                    }
                }
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            }
        };
        LongRunningTask.submit(runnable);
        this.setVisible(false);
    }

    private void initComponents() {
        JPanel dialogPane = new JPanel();
        JTextArea label1 = new JTextArea();
        JPanel contentPanel = new JPanel();
        JScrollPane scrollPane1 = new JScrollPane();
        this.genomeList = new JList();
        this.label2 = new JLabel();
        JPanel panel1 = new JPanel();
        JPanel addRemBar = new JPanel();
        JSeparator separator1 = new JSeparator();
        JPanel buttonBar = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        this.setTitle("Remove Genomes");
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        dialogPane.setPreferredSize(new Dimension(270, 400));
        dialogPane.setLayout(new BorderLayout());
        label1.setRows(2);
        label1.setEditable(false);
        label1.setBackground(UIManager.getColor("Button.background"));
        label1.setWrapStyleWord(true);
        label1.setLineWrap(true);
        dialogPane.add((Component)label1, "North");
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        this.genomeList.setMaximumSize(new Dimension(39, 5000));
        this.genomeList.setDropMode(DropMode.INSERT);
        this.genomeList.setDragEnabled(true);
        scrollPane1.setViewportView(this.genomeList);
        contentPanel.add(scrollPane1);
        this.label2.setText("Sequence on local machine");
        this.label2.setLabelFor(this.genomeList);
        this.label2.setAlignmentX(1.0f);
        this.label2.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
        this.label2.setPreferredSize(new Dimension(400, 16));
        this.label2.setMaximumSize(new Dimension(400, 16));
        this.label2.setMinimumSize(new Dimension(100, 16));
        this.label2.setText(LOCAL_SEQUENCE_CHAR + this.label2.getText());
        contentPanel.add(this.label2);
        dialogPane.add((Component)contentPanel, "Center");
        panel1.setLayout(new BoxLayout(panel1, 1));
        addRemBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        addRemBar.setPreferredSize(new Dimension(196, 51));
        addRemBar.setMinimumSize(new Dimension(201, 51));
        addRemBar.setLayout(new FlowLayout(4, 1, 5));
        panel1.add(addRemBar);
        panel1.add(separator1);
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setPreferredSize(new Dimension(196, 51));
        buttonBar.setLayout(new FlowLayout(4));
        okButton.setText("Remove");
        okButton.setMaximumSize(new Dimension(93, 29));
        okButton.setMinimumSize(new Dimension(93, 29));
        okButton.setPreferredSize(new Dimension(93, 29));
        okButton.addActionListener(this::saveButtonActionPerformed);
        buttonBar.add(okButton);
        cancelButton.setText("Cancel");
        cancelButton.setMinimumSize(new Dimension(93, 29));
        cancelButton.setPreferredSize(new Dimension(93, 29));
        cancelButton.setMaximumSize(new Dimension(93, 29));
        cancelButton.addActionListener(this::cancelButtonActionPerformed);
        buttonBar.add(cancelButton);
        panel1.add(buttonBar);
        dialogPane.add((Component)panel1, "South");
        contentPane.add((Component)dialogPane, "Center");
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private class GenomeCellRenderer
    implements ListCellRenderer<GenomeListItem> {
        private GenomeCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends GenomeListItem> list, GenomeListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel comp = new JLabel(value.toString());
            Object displayableName = value.getDisplayableName();
            comp.setToolTipText(value.getPath());
            if (isSelected) {
                comp.setBackground(RemoveGenomesDialog.this.genomeList.getSelectionBackground());
                comp.setForeground(RemoveGenomesDialog.this.genomeList.getSelectionForeground());
                comp.setOpaque(isSelected);
            }
            if (DotGenomeUtils.getLocalFasta(value.getId()) != null) {
                displayableName = (String)displayableName + RemoveGenomesDialog.LOCAL_SEQUENCE_CHAR;
            }
            comp.setText((String)displayableName);
            return comp;
        }
    }
}

