/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingWorker;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ucsc.hub.Hub;
import org.igv.ucsc.hub.HubDescriptor;
import org.igv.ucsc.hub.HubParser;
import org.igv.ucsc.hub.TrackConfigContainer;
import org.igv.ucsc.hub.TrackSelectionDialog;
import org.igv.ui.IGV;
import org.igv.ui.WaitCursorManager;
import org.igv.ui.action.MenuAction;
import org.igv.ui.util.MessageUtils;
import org.igv.util.ResourceLocator;

public class SelectHubTracksAction
extends MenuAction {
    static Logger log = LogManager.getLogger(SelectHubTracksAction.class);
    private HubDescriptor hubDescriptor;
    String genomeId;

    public SelectHubTracksAction(String label, HubDescriptor hubDescriptor, String id) {
        super(label, null);
        this.hubDescriptor = hubDescriptor;
        this.genomeId = id;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        final WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        SwingWorker worker = new SwingWorker(){

            protected Object doInBackground() throws Exception {
                try {
                    Hub hub = HubParser.loadHub(SelectHubTracksAction.this.hubDescriptor.getUrl());
                    if (hub.getSupportedTrackCount(SelectHubTracksAction.this.genomeId) > 0) {
                        SelectHubTracksAction.selectAndLoadTracks(hub, SelectHubTracksAction.this.genomeId);
                    } else {
                        boolean bl = MessageUtils.confirm(SelectHubTracksAction.this.hubDescriptor.getShortLabel() + " does not have any IGV supported tracks for " + SelectHubTracksAction.this.genomeId);
                    }
                }
                catch (Exception e) {
                    log.error("Error loading track configurations", e);
                    MessageUtils.showMessage(e.getMessage());
                }
                finally {
                    if (token != null) {
                        WaitCursorManager.removeWaitCursor(token);
                    }
                }
                return null;
            }

            @Override
            protected void done() {
                WaitCursorManager.removeWaitCursor(token);
            }
        };
        worker.execute();
    }

    public static void selectAndLoadTracks(Hub hub, String id) {
        Set<String> loadedTrackPaths = IGV.getInstance().getAllTracks().stream().filter(t -> t.getResourceLocator() != null).map(t -> t.getResourceLocator().getPath()).collect(Collectors.toSet());
        TrackSelectionDialog dlg = TrackSelectionDialog.getTrackHubSelectionDialog(hub, id, loadedTrackPaths, false, null);
        dlg.setVisible(true);
        if (!dlg.isCanceled()) {
            List<TrackConfigContainer> groups = hub.getGroupedTrackConfigurations(id);
            ArrayList tracksToLoad = new ArrayList();
            ArrayList selected = new ArrayList();
            for (TrackConfigContainer g : groups) {
                g.map(config -> {
                    if (config.visible.booleanValue()) {
                        selected.add(config);
                        if (!loadedTrackPaths.contains(config.url)) {
                            tracksToLoad.add(config);
                        }
                    }
                    return null;
                });
            }
            List<ResourceLocator> locators = tracksToLoad.stream().map(t -> ResourceLocator.fromTrackConfig(t)).toList();
            IGV.getInstance().loadTracks(locators);
        }
    }
}

