/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.session.Session;
import org.igv.session.SessionWriter;
import org.igv.ui.IGV;
import org.igv.ui.action.MenuAction;
import org.igv.ui.action.SaveSessionMenuAction;
import org.igv.util.LongRunningTask;

public class ReloadTracksMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(SaveSessionMenuAction.class);
    IGV igv;

    public ReloadTracksMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String currentSessionFilePath = this.igv.getSession().getPath();
        Session currentSession = this.igv.getSession();
        currentSession.setPath(currentSessionFilePath);
        String xml = new SessionWriter().createXmlFromSession(currentSession, null);
        this.igv.resetSession(currentSessionFilePath);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(xml.getBytes());
        Runnable runnable = () -> {
            try {
                this.igv.loadSessionFromStream(currentSessionFilePath, inputStream);
            }
            catch (IOException ex) {
                log.error("Error reloading tracks", ex);
            }
        };
        LongRunningTask.submit(runnable);
    }
}

