/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.genome.load.HubGenomeLoader;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.session.SessionReader;
import org.igv.track.AttributeManager;
import org.igv.ucsc.hub.Hub;
import org.igv.ucsc.hub.HubParser;
import org.igv.ucsc.hub.HubRegistry;
import org.igv.ui.IGV;
import org.igv.ui.IGVMenuBar;
import org.igv.ui.action.MenuAction;
import org.igv.ui.util.LoadFromURLDialog;
import org.igv.ui.util.MessageUtils;
import org.igv.util.LongRunningTask;
import org.igv.util.ResourceLocator;

public class LoadFromURLMenuAction
extends MenuAction {
    public static final String LOAD_TRACKS_FROM_URL = "Load Tracks from URL...";
    public static final String LOAD_HUB_FROM_URL = "Add Track Hub from URL...";
    public static final String LOAD_SESSION_FROM_URL = "Load Session from URL...";
    public static final String LOAD_SAMPLEINFO_FROM_URL = "Load Sample Info from URL...";
    public static final String LOAD_GENOME_FROM_URL = "Load Genome from URL...";
    public static final String LOAD_FROM_HTSGET = "Load from htsget Server...";
    private static final Logger log = LogManager.getLogger(LoadFromURLMenuAction.class);
    private final IGV igv;

    public LoadFromURLMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String url;
        JPanel ta = new JPanel();
        ta.setPreferredSize(new Dimension(600, 20));
        String command = e.getActionCommand();
        boolean isHtsGet = command.equalsIgnoreCase(LOAD_FROM_HTSGET);
        if (command.equalsIgnoreCase(LOAD_TRACKS_FROM_URL) || isHtsGet) {
            LoadFromURLDialog dlg = new LoadFromURLDialog(IGV.getInstance().getMainFrame(), isHtsGet);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                List<String> urls = dlg.getFileURLs();
                if (urls.size() == 1 && SessionReader.isSessionFile(urls.get(0))) {
                    LongRunningTask.submit(() -> this.igv.loadSession((String)urls.get(0), null));
                } else {
                    this.loadUrls(urls, dlg.getIndexURLs(), isHtsGet);
                }
            }
        } else if (command.equalsIgnoreCase(LOAD_SAMPLEINFO_FROM_URL)) {
            String url2 = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to sample info file", -1);
            if (url2 != null && !url2.trim().isBlank()) {
                try {
                    ResourceLocator locator = new ResourceLocator(url2.trim());
                    LongRunningTask.submit(() -> {
                        AttributeManager.getInstance().loadSampleInfo(locator);
                        this.igv.revalidateTrackPanels();
                    });
                }
                catch (Exception ex) {
                    MessageUtils.showMessage("Error loading sample info: " + ex.getMessage());
                }
            }
        } else if (command.equalsIgnoreCase(LOAD_SESSION_FROM_URL)) {
            String url3 = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to .xml session file", -1);
            if (url3 != null && !url3.trim().isBlank()) {
                try {
                    LongRunningTask.submit(() -> this.igv.loadSession(url3.trim(), null));
                }
                catch (Exception ex) {
                    MessageUtils.showMessage("Error loading session: " + ex.getMessage());
                }
            }
        } else if (command.equalsIgnoreCase(LOAD_GENOME_FROM_URL)) {
            String url4 = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to .json, hub.txt, or FASTA file", -1);
            if (url4 != null && !url4.trim().isBlank()) {
                LoadFromURLMenuAction.loadGenomeFromUrl(url4.trim());
            }
        } else if (command.equalsIgnoreCase(LOAD_HUB_FROM_URL) && (url = JOptionPane.showInputDialog(IGV.getInstance().getMainFrame(), ta, "Enter URL to a  hub.txt file", -1)) != null && !url.trim().isBlank()) {
            LoadFromURLMenuAction.loadTrackHub(url.trim());
        }
    }

    private void loadUrls(List<String> inputs, List<String> indexes, boolean isHtsGet) {
        if (inputs.size() == 1 && HubGenomeLoader.isHubURL(inputs.getFirst())) {
            LoadFromURLMenuAction.loadTrackHub(inputs.getFirst());
        } else if (inputs.size() == 1 && SessionReader.isSessionFile(inputs.getFirst())) {
            String url = inputs.getFirst();
            try {
                LongRunningTask.submit(() -> this.igv.loadSession(url, null));
            }
            catch (Exception ex) {
                MessageUtils.showMessage("Error loading url: " + url + " (" + String.valueOf(ex) + ")");
            }
        } else {
            if (!indexes.isEmpty() && indexes.size() != inputs.size()) {
                throw new RuntimeException("The number of Index URLs must equal the number of File URLs");
            }
            List<ResourceLocator> locators = LoadFromURLMenuAction.getResourceLocators(inputs, indexes, isHtsGet);
            this.igv.addToRecentUrls(locators);
            this.igv.loadTracks(locators);
        }
    }

    private static void loadTrackHub(String url) {
        LongRunningTask.submit(() -> {
            try {
                Genome genome = GenomeManager.getInstance().getCurrentGenome();
                String id = genome != null ? genome.getUCSCId() : null;
                Hub hub = HubParser.loadHub(url);
                if (hub.isAssemblyHub() && (genome == null || !hub.getGenomeConfigs().get(0).getUcscID().equals(id))) {
                    HubGenomeLoader.loadAssemblyHub(hub);
                } else if (genome != null) {
                    HubRegistry.addUserHub(hub);
                    IGVMenuBar.getInstance().updateMenus(genome);
                }
            }
            catch (IOException ex) {
                log.error("Error loading tack hub", ex);
                MessageUtils.showMessage("Error loading track hub: " + ex.getMessage());
            }
        });
    }

    private static void loadGenomeFromUrl(String url) {
        if (url != null && !url.isBlank()) {
            url = url.trim();
            try {
                if (LoadFromURLMenuAction.isHubURL(url)) {
                    HubGenomeLoader.loadGenome(url);
                } else {
                    GenomeManager.getInstance().loadGenome(url);
                }
            }
            catch (Exception e) {
                MessageUtils.showMessage("Error loading genome: " + e.getMessage());
            }
        }
    }

    private static List<ResourceLocator> getResourceLocators(List<String> inputs, List<String> indexes, boolean isHtsGet) {
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        for (int i = 0; i < inputs.size(); ++i) {
            String url = inputs.get(i);
            ResourceLocator rl = new ResourceLocator(url.trim());
            if (!indexes.isEmpty()) {
                String indexUrl = indexes.get(i);
                rl.setIndexPath(indexUrl);
            }
            if (isHtsGet) {
                rl.setHtsget(true);
            }
            locators.add(rl);
        }
        return locators;
    }

    private static boolean isHubURL(String input) {
        return input.endsWith("/hub.txt");
    }
}

