/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.igv.track.AttributeManager;
import org.igv.track.Track;
import org.igv.ui.IGV;
import org.igv.ui.TrackFilterDialog;
import org.igv.ui.action.MenuAction;
import org.igv.ui.util.MessageUtils;
import org.igv.util.TrackFilter;

public class FilterTracksMenuAction
extends MenuAction {
    IGV igv;

    public FilterTracksMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<String> uniqueAttributeKeys = AttributeManager.getInstance().getAttributeNames();
        if (uniqueAttributeKeys == null && (uniqueAttributeKeys == null || uniqueAttributeKeys.isEmpty())) {
            MessageUtils.showMessage("No attributes found to use in a filter");
            return;
        }
        TrackFilter trackFilter = IGV.getInstance().getSession().getFilter();
        TrackFilterDialog dialog = new TrackFilterDialog(this.igv.getMainFrame(), "Filter Tracks", trackFilter);
        dialog.setVisible(true);
        if (!dialog.isCancelled()) {
            trackFilter = dialog.getFilter();
            this.filterTracks(trackFilter);
            this.igv.repaint();
        }
    }

    private void filterTracks(TrackFilter trackFilter) {
        if (trackFilter == null) {
            List<Track> tracks = IGV.getInstance().getAllTracks();
            IGV.getInstance().getSession().setFilter(null);
            for (Track track : tracks) {
                track.setVisible(true);
            }
        } else {
            IGV.getInstance().getSession().setFilter(trackFilter);
            trackFilter.evaluate();
        }
        for (Track track : IGV.getInstance().getAllTracks()) {
            track.filterSamples(trackFilter);
        }
    }
}

