/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.igv.track.AttributeManager;
import org.igv.ui.FilterComponent;
import org.igv.util.FilterElement;
import org.igv.util.TrackFilter;

public class TrackFilterDialog
extends JDialog {
    JPanel trackFilterPane;
    JScrollPane scrollPane;
    private JCheckBox showAllTracksFilterCheckBox;
    private JCheckBox matchAllCheckBox;
    private JCheckBox matchAnyCheckBox;
    private boolean cancelled = true;
    private List<String> attributeKeys;
    private final int vgap = 5;

    public TrackFilterDialog(Frame owner, String title, TrackFilter trackFilter) {
        super(owner, title, true);
        this.setLocationRelativeTo(owner);
        this.setResizable(true);
        this.init(trackFilter);
        this.setSize(700, 600);
    }

    private void init(TrackFilter trackFilter) {
        if (trackFilter == null) {
            trackFilter = new TrackFilter();
        }
        this.setLayout(new BorderLayout());
        JPanel filterHeaderPanel = new JPanel();
        filterHeaderPanel.setLayout(new GridLayout(0, 1));
        this.showAllTracksFilterCheckBox = new JCheckBox("Show all tracks");
        this.showAllTracksFilterCheckBox.setSelected(trackFilter.isShowAll());
        this.showAllTracksFilterCheckBox.addActionListener(e -> {
            this.matchAllCheckBox.setEnabled(!this.showAllTracksFilterCheckBox.isSelected());
            this.matchAnyCheckBox.setEnabled(!this.showAllTracksFilterCheckBox.isSelected());
        });
        filterHeaderPanel.add(this.showAllTracksFilterCheckBox);
        this.matchAllCheckBox = new JCheckBox("match all of the following");
        this.matchAnyCheckBox = new JCheckBox("match any of the following");
        this.matchAllCheckBox.setSelected(trackFilter.isMatchAll());
        this.matchAnyCheckBox.setSelected(!trackFilter.isMatchAll());
        ButtonGroup booleanButtonGroup = new ButtonGroup();
        booleanButtonGroup.add(this.matchAllCheckBox);
        booleanButtonGroup.add(this.matchAnyCheckBox);
        if (trackFilter.isShowAll()) {
            this.matchAllCheckBox.setEnabled(false);
            this.matchAnyCheckBox.setEnabled(false);
        } else {
            this.matchAllCheckBox.setEnabled(true);
            this.matchAnyCheckBox.setEnabled(true);
        }
        JPanel controls = new JPanel();
        FlowLayout layoutManager = new FlowLayout();
        layoutManager.setAlignment(0);
        controls.setLayout(layoutManager);
        controls.add(new JLabel("Show tracks that: "));
        controls.add(this.matchAllCheckBox);
        controls.add(this.matchAnyCheckBox);
        controls.add(Box.createHorizontalStrut(10));
        JButton addButton = new JButton("+");
        addButton.addActionListener(e -> this.addComponent());
        controls.add(addButton);
        filterHeaderPanel.add(controls);
        this.add((Component)filterHeaderPanel, "North");
        List<String> uniqueAttributeKeys = AttributeManager.getInstance().getAttributeNames();
        this.attributeKeys = uniqueAttributeKeys;
        this.trackFilterPane = new JPanel();
        this.trackFilterPane.setLayout(new FlowLayout(0));
        this.scrollPane = new JScrollPane(this.trackFilterPane);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        if (trackFilter.getFilterElements().hasNext()) {
            Iterator iterator = trackFilter.getFilterElements();
            while (iterator.hasNext()) {
                FilterElement element = (FilterElement)iterator.next();
                this.trackFilterPane.add(new FilterComponent(this, uniqueAttributeKeys, element));
            }
        } else {
            this.trackFilterPane.add(new FilterComponent(this, uniqueAttributeKeys, null));
        }
        this.add((Component)this.scrollPane, "Center");
        JPanel buttonBar = new JPanel(new FlowLayout(2));
        JButton okButton = new JButton("OK");
        JButton cancelButton = new JButton("Cancel");
        okButton.addActionListener(e -> {
            this.cancelled = false;
            this.setVisible(false);
            this.dispose();
        });
        cancelButton.addActionListener(e -> {
            this.cancelled = true;
            this.setVisible(false);
            this.dispose();
        });
        buttonBar.add(okButton);
        buttonBar.add(cancelButton);
        this.add((Component)buttonBar, "South");
    }

    public void addComponent() {
        this.trackFilterPane.add(new FilterComponent(this, this.attributeKeys, null));
        this.resizeFilterPane();
    }

    public void removeComponent(FilterComponent filterComponent) {
        if (this.trackFilterPane.getComponents().length < 2) {
            return;
        }
        this.trackFilterPane.remove(filterComponent);
        this.resizeFilterPane();
    }

    private void resizeFilterPane() {
        int h = 0;
        int w = 0;
        for (Component c : this.trackFilterPane.getComponents()) {
            h += c.getHeight() + 10;
            w = c.getWidth();
        }
        this.trackFilterPane.setPreferredSize(new Dimension(w, h));
        this.scrollPane.getViewport().revalidate();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public TrackFilter getFilter() {
        boolean matchAll = this.matchAllCheckBox.isSelected();
        boolean showAllTracks = this.showAllTracksFilterCheckBox.isSelected();
        ArrayList<FilterElement> filterElements = new ArrayList<FilterElement>();
        for (Component component : this.trackFilterPane.getComponents()) {
            if (!(component instanceof FilterComponent) || !((FilterComponent)component).isComplete()) continue;
            filterElements.add(((FilterComponent)component).getFilterElement(matchAll));
        }
        return new TrackFilter(showAllTracks, matchAll, filterElements);
    }
}

