/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.igv.renderer.DataRange;
import org.igv.track.MergedTracks;
import org.igv.track.Range;
import org.igv.track.ScalableTrack;
import org.igv.track.Track;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.ReferenceFrame;

public class Autoscaler {
    public static void autoscale(Collection<Track> trackList) {
        HashMap autoscaleGroups = new HashMap();
        for (Track track : trackList) {
            if (!track.isVisible()) continue;
            String asGroup = track.getAttributeValue("AUTOSCALE GROUP");
            if (asGroup != null) {
                if (!autoscaleGroups.containsKey(asGroup)) {
                    autoscaleGroups.put(asGroup, new ArrayList());
                }
                if (track instanceof MergedTracks) {
                    for (Track track2 : ((MergedTracks)track).getMemberTracks()) {
                        ((List)autoscaleGroups.get(asGroup)).add(track2);
                    }
                    continue;
                }
                ((List)autoscaleGroups.get(asGroup)).add(track);
                continue;
            }
            if (!track.getAutoScale()) continue;
            if (track instanceof MergedTracks) {
                ArrayList<Track> memberTracks = new ArrayList<Track>(((MergedTracks)track).getMemberTracks());
                Autoscaler.autoscaleGroup(memberTracks);
                continue;
            }
            Autoscaler.autoscaleGroup(Arrays.asList(track));
        }
        if (autoscaleGroups.size() > 0) {
            for (List tracks : autoscaleGroups.values()) {
                Autoscaler.autoscaleGroup(tracks);
            }
        }
    }

    private static void autoscaleGroup(List<Track> trackList) {
        List<ReferenceFrame> frames = FrameManager.isGeneListMode() ? FrameManager.getFrames() : Arrays.asList(FrameManager.getDefaultFrame());
        List<Range> inViewRanges = Collections.synchronizedList(new ArrayList());
        for (Track track : trackList) {
            if (!(track instanceof ScalableTrack)) continue;
            for (ReferenceFrame frame : frames) {
                Range r = ((ScalableTrack)((Object)track)).getInViewRange(frame);
                if (r == null) continue;
                inViewRanges.add(r);
            }
        }
        if (inViewRanges.size() > 0) {
            Range inter = Autoscaler.computeScale(inViewRanges);
            for (Track track : trackList) {
                DataRange dr = track.getDataRange();
                float min = Math.min(0.0f, inter.min);
                float base = min < 0.0f ? 0.0f : min;
                float max = inter.max;
                if (max - min <= 2.8E-45f) {
                    max = min + 1.0f;
                }
                DataRange newDR = new DataRange(min, base, max, dr.isDrawBaseline());
                newDR.setType(dr.getType());
                track.setDataRange(newDR);
            }
        }
    }

    public static Range computeScale(List<Range> ranges) {
        float min = 0.0f;
        float max = 0.0f;
        if (ranges.size() > 0) {
            max = ranges.get((int)0).max;
            min = ranges.get((int)0).min;
            for (int i = 1; i < ranges.size(); ++i) {
                Range r = ranges.get(i);
                max = Math.max(r.max, max);
                min = Math.min(r.min, min);
            }
        }
        return new Range(min, max);
    }
}

