/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.hub;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.igv.encode.FileRecord;
import org.igv.encode.TrackChooser;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ucsc.hub.CollapsiblePanel;
import org.igv.ucsc.hub.Hub;
import org.igv.ucsc.hub.HubParser;
import org.igv.ucsc.hub.TrackConfigContainer;
import org.igv.ui.FontManager;
import org.igv.ui.IGV;
import org.igv.ui.util.HyperlinkFactory;
import org.igv.ui.util.IconFactory;

public class TrackSelectionDialog
extends JDialog {
    private static Logger log = LogManager.getLogger(TrackSelectionDialog.class);
    private static Map<Hub, TrackSelectionDialog> hubSelectionDialogs = new HashMap<Hub, TrackSelectionDialog>();
    private Hub hub;
    private boolean autoselectDefaults;
    private ArrayList<CollapsiblePanel> categoryPanels;
    private boolean canceled = true;
    JTextPane messagePane;

    public static TrackSelectionDialog getTrackHubSelectionDialog(Hub hub, String genomeId, Set<String> loadedTrackPaths, boolean autoselectDefaults, String message) {
        TrackSelectionDialog dialog;
        if (hubSelectionDialogs.containsKey(hub) && !autoselectDefaults) {
            dialog = hubSelectionDialogs.get(hub);
            dialog.autoselectDefaults = autoselectDefaults;
        } else {
            Frame owner = IGV.getInstance().getMainFrame();
            List<TrackConfigContainer> groups = hub.getGroupedTrackConfigurations(genomeId);
            dialog = new TrackSelectionDialog(hub, groups, autoselectDefaults, owner);
            hubSelectionDialogs.put(hub, dialog);
        }
        dialog.resetSelectionBoxes(loadedTrackPaths);
        dialog.setMessage(message);
        return dialog;
    }

    private TrackSelectionDialog(Hub hub, List<TrackConfigContainer> trackConfigContainers, boolean autoselectDefaults, Frame owner) {
        super(owner);
        this.setModal(true);
        this.autoselectDefaults = autoselectDefaults;
        this.hub = hub;
        this.init(trackConfigContainers);
        this.setLocationRelativeTo(owner);
    }

    private void resetSelectionBoxes(Set<String> loadedTrackPaths) {
        for (CollapsiblePanel collapsiblePanel : this.categoryPanels) {
            collapsiblePanel.resetSelectionBoxes(loadedTrackPaths);
        }
    }

    public void setMessage(String message) {
        if (this.messagePane != null) {
            boolean hasMessage;
            JPanel topPanel = (JPanel)this.messagePane.getParent();
            boolean bl = hasMessage = message != null && !message.isEmpty();
            if (hasMessage) {
                this.messagePane.setText(message);
                if (topPanel == null) {
                    JPanel mainPanel = (JPanel)this.getRootPane().getContentPane().getComponent(0);
                    topPanel = (JPanel)mainPanel.getComponent(0);
                    topPanel.add((Component)this.messagePane, 0);
                }
                this.messagePane.setVisible(true);
            } else {
                if (topPanel != null) {
                    topPanel.remove(this.messagePane);
                }
                this.messagePane.setVisible(false);
            }
            if (topPanel != null) {
                topPanel.revalidate();
                topPanel.repaint();
            }
        }
    }

    void init(List<TrackConfigContainer> trackConfigContainers) {
        this.setTitle(this.hub.getLongLabel());
        Rectangle ownerBounds = this.getOwner().getBounds();
        this.setSize(new Dimension(Math.min(ownerBounds.width, 1200), Math.min(ownerBounds.height, 1000)));
        this.categoryPanels = new ArrayList();
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        this.add(mainPanel);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        this.messagePane = new JTextPane();
        this.messagePane.setBorder(BorderFactory.createEmptyBorder(30, 5, 20, 5));
        this.messagePane.setFont(FontManager.getFont(1, 16));
        this.messagePane.setEditable(false);
        this.messagePane.setVisible(false);
        topPanel.add(this.getLabeledHyperlink("Hub URL: ", this.hub.getUrl()));
        String descriptionURL = this.hub.getDescriptionURL();
        if (descriptionURL != null) {
            topPanel.add(this.getLabeledHyperlink("Description: ", descriptionURL));
        }
        JPanel topButtonPanel = new JPanel();
        topButtonPanel.setLayout(new BorderLayout());
        JPanel expandButtonPanel = new JPanel();
        expandButtonPanel.setLayout(new FlowLayout(2));
        JButton expandAllButton = new JButton("Expand All");
        expandAllButton.addActionListener(e -> {
            this.categoryPanels.forEach(cp -> cp.expand());
            this.revalidate();
        });
        expandButtonPanel.add(expandAllButton);
        JButton collapseAllButton = new JButton("Collapse All");
        collapseAllButton.addActionListener(e -> {
            this.categoryPanels.forEach(cp -> cp.collapse());
            this.revalidate();
        });
        expandButtonPanel.add(collapseAllButton);
        topButtonPanel.add((Component)expandButtonPanel, "West");
        topPanel.add(topButtonPanel);
        mainPanel.add((Component)topPanel, "North");
        JPanel categoryContainer = new JPanel();
        categoryContainer.setLayout(new BoxLayout(categoryContainer, 1));
        JScrollPane scrollPane = new JScrollPane(categoryContainer);
        mainPanel.add((Component)scrollPane, "Center");
        int count = 0;
        for (TrackConfigContainer trackConfigContainer : trackConfigContainers) {
            count += trackConfigContainer.countTracks();
        }
        boolean catSearch = count > 10000;
        for (TrackConfigContainer configGroup : trackConfigContainers) {
            categoryContainer.add(Box.createVerticalStrut(10));
            CollapsiblePanel categoryPanel = this.createCategoryPanel(configGroup, catSearch);
            categoryContainer.add(categoryPanel);
            this.categoryPanels.add(categoryPanel);
        }
        if (!catSearch) {
            JButton jButton = TrackSelectionDialog.createSearchButton("Search " + this.hub.getShortLabel(), this.categoryPanels, selectedCount -> {
                this.categoryPanels.stream().forEach(p -> p.updateLabel());
                return null;
            });
            topButtonPanel.add((Component)jButton, "East");
        }
        JPanel jPanel = new JPanel();
        ((FlowLayout)jPanel.getLayout()).setAlignment(2);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.canceled = true;
            this.setVisible(false);
        });
        JButton okButton = new JButton("OK");
        okButton.addActionListener(e -> {
            this.canceled = false;
            this.setVisible(false);
        });
        jPanel.add(okButton);
        jPanel.add(cancelButton);
        this.getRootPane().setDefaultButton(okButton);
        mainPanel.add((Component)jPanel, "South");
    }

    private JPanel getLabeledHyperlink(String label, String url) {
        JPanel hubURLPanel = new JPanel();
        ((FlowLayout)hubURLPanel.getLayout()).setAlignment(0);
        hubURLPanel.setBorder(BorderFactory.createEmptyBorder(2, 6, 0, 0));
        hubURLPanel.add(new JLabel(label));
        hubURLPanel.add(HyperlinkFactory.createLink(url, url));
        return hubURLPanel;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private CollapsiblePanel createCategoryPanel(TrackConfigContainer configGroup, boolean search) {
        boolean autoselectGenes = this.autoselectDefaults && configGroup.name.toLowerCase().equals("genes");
        return new CollapsiblePanel(configGroup, autoselectGenes, search);
    }

    public List<TrackConfig> getSelectedConfigs() {
        ArrayList<TrackConfig> selectedConfigs = new ArrayList<TrackConfig>();
        for (CollapsiblePanel collapsiblePanel : this.categoryPanels) {
            selectedConfigs.addAll(collapsiblePanel.getSelectedTracks());
        }
        return selectedConfigs;
    }

    public static JButton createSearchButton(String label, List<CollapsiblePanel> panels, Function<Integer, Void> callback) {
        JButton searchButton = new JButton("Search");
        searchButton.addActionListener(e -> {
            LinkedHashSet<String> attributeNames = new LinkedHashSet<String>();
            attributeNames.add("Name");
            attributeNames.add("Description");
            if (panels.size() > 1) {
                attributeNames.add("Group");
            }
            HashMap<FileRecord, CollapsiblePanel.SelectionBox> recordSelectionBoxMap = new HashMap<FileRecord, CollapsiblePanel.SelectionBox>();
            ArrayList<FileRecord> records = new ArrayList<FileRecord>();
            for (CollapsiblePanel panel : panels) {
                for (CollapsiblePanel.SelectionBox selectionBox : panel.selectionBoxes) {
                    if (!selectionBox.isEnabled()) continue;
                    TrackConfig trackConfig = selectionBox.getTrackConfig();
                    Map<String, String> trackConfigAttributes = trackConfig.attributes;
                    Map<String, String> attributes = trackConfigAttributes;
                    if (attributes == null) {
                        attributes = new LinkedHashMap<String, String>();
                    }
                    attributes.put("Group", panel.containerLabel());
                    attributes.put("Name", trackConfig.name);
                    attributes.put("Description", trackConfig.description);
                    if (trackConfigAttributes != null) {
                        attributes.putAll(trackConfigAttributes);
                        attributeNames.addAll(trackConfigAttributes.keySet());
                    }
                    FileRecord record = new FileRecord(trackConfig.url, attributes);
                    record.setSelected(trackConfig.visible);
                    records.add(record);
                    recordSelectionBoxMap.put(record, selectionBox);
                }
            }
            List headings = new ArrayList(attributeNames);
            if (headings.size() > 15) {
                headings = headings.subList(0, 15);
            }
            Frame owner = IGV.hasInstance() ? IGV.getInstance().getMainFrame() : null;
            TrackChooser chooser = new TrackChooser(owner, headings, records, label);
            if (owner != null) {
                Rectangle ownerBounds = owner.getBounds();
                chooser.setSize(new Dimension(Math.min(ownerBounds.width, 1200), Math.min(ownerBounds.height, 800)));
                chooser.setLocationRelativeTo(owner);
            }
            chooser.setVisible(true);
            if (!chooser.isCanceled()) {
                HashSet<FileRecord> selectedRecords = new HashSet<FileRecord>(chooser.getSelectedRecords());
                for (Map.Entry entry : recordSelectionBoxMap.entrySet()) {
                    ((CollapsiblePanel.SelectionBox)entry.getValue()).setSelected(selectedRecords.contains(entry.getKey()));
                }
                callback.apply(selectedRecords.size());
            }
        });
        return searchButton;
    }

    public static void main(String[] args) throws InterruptedException, InvocationTargetException, IOException {
        String hubFile = "https://hgdownload.soe.ucsc.edu/gbdb/hs1/hubs/public/hub.txt";
        Hub hub = HubParser.loadHub(hubFile);
        List<TrackConfigContainer> groupedTrackConfigurations = hub.getGroupedTrackConfigurations("hs1");
        TrackSelectionDialog dlf = new TrackSelectionDialog(hub, groupedTrackConfigurations, true, null);
        dlf.setSize(new Dimension(800, 600));
        dlf.setVisible(true);
        for (TrackConfig config : dlf.getSelectedConfigs()) {
            System.out.println(config.name);
        }
    }

    static class CheckBox
    extends JLabel {
        boolean selected = false;
        Icon checkedIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.CHECKBOX);
        Icon uncheckedIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.CHECKBOX_UNCHECKED);
        private ActionListener actionListener;

        public CheckBox() {
            this.setIcon(this.selected ? this.checkedIcon : this.uncheckedIcon);
            this.setVerticalAlignment(3);
            this.setSize(new Dimension(16, 16));
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.setSelected(!selected);
                    if (actionListener != null) {
                        actionListener.actionPerformed(new ActionEvent(this, 0, ""));
                    }
                }
            });
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
            this.setIcon(selected ? this.checkedIcon : this.uncheckedIcon);
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setActionListener(ActionListener l) {
            this.actionListener = l;
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(16, 16);
        }
    }

    static class CheckBoxWrapper {
        CheckBox checkBox;
        JCheckBox jCheckBox;

        public CheckBoxWrapper(CollapsiblePanel.SelectionBox.CheckboxType checkboxType) {
            if (checkboxType == CollapsiblePanel.SelectionBox.CheckboxType.SWING) {
                this.jCheckBox = new JCheckBox();
            } else {
                this.checkBox = new CheckBox();
            }
        }

        public JComponent getComponent() {
            return this.checkBox != null ? this.checkBox : this.jCheckBox;
        }

        public void setSelected(boolean selected) {
            if (this.checkBox != null) {
                this.checkBox.setSelected(selected);
            } else {
                this.jCheckBox.setSelected(selected);
            }
        }

        public boolean isSelected() {
            return this.checkBox != null ? this.checkBox.isSelected() : this.jCheckBox.isSelected();
        }

        public void setActionListener(ActionListener l) {
            if (this.checkBox != null) {
                this.checkBox.setActionListener(l);
            } else {
                this.jCheckBox.addActionListener(l);
            }
        }

        public void setEnabled(boolean enabled) {
            if (this.checkBox != null) {
                this.checkBox.setEnabled(enabled);
            } else {
                this.jCheckBox.setEnabled(enabled);
            }
        }

        public boolean isEnabled() {
            return this.checkBox != null ? this.checkBox.isEnabled() : this.jCheckBox.isEnabled();
        }
    }
}

