/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import htsjdk.tribble.Feature;
import htsjdk.variant.vcf.VCFHeader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.BedPEParser;
import org.igv.bedpe.BedPESource;
import org.igv.bedpe.HicInteractionTrack;
import org.igv.bedpe.HicSource;
import org.igv.bedpe.InteractParser;
import org.igv.bedpe.InteractionTrack;
import org.igv.bedpe.WrappedInteractionSource;
import org.igv.blast.BlastMapping;
import org.igv.blast.BlastParser;
import org.igv.data.DatasetDataSource;
import org.igv.data.IGVDataset;
import org.igv.data.WiggleDataset;
import org.igv.data.WiggleParser;
import org.igv.data.cufflinks.CufflinksDataSource;
import org.igv.data.cufflinks.CufflinksParser;
import org.igv.data.cufflinks.CufflinksTrack;
import org.igv.data.cufflinks.ExpDiffCodec;
import org.igv.data.cufflinks.FPKMTrackingCodec;
import org.igv.data.cufflinks.FPKMValue;
import org.igv.data.expression.ExpressionDataset;
import org.igv.data.expression.ExpressionFileParser;
import org.igv.exceptions.DataLoadException;
import org.igv.feature.BasePairFileUtils;
import org.igv.feature.CytoBandFileParser;
import org.igv.feature.DataURLParser;
import org.igv.feature.GisticFileParser;
import org.igv.feature.MutationTrackLoader;
import org.igv.feature.ShapeFileUtils;
import org.igv.feature.basepair.BasePairTrack;
import org.igv.feature.bionano.SMAPParser;
import org.igv.feature.bionano.SMAPRenderer;
import org.igv.feature.cyto.CytobandTrack;
import org.igv.feature.dranger.DRangerParser;
import org.igv.feature.dsi.DSIRenderer;
import org.igv.feature.dsi.DSITrack;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.genome.load.GenbankParser;
import org.igv.feature.gff.GFFFeatureSource;
import org.igv.feature.sprite.ClusterParser;
import org.igv.feature.sprite.ClusterTrack;
import org.igv.feature.tribble.CodecFactory;
import org.igv.feature.tribble.FeatureFileHeader;
import org.igv.feature.tribble.GFFCodec;
import org.igv.feature.tribble.TribbleIndexNotFoundException;
import org.igv.gwas.GWASData;
import org.igv.gwas.GWASParser;
import org.igv.gwas.GWASTrack;
import org.igv.htsget.HtsgetUtils;
import org.igv.htsget.HtsgetVariantSource;
import org.igv.lists.GeneList;
import org.igv.lists.GeneListManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.maf.MultipleAlignmentTrack;
import org.igv.prefs.PreferencesManager;
import org.igv.renderer.HeatmapRenderer;
import org.igv.renderer.MutationRenderer;
import org.igv.renderer.PointsRenderer;
import org.igv.sam.AlignmentDataManager;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.EWigTrack;
import org.igv.sam.reader.IndexNotFoundException;
import org.igv.seg.CNFreqTrack;
import org.igv.seg.FreqData;
import org.igv.seg.SegTrack;
import org.igv.seg.SegmentFileParser;
import org.igv.seg.SegmentedDataSet;
import org.igv.tdf.TDFDataSource;
import org.igv.tdf.TDFReader;
import org.igv.track.AbstractTrack;
import org.igv.track.AttributeManager;
import org.igv.track.DataSourceTrack;
import org.igv.track.DataTrack;
import org.igv.track.FeatureCollectionSource;
import org.igv.track.FeatureDirSource;
import org.igv.track.FeatureSource;
import org.igv.track.FeatureTrack;
import org.igv.track.FileFormatUtils;
import org.igv.track.GisticTrack;
import org.igv.track.Track;
import org.igv.track.TrackProperties;
import org.igv.track.TrackType;
import org.igv.track.TribbleFeatureSource;
import org.igv.track.TribbleListFeatureSource;
import org.igv.track.WindowFunction;
import org.igv.ucsc.bb.BBDataSource;
import org.igv.ucsc.bb.BBFeatureSource;
import org.igv.ucsc.bb.BBFile;
import org.igv.ui.IGV;
import org.igv.ui.util.ConfirmDialog;
import org.igv.ui.util.ConvertFileDialog;
import org.igv.ui.util.ConvertOptions;
import org.igv.ui.util.MessageUtils;
import org.igv.util.FileUtils;
import org.igv.util.GoogleUtils;
import org.igv.util.HttpUtils;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;
import org.igv.variant.VariantTrack;
import org.igv.variant.util.PedigreeUtils;

public class TrackLoader {
    private static Logger log = LogManager.getLogger(TrackLoader.class);
    private static Collection<? extends Class> NOLogExceptions = Arrays.asList(TribbleIndexNotFoundException.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Track> load(ResourceLocator locator, Genome genome) throws DataLoadException {
        String path = locator.getPath().trim();
        log.info("Loading resource:  " + (locator.isDataURL() ? "<data url>" : path));
        try {
            String format = locator.getFormat();
            if ("bed".equals(format)) {
                try {
                    String tmp;
                    if (locator.isDataUrl()) {
                        String dataURL = locator.getPath();
                        int commaIndex = dataURL.indexOf(44);
                        String contents = URLDecoder.decode(dataURL.substring(commaIndex + 1), StandardCharsets.UTF_8);
                        tmp = FileFormatUtils.determineFormat(contents.getBytes());
                    } else {
                        tmp = FileFormatUtils.determineFormat(locator.getPath());
                    }
                    if (tmp != null && !tmp.equals("sampleinfo")) {
                        format = tmp;
                        locator.setFormat(format);
                    }
                }
                catch (IOException ex) {
                    log.error("Error determining file format ", ex);
                }
            }
            if (format.equals("tbi")) {
                MessageUtils.showMessage("<html><b>Error:</b>File type '.tbi' is not recognized.  If this is a 'tabix' index <br> load the associated gzipped file, which should have an extension of '.gz'");
            }
            ArrayList<Track> newTracks = new ArrayList<Track>();
            if (locator.isHtsget()) {
                HtsgetUtils.Metadata htsgetMeta = HtsgetUtils.getMetadata(locator.getPath());
                locator.setFormat(htsgetMeta.getFormat().toLowerCase());
                if (htsgetMeta.getFormat().equals("VCF")) {
                    locator.setHtsget(true);
                    HtsgetVariantSource source = new HtsgetVariantSource(htsgetMeta, genome);
                    this.loadVCFWithSource(locator, source, newTracks);
                } else {
                    if (!htsgetMeta.getFormat().equals("BAM") && !htsgetMeta.getFormat().equals("CRAM")) throw new RuntimeException("Format: '" + htsgetMeta.getFormat() + "' is not supported for htsget servers.");
                    locator.setHtsget(true);
                    this.loadAlignmentsTrack(locator, newTracks, genome);
                }
            } else if (format.equals("gmt")) {
                this.loadGMT(locator);
            } else if (format.equals("vcf.list")) {
                this.loadVCFListFile(locator, newTracks, genome);
            } else if (format.equals("trio")) {
                this.loadTrioData(locator);
            } else if (format.equals("gct")) {
                this.loadGctFile(locator, newTracks, genome);
            } else if (format.equals("gbk") || format.equals("gb")) {
                this.loadGbkFile(locator, newTracks, genome);
            } else if (format.equals("cn") || format.equals("xcn") || format.equals("snp") || format.equals("igv") || format.equals("loh")) {
                this.loadIGVFile(locator, newTracks, genome);
            } else if (format.equals("cbs") || format.equals("seg") || format.equals("glad") || format.equals("birdseye_canary_calls") || format.equals("seg.zip")) {
                this.loadSegFile(locator, newTracks, genome);
            } else if (format.equals("gistic")) {
                this.loadGisticFile(locator, newTracks);
            } else if (format.contains("tabblastn") || format.equals("orthologs")) {
                this.loadBlastMapping(locator, newTracks);
            } else if (TrackLoader.isAlignmentTrack(format) || path.startsWith("http") && path.contains("/query.cgi?")) {
                this.loadAlignmentsTrack(locator, newTracks, genome);
            } else if (format.equals("shape") || format.equals("map")) {
                this.convertLoadShapeFile(locator, newTracks, genome);
            } else if (format.equals("wig") || format.equals("bedgraph") || format.equals("bdg") || format.equals("cpg") || format.equals("expr")) {
                this.loadWigFile(locator, newTracks, genome);
            } else if (format.equals("fpkm_tracking") || format.equals("gene_exp.diff") || format.equals("cds_exp.diff")) {
                this.loadCufflinksFile(locator, newTracks, genome);
            } else if (format.contains(".dranger")) {
                this.loadDRangerFile(locator, newTracks, genome);
            } else if (format.equals("ewig.tdf")) {
                this.loadEwigIBFFile(locator, newTracks, genome);
            } else if (format.equals("bw") || format.equals("bb") || format.equals("bigwig") || format.equals("bigbed") || format.equals("biggenepred") || format.equals("bigrepmsk")) {
                this.loadBBFile(locator, newTracks, genome);
            } else if (format.equals("ibf") || format.equals("tdf")) {
                this.loadTDFFile(locator, newTracks, genome);
            } else if (WiggleParser.isWiggle(locator)) {
                this.loadWigFile(locator, newTracks, genome);
            } else if (format.equals("maf.dict")) {
                this.loadMultipleAlignmentTrack(locator, newTracks, genome);
            } else if (format.equals("db") || format.equals("dbn")) {
                this.convertLoadStructureFile(locator, newTracks, genome, "dotBracket");
            } else if (format.equals("ct")) {
                this.convertLoadStructureFile(locator, newTracks, genome, "connectTable");
            } else if (format.equals("dp")) {
                this.convertLoadStructureFile(locator, newTracks, genome, "pairingProb");
            } else if (format.equals("bp")) {
                this.loadBasePairFile(locator, newTracks, genome);
            } else if (GWASParser.isGWASFile(format)) {
                this.loadGWASFile(locator, newTracks, genome);
            } else if (format.equals("list")) {
                this.loadListFile(locator, newTracks, genome);
            } else if (format.equals("smap")) {
                this.loadSMAPFile(locator, newTracks, genome);
            } else if (format.equals("dsi")) {
                this.loadDSIFile(locator, newTracks, genome);
            } else if (format.equals("bedpe") || format.equals("interact") || format.equals("hic")) {
                this.loadBedPEFile(locator, newTracks, genome);
            } else if (format.equals("clusters")) {
                this.loadClusterFile(locator, newTracks, genome);
            } else if (CodecFactory.hasCodec(locator, genome) && !this.forceNotTribble(format)) {
                this.loadTribbleFile(locator, newTracks, genome);
            } else if (MutationTrackLoader.isMutationAnnotationFile(locator)) {
                this.loadMutFile(locator, newTracks, genome);
            } else if (format.equals("maf")) {
                this.loadMultipleAlignmentTrack(locator, newTracks, genome);
            } else {
                String determinedFormat = FileFormatUtils.determineFormat(locator.getPath());
                if (determinedFormat != null && !determinedFormat.equals("sampleinfo") && !determinedFormat.equals(format)) {
                    locator.setFormat(determinedFormat);
                    return this.load(locator, genome);
                }
                int tenMB = 10000000;
                long fileLength = ParsingUtils.getContentLength(locator.getPath());
                if (fileLength > 10000000L) {
                    MessageUtils.confirm("<html>Cannot determine file type of: " + locator.getPath());
                    return newTracks;
                }
                String contents = FileUtils.getContents(locator.getPath());
                BufferedReader reader = new BufferedReader(new StringReader(contents));
                if (CytoBandFileParser.isValid(reader, locator.getPath())) {
                    CytobandTrack track = new CytobandTrack(locator, new BufferedReader(new StringReader(contents)), genome);
                    newTracks.add(track);
                } else if ("sampleinfo".equals(determinedFormat)) {
                    AttributeManager.getInstance().loadSampleInfo(locator);
                } else {
                    MessageUtils.showMessage("<html>Unknown file type: " + path + "<br>Check file extension");
                }
            }
            if (newTracks.size() <= 0) return newTracks;
            TrackProperties tp = null;
            String trackLine = locator.getTrackLine();
            if (trackLine != null) {
                tp = new TrackProperties();
                ParsingUtils.parseTrackLine(trackLine, tp);
            }
            for (Track track : newTracks) {
                if (locator.getFeatureInfoURL() != null) {
                    track.setFeatureInfoURL(locator.getFeatureInfoURL());
                }
                if (locator.getLabelField() != null && track instanceof FeatureTrack) {
                    ((FeatureTrack)track).setLabelField(locator.getLabelField());
                }
                if (tp != null) {
                    track.setProperties(tp);
                }
                if (locator.getColor() != null) {
                    track.setColor(locator.getColor());
                }
                if (locator.getSampleId() != null) {
                    track.setSampleId(locator.getSampleId());
                }
                if (locator.getAutoscaleGroup() == null) continue;
                track.setAttributeValue("AUTOSCALE GROUP", locator.getAutoscaleGroup());
            }
            return newTracks;
        }
        catch (Exception e) {
            if (NOLogExceptions.contains(e.getClass())) throw new DataLoadException(e.getMessage());
            log.error(e.getMessage(), e);
            throw new DataLoadException(e.getMessage());
        }
    }

    public static boolean isAlignmentTrack(String typeString) {
        if (typeString == null) {
            return false;
        }
        return typeString.equals("sam") || typeString.equals("bam") || typeString.equals("cram") || typeString.equals("sam.list") || typeString.equals("bam.list") || typeString.equals("aligned") || typeString.equals("sai") || typeString.equals("bedz") || typeString.equals("bai") || typeString.equals("csi") || typeString.equals("alist");
    }

    private void loadSMAPFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        List<Feature> features = SMAPParser.parseFeatures(locator, genome);
        FeatureCollectionSource src = new FeatureCollectionSource(features, genome);
        FeatureTrack track = new FeatureTrack(locator, locator.getName(), (FeatureSource)src);
        track.setRenderer(new SMAPRenderer());
        track.setDisplayMode(Track.DisplayMode.EXPANDED);
        newTracks.add(track);
    }

    private boolean forceNotTribble(String typeString) {
        List<String> nonTribble = Arrays.asList("fpkm_tracking", "exp_diff", "_exp.diff");
        for (String s : nonTribble) {
            if (!typeString.endsWith(s)) continue;
            return true;
        }
        return false;
    }

    private void loadGMT(ResourceLocator locator) throws IOException {
        List<GeneList> lists = GeneListManager.getInstance().loadGMTFile(locator.getPath());
        if (lists.size() == 1) {
            GeneList gl = lists.get(0);
            IGV.getInstance().setGeneList(gl, true);
        } else {
            MessageUtils.showMessage("Loaded " + lists.size() + " gene lists.");
        }
    }

    private void loadVCF(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException, TribbleIndexNotFoundException {
        TribbleFeatureSource src = TribbleFeatureSource.getFeatureSource(locator, genome);
        this.loadVCFWithSource(locator, src, newTracks);
    }

    private void loadVCFWithSource(ResourceLocator locator, FeatureSource src, List<Track> newTracks) throws IOException {
        VCFHeader header = (VCFHeader)src.getHeader();
        boolean enableMethylationRateSupport = header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null;
        ArrayList<String> allSamples = new ArrayList<String>(header.getGenotypeSamples());
        VariantTrack t = new VariantTrack(locator, src, allSamples, enableMethylationRateSupport);
        t.setMargin(0);
        newTracks.add(t);
    }

    private void loadVCFListFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException, TribbleIndexNotFoundException {
        TribbleListFeatureSource src = new TribbleListFeatureSource(locator.getPath(), genome);
        VCFHeader header = (VCFHeader)src.getHeader();
        boolean enableMethylationRateSupport = header.getFormatHeaderLine("MR") != null && header.getFormatHeaderLine("GB") != null;
        ArrayList<String> allSamples = new ArrayList<String>(header.getGenotypeSamples());
        VariantTrack t = new VariantTrack(locator, src, allSamples, enableMethylationRateSupport);
        t.setMargin(0);
        newTracks.add(t);
    }

    private void loadBlastMapping(ResourceLocator locator, List<Track> newTracks) {
        List<BlastMapping> mappings = new BlastParser().parse(locator.getPath());
        ArrayList<BlastMapping> features = new ArrayList<BlastMapping>(mappings.size());
        features.addAll(mappings);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        FeatureTrack track = new FeatureTrack(locator, new FeatureCollectionSource(features, genome));
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadDRangerFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        DRangerParser parser = new DRangerParser();
        newTracks.addAll(parser.loadTracks(locator, genome));
    }

    private void loadBedPEFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        String format = locator.getFormat();
        if ("hic".equals(format)) {
            HicSource source = new HicSource(locator.getPath(), genome);
            newTracks.add(new HicInteractionTrack(locator, source));
        } else {
            List<BedPE> features = "interact".equals(format) ? InteractParser.parse(locator, genome) : BedPEParser.parse(locator, genome);
            BedPESource featureSource = new BedPESource(features, genome);
            WrappedInteractionSource source = new WrappedInteractionSource(featureSource);
            newTracks.add(new InteractionTrack(locator, source));
        }
    }

    private void loadClusterFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        ClusterParser.ClusterSet features = ClusterParser.parse(locator.getPath());
        newTracks.add(new ClusterTrack(locator, features, genome));
    }

    private void loadTribbleFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException, TribbleIndexNotFoundException {
        String format = locator.getFormat();
        if (MutationTrackLoader.isMutationAnnotationFile(locator)) {
            this.loadMutFile(locator, newTracks, genome);
        } else if (VariantTrack.isVCF(format)) {
            this.loadVCF(locator, newTracks, genome);
        } else {
            String path;
            FeatureSource src;
            if (locator.isDataURL()) {
                DataURLParser parser = new DataURLParser();
                parser.parseFeatures(locator.getPath(), format, genome);
                src = new FeatureCollectionSource(parser.getFeatures(), genome);
                TrackProperties tp = parser.getTrackProperties();
                if (tp != null) {
                    ((FeatureCollectionSource)src).setHeader(tp);
                }
            } else {
                TribbleFeatureSource tribbleFeatureSource = TribbleFeatureSource.getFeatureSource(locator, genome);
                if (GFFFeatureSource.isGFF(locator.getPath())) {
                    GFFCodec codec = (GFFCodec)CodecFactory.getCodec(locator, genome);
                    src = new GFFFeatureSource(tribbleFeatureSource, codec.getVersion());
                } else {
                    src = tribbleFeatureSource;
                }
            }
            AbstractTrack t = "interact".equals(locator.format) ? new InteractionTrack(locator, new WrappedInteractionSource(src)) : new FeatureTrack(locator, src);
            Object header = src.getHeader();
            if (header != null && header instanceof FeatureFileHeader) {
                FeatureFileHeader ffh = (FeatureFileHeader)header;
                if (ffh.getTrackType() != null) {
                    t.setTrackType(ffh.getTrackType());
                }
                if (ffh.getTrackProperties() != null) {
                    TrackProperties tp = ffh.getTrackProperties();
                    t.setProperties(tp);
                    t.setTrackLine(tp.getTrackLine());
                }
                if (ffh.getTrackType() == TrackType.REPMASK) {
                    t.setHeight(15);
                }
            }
            if ((path = locator.getPath().toLowerCase()).contains(".narrowpeak") || locator.getPath().contains(".broadpeak") || locator.getPath().contains(".gappedpeak") || locator.getPath().contains(".regionpeak")) {
                t.setUseScore(true);
            }
            newTracks.add(t);
        }
    }

    private void loadDSIFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException, TribbleIndexNotFoundException {
        TribbleFeatureSource tribbleFeatureSource = TribbleFeatureSource.getFeatureSource(locator, genome);
        DSITrack t = new DSITrack(locator, tribbleFeatureSource);
        t.setName(locator.getTrackName());
        Object header = tribbleFeatureSource.getHeader();
        if (header != null && header instanceof TrackProperties) {
            TrackProperties tp = (TrackProperties)header;
            t.setProperties(tp);
            t.setTrackLine(tp.getTrackLine());
        }
        t.setRenderer(new DSIRenderer());
        newTracks.add(t);
    }

    private void loadGWASFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        GWASParser gwasParser = new GWASParser(locator, genome);
        GWASData gwasData = gwasParser.parse();
        GWASTrack gwasTrack = new GWASTrack(locator, locator.getPath(), locator.getFileName(), gwasData, gwasParser.getColumnHeaders(), gwasParser.delimiter, genome);
        newTracks.add(gwasTrack);
    }

    private void loadGctFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        if (locator.isLocal() && !TrackLoader.checkSize(locator)) {
            return;
        }
        ExpressionFileParser parser = null;
        ExpressionDataset ds = null;
        parser = new ExpressionFileParser(locator, null, genome);
        ds = parser.createDataset();
        if (ds.isEmpty()) {
            String message = "The probes in the file <br>&nbsp;&nbsp;&nbsp;" + locator.getPath() + "<br>could not be mapped to genomic positions.";
            MessageUtils.showMessage(message);
        } else {
            ds.setName(locator.getTrackName());
            ds.setNormalized(true);
            ds.setLogValues(true);
            TrackProperties trackProperties = ds.getTrackProperties();
            String path = locator.getPath();
            for (String trackName : ds.getTrackNames()) {
                DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, genome);
                String trackId = path + "_" + trackName;
                DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
                track.setRenderer(new HeatmapRenderer());
                track.setProperties(trackProperties);
                newTracks.add(track);
            }
        }
    }

    private void loadGbkFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        GenbankParser genbankParser = new GenbankParser(locator.getPath());
        genbankParser.readFeatures(false);
        FeatureCollectionSource src = new FeatureCollectionSource(genbankParser.getFeatures(), genome);
        FeatureTrack track = new FeatureTrack(locator, src);
        newTracks.add(track);
    }

    private void loadIGVFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !TrackLoader.checkSize(locator)) {
            return;
        }
        String dsName = locator.getTrackName();
        IGVDataset ds = new IGVDataset(locator, genome);
        ds.setName(dsName);
        TrackProperties trackProperties = ds.getTrackProperties();
        String path = locator.getPath();
        TrackType type = ds.getType();
        for (String trackName : ds.getTrackNames()) {
            DatasetDataSource dataSource = new DatasetDataSource(trackName, ds, genome);
            String trackId = path + "_" + trackName;
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            track.setTrackType(ds.getType());
            track.setProperties(trackProperties);
            if (type == TrackType.ALLELE_FREQUENCY) {
                track.setRenderer(new PointsRenderer());
                track.setHeight(40);
            }
            newTracks.add(track);
        }
    }

    private void loadCufflinksFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        String path = locator.getPath();
        String format = locator.getFormat();
        ArrayList<DataSourceTrack> cuffTracks = new ArrayList<DataSourceTrack>();
        if (format.equals("fpkm_tracking")) {
            codec = new FPKMTrackingCodec(path);
            List<FPKMValue> list = CufflinksParser.parse(codec, path);
            for (int sampleIndex = 0; sampleIndex < ((FPKMTrackingCodec)codec).getNumSamples(); ++sampleIndex) {
                CufflinksDataSource ds = new CufflinksDataSource(sampleIndex, list, genome);
                String supId = String.format("q%02d", sampleIndex);
                DataSourceTrack track = new DataSourceTrack(locator, locator.getPath() + " " + supId, locator.getTrackName() + " " + supId, ds);
                cuffTracks.add(track);
            }
        } else if (format.equals("gene_exp.diff") || format.equals("cds_exp.diff")) {
            codec = new ExpDiffCodec(path);
            List<FPKMValue> list = CufflinksParser.parse(codec, path);
            CufflinksDataSource ds = new CufflinksDataSource(list, genome);
            DataSourceTrack track = new DataSourceTrack(locator, locator.getPath(), locator.getTrackName(), ds);
            cuffTracks.add(track);
        } else {
            throw new RuntimeException("Unsupported file type: " + path);
        }
        for (DataTrack dataTrack : cuffTracks) {
            dataTrack.setTrackType(TrackType.FPKM);
            CufflinksTrack.setCufflinksScale(dataTrack);
            newTracks.add(dataTrack);
        }
    }

    private static boolean checkSize(ResourceLocator locator) {
        if (!PreferencesManager.getPreferences().getAsBoolean("SHOW_SIZE_WARNING")) {
            return true;
        }
        String path = locator.getPath();
        long size = FileUtils.getLength(path);
        int maxSize = 200000000;
        if (path.endsWith(".gz") || path.endsWith(".bgz")) {
            maxSize /= 4;
        }
        if (size > (long)maxSize) {
            String message = "The file " + path + " is large (" + size / 1000000L + " mb).  It is recommended that large files be converted to the binary <i>.tdf</i> format using the IGVTools <b>toTDF</b> command. Loading  unconverted ascii fies of this size can lead to poor performance or unresponsiveness (freezing).  <br><br>IGVTools can be launched from the <b>Tools</b> menu or separately as a command line program. See the user guide for more details.<br><br>Click <b>Continue</b> to continue loading, or <b>Cancel</b> to skip this file.";
            return ConfirmDialog.optionallyShowConfirmDialog(message, "SHOW_SIZE_WARNING", true);
        }
        return true;
    }

    private void loadDOTFile(ResourceLocator locator, List<Track> newTracks) {
    }

    private void loadWigFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        if (locator.isLocal() && !TrackLoader.checkSize(locator)) {
            return;
        }
        WiggleDataset ds = new WiggleParser(locator, genome).parse();
        TrackProperties props = ds.getTrackProperties();
        String name = props == null ? null : props.getName();
        String label = locator.getName();
        if (name == null) {
            name = locator.getFileName();
        } else if (label != null) {
            props.setName(label);
        }
        String path = locator.getPath();
        boolean multiTrack = ds.getTrackNames().length > 1;
        for (String heading : ds.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            DatasetDataSource dataSource = new DatasetDataSource(trackId, ds, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            String displayName = label == null || multiTrack ? heading : label;
            track.setName(displayName);
            track.setProperties(props);
            track.setTrackType(ds.getType());
            if (ds.getType() == TrackType.EXPR) {
                track.setWindowFunction(WindowFunction.none);
            }
            newTracks.add(track);
        }
    }

    public void loadTDFFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        String name;
        log.debug("Loading TDF file " + locator.getPath());
        TDFReader reader = TDFReader.getReader(locator);
        TrackType type = reader.getTrackType();
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        if ((name = locator.getName()) == null) {
            name = props == null ? locator.getTrackName() : props.getName();
        }
        int trackNumber = 0;
        String path = locator.getPath();
        boolean multiTrack = reader.getTrackNames().length > 1;
        for (String heading : reader.getTrackNames()) {
            String trackId = multiTrack ? path + "_" + heading : path;
            String trackName = multiTrack ? heading : name;
            TDFDataSource dataSource = new TDFDataSource(reader, trackNumber, heading, genome);
            DataSourceTrack track = new DataSourceTrack(locator, trackId, trackName, dataSource);
            String displayName = name == null || multiTrack ? heading : name;
            track.setName(displayName);
            track.setTrackType(type);
            if (props != null) {
                track.setProperties(props);
            }
            newTracks.add(track);
            ++trackNumber;
        }
    }

    public void loadBBFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        AbstractTrack track;
        BBFile reader;
        String trackName = locator.getTrackName();
        String trackId = locator.getPath();
        String path = locator.getPath();
        String trixURL = locator.getTrixURL();
        BBFile bBFile = reader = trixURL == null ? new BBFile(path, genome) : new BBFile(path, genome, trixURL);
        if (reader.isBigWigFile()) {
            BBDataSource bigwigSource = new BBDataSource(reader, genome);
            track = new DataSourceTrack(locator, trackId, trackName, bigwigSource);
        } else if (reader.isBigBedFile()) {
            BBFeatureSource featureSource = new BBFeatureSource(reader, genome);
            switch (reader.getFeatureType()) {
                case INTERACT: {
                    track = new InteractionTrack(locator, new WrappedInteractionSource(featureSource));
                    break;
                }
                default: {
                    track = new FeatureTrack(locator, trackId, trackName, featureSource);
                    break;
                }
            }
        } else {
            throw new RuntimeException("Unknown BIGWIG type: " + locator.getPath());
        }
        if (track != null) {
            newTracks.add(track);
        }
    }

    private void loadEwigIBFFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        TDFReader reader = TDFReader.getReader(locator.getPath());
        TrackProperties props = null;
        String trackLine = reader.getTrackLine();
        if (trackLine != null && trackLine.length() > 0) {
            props = new TrackProperties();
            ParsingUtils.parseTrackLine(trackLine, props);
        }
        EWigTrack track = new EWigTrack(locator, genome);
        if (props != null) {
            track.setProperties(props);
        }
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadListFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        try {
            FeatureDirSource source = new FeatureDirSource(locator, genome);
            FeatureTrack track = new FeatureTrack(locator, source);
            track.setName(locator.getTrackName());
            track.setVisibilityWindow(0);
            newTracks.add(track);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void loadGisticFile(ResourceLocator locator, List<Track> newTracks) {
        GisticTrack track = GisticFileParser.loadData(locator);
        track.setName(locator.getTrackName());
        newTracks.add(track);
    }

    private void loadMultipleAlignmentTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        MultipleAlignmentTrack t = new MultipleAlignmentTrack(locator, genome);
        t.setName("Multiple Alignments");
        newTracks.add(t);
    }

    private void loadAlignmentsTrack(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        try {
            String dsName = locator.getTrackName();
            String format = locator.getFormat();
            if (format.equals("sai") || format.equals("bai") || format.equals("csi")) {
                MessageUtils.showMessage("<html><b>ERROR:</b> Loading SAM/BAM index files are not supported:  " + locator.getPath() + "<br>Load the SAM or BAM file directly. ");
                return;
            }
            AlignmentDataManager dataManager = new AlignmentDataManager(locator, genome);
            List<String> seqNames = dataManager.getSequenceNames();
            if (seqNames != null && seqNames.size() > 0) {
                boolean seqMatch = false;
                for (String seq : seqNames) {
                    if (genome.getAliasRecord(seq) == null) continue;
                    seqMatch = true;
                    break;
                }
                if (!seqMatch) {
                    this.showMismatchSequenceNameMessage(locator.getPath(), genome, seqNames);
                }
            }
            if ((format.equals("bam") || format.equals("cram")) && !dataManager.hasIndex()) {
                MessageUtils.showMessage("<html>Could not load index file for: " + locator.getPath() + "<br>  An index file is required for SAM & BAM files.");
                return;
            }
            AlignmentTrack alignmentTrack = new AlignmentTrack(locator, dataManager, genome);
            alignmentTrack.setVisible(PreferencesManager.getPreferences().getAsBoolean("SAM.SHOW_ALIGNMENT_TRACK"));
            newTracks.add(alignmentTrack.getCoverageTrack());
            String covPath = locator.getCoverage();
            if (covPath == null || covPath.equals(".")) {
                boolean bypassFileAutoDiscovery;
                String path = locator.getPath();
                boolean bl = bypassFileAutoDiscovery = PreferencesManager.getPreferences().getAsBoolean("BYPASS_FILE_AUTO_DISCOVERY") || GoogleUtils.isGoogleURL(locator.getPath()) || path.contains("dropbox.com") || path.contains("dataformat=.bam") || path.contains("/query.cgi?");
                if (!bypassFileAutoDiscovery) {
                    covPath = ResourceLocator.appendToPath(locator, ".tdf");
                }
            }
            if (covPath != null && !covPath.equals(".") && FileUtils.resourceExists(covPath)) {
                log.debug("Loading TDF for coverage: " + covPath);
                try {
                    TDFReader reader = TDFReader.getReader(covPath);
                    TDFDataSource ds = new TDFDataSource(reader, 0, dsName + " coverage", genome);
                    alignmentTrack.getCoverageTrack().setDataSource(ds);
                }
                catch (Exception e) {
                    log.error("Error loading coverage TDF file", e);
                }
            }
            newTracks.add(alignmentTrack.getSpliceJunctionTrack());
            alignmentTrack.init();
            newTracks.add(alignmentTrack);
            log.debug("Alignment track loaded");
        }
        catch (IndexNotFoundException e) {
            MessageUtils.showMessage("<html>Could not find the index file for  <br><br>&nbsp;&nbsp;" + e.getSamFile() + "<br><br>Note: The index file can be created using igvtools and must be in the same directory as the .sam file.");
        }
    }

    private void showMismatchSequenceNameMessage(String filename, Genome genome, List<String> seqNames) {
        StringBuffer message = new StringBuffer();
        message.append("<html>File: " + filename + "<br>does not contain any sequence names which match the current genome.");
        message.append("<br><br>Sequence names in 'filename': &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        int n = 0;
        for (String sn : seqNames) {
            message.append(sn + ", ");
            if (++n <= 3) continue;
            message.append(" ...");
            break;
        }
        if (genome != null && genome.getChromosomeNames() != null && genome.getChromosomeNames().size() > 0) {
            message.append("<br>Sequence names in genome reference sequence: ");
            n = 0;
            for (String cn : genome.getChromosomeNames()) {
                message.append(cn + ", ");
                if (++n <= 3) continue;
                message.append(" ...");
                break;
            }
        }
        MessageUtils.showMessage(message.toString());
    }

    private void loadMutFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException, TribbleIndexNotFoundException {
        MutationTrackLoader loader = new MutationTrackLoader();
        List<FeatureTrack> mutationTracks = loader.loadMutationTracks(locator, genome);
        for (FeatureTrack track : mutationTracks) {
            track.setTrackType(TrackType.MUTATION);
            track.setRenderer(new MutationRenderer());
            newTracks.add(track);
        }
    }

    private void loadSegFile(ResourceLocator locator, List<Track> newTracks, Genome genome) {
        String path = locator.getPath().toLowerCase();
        if (path.endsWith("seg.zip")) {
            throw new DataLoadException("Binary seg (.seg.zip) files are no longer supported", locator.getPath());
        }
        SegmentedDataSet ds = SegmentFileParser.loadSegments(locator, genome);
        this.loadSegTrack(locator, newTracks, genome, ds);
    }

    private void loadSegTrack(ResourceLocator locator, List<Track> newTracks, Genome genome, SegmentedDataSet ds) {
        String path = locator.getPath();
        TrackProperties props = ds.getTrackProperties();
        if ((ds.getType() == TrackType.COPY_NUMBER || ds.getType() == TrackType.CNV) && ds.getSampleNames().size() > 1) {
            FreqData fd = new FreqData(ds, genome);
            String freqTrackId = path;
            String freqTrackName = "CNV Summary";
            CNFreqTrack freqTrack = new CNFreqTrack(locator, freqTrackId, freqTrackName, fd);
            if (props != null) {
                freqTrack.setProperties(props);
            }
            newTracks.add(freqTrack);
        }
        String trackId = path + "_cn";
        SegTrack track = new SegTrack(locator, trackId, trackId, ds, genome);
        track.setRenderer(new HeatmapRenderer());
        track.setTrackType(ds.getType());
        if (props != null) {
            track.setProperties(props);
        }
        newTracks.add(track);
    }

    private void loadTrioData(ResourceLocator locator) throws IOException {
        PedigreeUtils.parseTrioFile(locator.getPath());
    }

    private void convertLoadShapeFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        String inPath = locator.getPath();
        String fileName = locator.getFileName();
        String outPath = inPath + ".wig";
        String message = "The chemical reactivity file <br> &nbsp;&nbsp;" + fileName + "<br> needs to be converted to IGV chromosome <br>coordinates and .wig format before loading. <br><br>Click <b>Continue</b> to save converted file to <br> &nbsp;&nbsp;" + fileName + ".wig<br>and load with the selected options, or <b>Cancel</b> to skip this<br>file.";
        ConvertOptions opts = ConvertFileDialog.showConvertFileDialog(message);
        if (opts.doConvert) {
            ShapeFileUtils.shapeToWigFile(inPath, outPath, opts.chrom, opts.strand, opts.start);
            this.loadWigFile(new ResourceLocator(outPath), newTracks, genome);
        }
    }

    private void convertLoadStructureFile(ResourceLocator locator, List<Track> newTracks, Genome genome, String fileType) throws IOException {
        String inPath = locator.getPath();
        String fileName = locator.getFileName();
        String outPath = inPath + ".bp";
        String message = "The RNA structure file <br> &nbsp;&nbsp;" + fileName + "<br> needs to be converted to IGV chromosome <br>coordinates and .bp format before loading. <br><br>Click <b>Continue</b> to save converted file to <br> &nbsp;&nbsp;" + fileName + ".bp<br>and load with the selected options, or <b>Cancel</b> to skip this<br>file.";
        ConvertOptions opts = ConvertFileDialog.showConvertFileDialog(message);
        if (opts.doConvert) {
            if (fileType == "connectTable") {
                BasePairFileUtils.connectTableToBasePairFile(inPath, outPath, opts.chrom, opts.strand, opts.start);
            } else if (fileType == "pairingProb") {
                BasePairFileUtils.pairingProbToBasePairFile(inPath, outPath, opts.chrom, opts.strand, opts.start);
            } else if (fileType == "dotBracket") {
                BasePairFileUtils.dotBracketToBasePairFile(inPath, outPath, opts.chrom, opts.strand, opts.start);
            }
            this.loadBasePairFile(new ResourceLocator(outPath), newTracks, genome);
        }
    }

    private void loadBasePairFile(ResourceLocator locator, List<Track> newTracks, Genome genome) throws IOException {
        String name = locator.getTrackName();
        String path = locator.getPath();
        String id = path + "_" + name;
        newTracks.add(new BasePairTrack(locator, id, name, genome));
    }

    public static boolean isIndexed(ResourceLocator locator, Genome genome) {
        String[] toks;
        String fullPath = locator.getPath();
        String pathNoQuery = locator.getURLPath();
        if (!CodecFactory.hasCodec(locator, genome)) {
            return false;
        }
        String indexExtension = pathNoQuery.endsWith("gz") ? ".tbi" : ".idx";
        Object indexPath = fullPath + indexExtension;
        if (HttpUtils.isRemoteURL(fullPath) && (toks = fullPath.split("\\?", 2)).length == 2) {
            indexPath = String.format("%s%s?%s", toks[0], indexExtension, toks[1]);
        }
        return FileUtils.resourceExists((String)indexPath);
    }

    public static TrackProperties getTrackProperties(Object header) {
        try {
            FeatureFileHeader ffHeader = (FeatureFileHeader)header;
            if (ffHeader != null) {
                return ffHeader.getTrackProperties();
            }
            return null;
        }
        catch (ClassCastException e) {
            return null;
        }
    }
}

