/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.FeatureUtils;
import org.igv.feature.GisticScore;
import org.igv.feature.IGVFeature;
import org.igv.feature.LocusScore;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.renderer.DataRange;
import org.igv.renderer.GisticTrackRenderer;
import org.igv.renderer.Renderer;
import org.igv.track.AbstractTrack;
import org.igv.track.RegionScoreType;
import org.igv.track.RenderContext;
import org.igv.track.WindowFunction;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.util.ResourceLocator;

public class GisticTrack
extends AbstractTrack {
    private static Logger log = LogManager.getLogger(GisticTrack.class);
    private static final int DEFAULT_HEIGHT = 50;
    private double maxQValue = 0.0;
    private double maxGScore = 0.0;
    private boolean hasScores = false;
    Map<String, List<GisticScore>> ampScoreMap;
    Map<String, List<GisticScore>> delScoreMap;
    GisticTrackRenderer renderer;
    double dataMax = -1.0;

    public GisticTrack(ResourceLocator locator) {
        super(locator);
        this.ampScoreMap = new HashMap<String, List<GisticScore>>();
        this.delScoreMap = new HashMap<String, List<GisticScore>>();
        this.renderer = new GisticTrackRenderer();
        this.setHeight(50);
        this.renderer = new GisticTrackRenderer();
        this.setSortable(false);
    }

    public GisticTrack() {
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.hasScores;
    }

    @Override
    public void load(ReferenceFrame referenceFrame) {
    }

    @Override
    public int getMinimumHeight() {
        return 25;
    }

    public void setScores(List<GisticScore> scores) {
        this.hasScores = true;
        for (GisticScore score : scores) {
            String chr = score.getChromosome();
            if (score.getType() == GisticScore.Type.AMP) {
                this.addScore(score, chr, this.ampScoreMap);
                continue;
            }
            this.addScore(score, chr, this.delScoreMap);
        }
        this.updateMaxValues(scores);
    }

    protected void addScore(GisticScore score, String chr, Map<String, List<GisticScore>> map) {
        List<GisticScore> scoreList = map.get(chr);
        if (scoreList == null) {
            scoreList = new ArrayList<GisticScore>();
            map.put(chr, scoreList);
        }
        scoreList.add(score);
    }

    private void updateMaxValues(List<GisticScore> scores) {
        for (GisticScore score : scores) {
            if (!Double.isInfinite(this.maxGScore) && score.getGScore() > this.maxGScore) {
                this.maxGScore = score.getGScore();
            }
            if (Double.isInfinite(this.maxQValue) || !(score.getQValue() > this.maxQValue)) continue;
            this.maxQValue = score.getQValue();
        }
        this.setDataRange(new DataRange(0.0f, 0.0f, (float)this.maxQValue));
    }

    public List<GisticScore> getAmpScores(String chr) {
        return this.ampScoreMap.get(chr);
    }

    public List<GisticScore> getDelScores(String chr) {
        return this.delScoreMap.get(chr);
    }

    public double getMaxGScore() {
        return this.maxGScore;
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (this.renderer == null) {
            log.error("Null renderer !!");
        } else {
            this.renderer.render(this, context, rect);
        }
    }

    public double getDataMax() {
        if (this.dataMax < 0.0) {
            this.dataMax = this.getMaxGScore();
        }
        return this.dataMax;
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return WindowFunction.median;
    }

    @Override
    public boolean isLogNormalized() {
        return true;
    }

    public List<IGVFeature> getFeatures(String chr, int startLocation, int endLocation) {
        return null;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int ignore, ReferenceFrame frame) {
        double bpPerPixel = frame.getScale();
        double minWidth = 2.0 * bpPerPixel;
        LocusScore amp = null;
        List<GisticScore> ampScores = this.ampScoreMap.get(chr);
        if (ampScores != null) {
            amp = FeatureUtils.getFeatureAt(position, 0, ampScores);
        }
        LocusScore del = null;
        List<GisticScore> delScores = this.delScoreMap.get(chr);
        if (delScores != null) {
            del = FeatureUtils.getFeatureAt(position, 0, delScores);
        }
        if (amp == null && del == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        if (amp != null) {
            buf.append("Amplification score: " + amp.getScore());
        }
        if (del != null) {
            buf.append("<br>Deletion score: " + del.getScore());
        }
        return buf.toString();
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }
}

