/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.sort;

import java.io.File;
import org.igv.feature.gff.GFFFeatureSource;
import org.igv.feature.tribble.MUTCodec;
import org.igv.gwas.GWASParser;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.tools.sort.BAMSorter;
import org.igv.tools.sort.BedSorter;
import org.igv.tools.sort.CNSorter;
import org.igv.tools.sort.EQTLSorter;
import org.igv.tools.sort.GFFSorter;
import org.igv.tools.sort.GWASSorter;
import org.igv.tools.sort.GenericSorter;
import org.igv.tools.sort.InteractionSorter;
import org.igv.tools.sort.MUTSorter;
import org.igv.tools.sort.RefgeneSorter;
import org.igv.tools.sort.SAMSorter;
import org.igv.tools.sort.Sorter;
import org.igv.tools.sort.VCFSorter;
import org.igv.util.ResourceLocator;

public class SorterFactory {
    private static Logger log = LogManager.getLogger(SorterFactory.class);

    public static Sorter getSorter(File inputFile, File outputFile) {
        String shortFN = inputFile.getName().toLowerCase();
        if (shortFN.endsWith(".txt")) {
            shortFN = shortFN.substring(0, shortFN.length() - 4);
        }
        if (shortFN.endsWith(".cn") || shortFN.endsWith(".xcn") || shortFN.endsWith(".snp") || shortFN.endsWith(".igv")) {
            return new CNSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".sam")) {
            return new SAMSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".aligned") || shortFN.endsWith(".bed") || shortFN.endsWith(".bedgraph") || shortFN.endsWith(".bdg")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (GFFFeatureSource.isGFF(shortFN)) {
            return new GFFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".vcf")) {
            return new VCFSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".psl") || shortFN.endsWith(".pslx")) {
            return new BedSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".eqtl")) {
            return new EQTLSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".snp")) {
            return new GenericSorter(inputFile, outputFile, 1, 2);
        }
        if (GWASParser.isGWASFile(shortFN)) {
            return new GWASSorter(inputFile, outputFile);
        }
        if (MUTCodec.isMutationAnnotationFile(new ResourceLocator(inputFile.getAbsolutePath()))) {
            return new MUTSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".interaction")) {
            return new InteractionSorter(inputFile, outputFile);
        }
        if (shortFN.endsWith(".bam")) {
            return new BAMSorter(inputFile, outputFile);
        }
        if (shortFN.contains("refgene") || shortFN.contains("ncbirefseq")) {
            return new RefgeneSorter(inputFile, outputFile);
        }
        log.error("Unknown file type or sorting not supported for: " + inputFile.getName());
        return null;
    }
}

