/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.igv.sam.AlignmentCounts;
import org.igv.sam.BaseAlignmentCounts;
import org.igv.util.ParsingUtils;

public abstract class AbstractConsensusCalculator {
    private static Table<Character, Character, Character> degeneracyTable;

    public char calculateConsensusBase(AlignmentCounts counts, int pos) {
        List<BaseFraction> baseFractions = this.calculateBaseFractions(counts, pos);
        return this.calculateConsensusBase(baseFractions);
    }

    protected abstract char calculateConsensusBase(List<BaseFraction> var1);

    protected final List<BaseFraction> calculateBaseFractions(AlignmentCounts counts, int pos) {
        ArrayList<BaseFraction> results = new ArrayList<BaseFraction>(5);
        int totalCount = counts.getTotalCount(pos);
        for (char c : BaseAlignmentCounts.nucleotides) {
            int negCount = counts.getNegCount(pos, (byte)c);
            int posCount = counts.getPosCount(pos, (byte)c);
            int count = negCount + posCount;
            float fraction = (float)count / (float)totalCount;
            results.add(new BaseFraction(c, fraction));
        }
        Collections.sort(results, Collections.reverseOrder());
        return results;
    }

    protected final char getDegenerateCode(char base0, char base1) {
        Table<Character, Character, Character> degenTable = AbstractConsensusCalculator.getDegeneracyTable();
        return ((Character)degenTable.get((Object)Character.valueOf(base0), (Object)Character.valueOf(base1))).charValue();
    }

    protected static Table<Character, Character, Character> getDegeneracyTable() {
        if (degeneracyTable == null) {
            degeneracyTable = HashBasedTable.create((int)5, (int)5);
            Map<String, String> iupacMap = ParsingUtils.loadIUPACMap();
            for (String s : iupacMap.values()) {
                String[] tokens = (s = s.replace("[", "").replace("]", "").toLowerCase()).split(",");
                if (tokens.length != 3) continue;
                char a = tokens[1].trim().charAt(0);
                char b = tokens[2].trim().charAt(0);
                char c = tokens[0].trim().charAt(0);
                degeneracyTable.put((Object)Character.valueOf(a), (Object)Character.valueOf(b), (Object)Character.valueOf(c));
                degeneracyTable.put((Object)Character.valueOf(b), (Object)Character.valueOf(a), (Object)Character.valueOf(c));
            }
        }
        return degeneracyTable;
    }

    public static class BaseFraction
    implements Comparable {
        public final char base;
        public final float fraction;

        public BaseFraction(char base, float fraction) {
            this.base = base;
            this.fraction = fraction;
        }

        public int compareTo(Object o) {
            return (int)Math.signum(this.fraction - ((BaseFraction)o).fraction);
        }
    }
}

