/*
 * Decompiled with CFR 0.152.
 */
package org.igv.session;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.session.Session;
import org.igv.session.SessionReader;
import org.igv.track.Track;
import org.igv.track.TrackProperties;
import org.igv.ui.IGV;
import org.igv.ui.panel.TrackPanel;
import org.igv.ui.util.MessageUtils;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;

public class IndexAwareSessionReader
implements SessionReader {
    private static Logger log = LogManager.getLogger(IndexAwareSessionReader.class);
    IGV igv;

    public IndexAwareSessionReader(IGV igv) {
        this.igv = igv;
    }

    @Override
    public void loadSession(InputStream inputStream, Session session, String sessionPath) throws IOException {
        String nextLine;
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
        String trackLine = null;
        ArrayList<String> errors = new ArrayList<String>();
        HashMap<String, List<Track>> loadedTracks = new HashMap<String, List<Track>>();
        ArrayList<ResourceLocator> aSync = new ArrayList<ResourceLocator>();
        this.igv.resetSession(sessionPath);
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        if (genome != null) {
            GenomeManager.getInstance().restoreGenomeTracks(GenomeManager.getInstance().getCurrentGenome());
        }
        while ((nextLine = reader.readLine()) != null) {
            ResourceLocator locator = null;
            try {
                if (nextLine.startsWith("#")) continue;
                if (nextLine.startsWith("browser")) {
                    this.parseBrowserLine(nextLine, session);
                } else if (nextLine.startsWith("track")) {
                    trackLine = nextLine;
                    String dataURL = this.getDataURL(trackLine);
                    if (dataURL != null) {
                        String coverageURL;
                        locator = new ResourceLocator(dataURL);
                        String indexURL = this.getIndexURL(trackLine);
                        if (indexURL != null) {
                            locator.setIndexPath(indexURL);
                        }
                        if ((coverageURL = this.getCoverageURL(trackLine)) != null) {
                            locator.setCoverage(coverageURL);
                        }
                        loadedTracks.put(dataURL, this.igv.load(locator));
                    }
                } else {
                    locator = this.parseResourceLine(nextLine);
                }
                if (locator == null) continue;
                locator.setTrackLine(trackLine);
                if (this.isAlignmentFile(locator.getPath())) {
                    this.igv.addTracks(this.igv.load(locator));
                } else {
                    aSync.add(locator);
                }
                trackLine = null;
                locator = null;
            }
            catch (Exception e) {
                log.error("Error loading resource " + locator.getPath(), e);
                String ms = "<b>" + locator.getPath() + "</b><br>&nbsp;&nbsp;" + e.toString() + "<br>";
                errors.add(ms);
            }
        }
        this.loadAsynchronous(aSync, loadedTracks, errors);
        if (errors.size() > 0) {
            this.displayErrors(errors);
        }
    }

    private void loadAsynchronous(List<ResourceLocator> aSync, final HashMap<String, List<Track>> loadedTracks, final List<String> errors) {
        ArrayList<Thread> threads = new ArrayList<Thread>(aSync.size());
        for (final ResourceLocator locator : aSync) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        loadedTracks.put(locator.getPath(), IndexAwareSessionReader.this.igv.load(locator));
                    }
                    catch (Exception e) {
                        log.error("Error loading resource " + locator.getPath(), e);
                        String ms = "<b>" + locator.getPath() + "</b><br>&nbs;p&nbsp;" + e.toString() + "<br>";
                        errors.add(ms);
                    }
                }
            };
            Thread t = new Thread(runnable);
            threads.add(t);
            t.start();
        }
        for (Thread t : threads) {
            try {
                t.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.placeTracksInPanels(aSync, loadedTracks);
    }

    private String getDataURL(String nextLine) {
        TrackProperties props = new TrackProperties();
        ParsingUtils.parseTrackLine(nextLine, props);
        return props.getDataURL();
    }

    private String getIndexURL(String nextLine) {
        TrackProperties props = new TrackProperties();
        ParsingUtils.parseTrackLine(nextLine, props);
        return props.getIndexURL();
    }

    private String getCoverageURL(String nextLine) {
        TrackProperties props = new TrackProperties();
        ParsingUtils.parseTrackLine(nextLine, props);
        return props.getCoverageURL();
    }

    private void placeTracksInPanels(List<ResourceLocator> locatorPaths, Map<String, List<Track>> loadedTracks) {
        for (ResourceLocator loc : locatorPaths) {
            TrackPanel panel = this.igv.getTrackPanel("DataPanel");
            String path = loc.getPath();
            if (!loadedTracks.containsKey(path)) continue;
            panel.addTracks((Collection<? extends Track>)loadedTracks.get(path));
        }
    }

    private boolean isAlignmentFile(String path) {
        return path.endsWith(".bam") || path.endsWith(".entries") || path.endsWith(".sam");
    }

    private void parseBrowserLine(String line, Session session) {
        String[] tokens = line.split("\\s+");
        if (tokens.length >= 3 && tokens[1].equals("position")) {
            session.setLocus(tokens[2]);
        }
    }

    private ResourceLocator parseResourceLine(String line) {
        ResourceLocator locator = null;
        String[] tokens = line.split("\\s+");
        if (tokens.length == 1) {
            locator = new ResourceLocator(tokens[0]);
        } else if (tokens.length >= 2) {
            locator = new ResourceLocator(tokens[0]);
            locator.setIndexPath(tokens[1]);
            if (tokens.length >= 3) {
                locator.setCoverage(tokens[2]);
            }
        }
        return locator;
    }

    private void displayErrors(List<String> errors) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>Errors were encountered while loading session:<br>");
        for (String e : errors) {
            buffer.append(e);
        }
        MessageUtils.showMessage(buffer.toString());
    }
}

