/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam.reader;

import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JProgressBar;
import org.igv.Globals;
import org.igv.sam.reader.DotAlignedIndexer;
import org.igv.sam.reader.FeatureIndex;
import org.igv.sam.reader.SamIndexer;
import org.igv.sam.reader.UnsortedFileException;
import org.igv.ui.util.IndexCreatorDialog;
import org.igv.ui.util.UIUtilities;

public abstract class AlignmentIndexer {
    static int DEFAULT_TILEWIDTH = 16000;
    static int MILLISECONDS_IN_MINUTE = 60000;
    IndexCreatorDialog.IndexWorker worker;
    JProgressBar progressBar;
    File samFile;

    public static AlignmentIndexer getInstance(File samFile, JProgressBar progressBar, IndexCreatorDialog.SamIndexWorker worker) {
        String fn = samFile.getName().toLowerCase();
        if (fn.endsWith(".aligned") || fn.endsWith(".bedz") || fn.endsWith(".bed") || fn.endsWith(".aligned.txt") || fn.endsWith(".bedz.txt") || fn.endsWith(".bed.txt")) {
            return new DotAlignedIndexer(samFile, progressBar, worker);
        }
        return new SamIndexer(samFile, progressBar, worker);
    }

    AlignmentIndexer(File samFile, JProgressBar progressBar, IndexCreatorDialog.SamIndexWorker worker) {
        this.samFile = samFile;
        this.progressBar = progressBar;
        this.worker = worker;
    }

    public FeatureIndex createSamIndex() throws IOException, FileNotFoundException {
        File idxFile = new File(this.samFile.getParent(), this.samFile.getName() + ".sai");
        return this.createSamIndex(idxFile);
    }

    public FeatureIndex createSamIndex(File idxFile) throws IOException {
        return this.createSamIndex(idxFile, DEFAULT_TILEWIDTH);
    }

    public FeatureIndex createSamIndex(File idxFile, int tileWidth) throws IOException {
        FileInputStream is = new FileInputStream(this.samFile);
        BufferedInputStream bis = new BufferedInputStream(is);
        AsciiLineReader reader = new AsciiLineReader((InputStream)bis);
        long fileLength = this.samFile.length();
        long progressIncrement = fileLength / 100L;
        long lastFilePosition = 0L;
        String lastChr = null;
        int lastAlignmentStart = 0;
        FeatureIndex featureIndex = new FeatureIndex(tileWidth);
        int recordCount = 0;
        long filePosition = 0L;
        int currentTile = 0;
        int longestFeature = 0;
        long startTime = System.currentTimeMillis();
        int progressCounter = 1;
        String nextLine = "";
        int lineNumber = 0;
        while ((nextLine = reader.readLine()) != null) {
            ++lineNumber;
            if (this.worker != null && this.worker.isCancelled()) {
                return null;
            }
            nextLine = nextLine.trim();
            String[] fields = Globals.tabPattern.split(nextLine, -1);
            int nFields = fields.length;
            if (!nextLine.startsWith("@") && nFields > 3 && this.isMapped(fields)) {
                String chr = this.getChromosome(fields);
                int alignmentStart = this.getAlignmentStart(fields);
                int tileNumber = alignmentStart / tileWidth;
                if (lastChr == null) {
                    currentTile = tileNumber;
                    for (int i = 0; i < currentTile; ++i) {
                        featureIndex.add(chr, lastFilePosition, 0, longestFeature);
                    }
                    lastChr = chr;
                } else if (!chr.equals(lastChr)) {
                    featureIndex.add(lastChr, filePosition, recordCount, longestFeature);
                    filePosition = lastFilePosition;
                    currentTile = 0;
                    recordCount = 0;
                    lastAlignmentStart = 0;
                    longestFeature = 0;
                    lastChr = chr;
                } else {
                    longestFeature = Math.max(longestFeature, this.getAlignmentLength(fields));
                    if (alignmentStart < 0) {
                        System.out.println("Warning: negative start position at line: " + lineNumber + " : " + nextLine);
                        continue;
                    }
                    if (alignmentStart < lastAlignmentStart) {
                        throw new UnsortedFileException(" File must be sorted by start position. Sort test failed at: " + nextLine);
                    }
                    lastAlignmentStart = alignmentStart;
                    if (tileNumber > currentTile) {
                        featureIndex.add(lastChr, filePosition, recordCount, longestFeature);
                        for (int cnt = 0; cnt < tileNumber - currentTile - 1; ++cnt) {
                            featureIndex.add(lastChr, filePosition, 0, longestFeature);
                        }
                        filePosition = lastFilePosition;
                        currentTile = tileNumber;
                        recordCount = 0;
                    }
                    ++recordCount;
                }
            }
            if ((lastFilePosition = reader.getPosition()) <= (long)progressCounter * progressIncrement) continue;
            this.updateProgress(progressCounter, startTime);
            ++progressCounter;
        }
        featureIndex.add(lastChr, filePosition, recordCount, longestFeature);
        is.close();
        if (idxFile != null) {
            featureIndex.store(idxFile);
        }
        this.updateProgress(100, startTime);
        if (this.progressBar == null) {
            System.out.println("Done indexing " + this.samFile.getName());
        }
        return featureIndex;
    }

    abstract int getAlignmentStart(String[] var1) throws NumberFormatException;

    abstract int getAlignmentLength(String[] var1) throws NumberFormatException;

    abstract String getChromosome(String[] var1);

    abstract boolean isMapped(String[] var1);

    private void updateProgress(int progressCounter, long startTime) {
        final long timeToComplete = (long)(100 - progressCounter) * (System.currentTimeMillis() - startTime) / (long)progressCounter;
        final int p = progressCounter;
        if (this.progressBar != null) {
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    AlignmentIndexer.this.progressBar.setValue(p);
                    if (AlignmentIndexer.this.worker != null) {
                        AlignmentIndexer.this.worker.setTimeRemaining(timeToComplete);
                    }
                }
            });
        } else {
            System.out.println("Progress: " + progressCounter + "%");
        }
    }
}

