/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.List;
import org.igv.feature.FeatureUtils;
import org.igv.feature.SpliceJunctionFeature;
import org.igv.feature.Strand;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.Gap;
import org.igv.sam.SpliceGap;
import org.igv.sam.SpliceJunctionTrack;

public class SpliceJunctionHelper {
    static Logger log = LogManager.getLogger(SpliceJunctionHelper.class);
    List<SpliceJunctionFeature> allSpliceJunctionFeatures = new ArrayList<SpliceJunctionFeature>();
    List<SpliceJunctionFeature> filteredCombinedFeatures = null;
    Table<Integer, Integer, SpliceJunctionFeature> posStartEndJunctionsMap = HashBasedTable.create();
    Table<Integer, Integer, SpliceJunctionFeature> negStartEndJunctionsMap = HashBasedTable.create();

    public List<SpliceJunctionFeature> getFilteredJunctions(SpliceJunctionTrack.StrandOption strandOption, int minJunctionCoverage) {
        List<SpliceJunctionFeature> filteredJunctions;
        List<SpliceJunctionFeature> junctions;
        switch (strandOption) {
            case FORWARD: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.posStartEndJunctionsMap.values());
                break;
            }
            case REVERSE: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.negStartEndJunctionsMap.values());
                break;
            }
            case BOTH: {
                junctions = new ArrayList<SpliceJunctionFeature>(this.posStartEndJunctionsMap.values());
                junctions.addAll(this.negStartEndJunctionsMap.values());
                break;
            }
            default: {
                junctions = this.combineStrandJunctionsMaps();
            }
        }
        List<SpliceJunctionFeature> unfiltered = junctions;
        if (minJunctionCoverage > 1) {
            ArrayList<SpliceJunctionFeature> coveredFeatures = new ArrayList<SpliceJunctionFeature>(unfiltered.size());
            for (SpliceJunctionFeature feature : unfiltered) {
                if (feature.getJunctionDepth() < minJunctionCoverage) continue;
                coveredFeatures.add(feature);
            }
            filteredJunctions = coveredFeatures;
        } else {
            filteredJunctions = unfiltered;
        }
        FeatureUtils.sortFeatureList(filteredJunctions);
        return filteredJunctions;
    }

    public void addAlignment(Alignment alignment) {
        AlignmentBlock[] blocks = alignment.getAlignmentBlocks();
        if (blocks == null || blocks.length < 2) {
            return;
        }
        Object strandAttr = alignment.getAttribute("TS");
        if (strandAttr == null) {
            strandAttr = alignment.getAttribute("XS");
        }
        boolean isNegativeStrand = strandAttr != null ? strandAttr.toString().charAt(0) == '-' : (alignment.isPaired() ? alignment.getFirstOfPairStrand() == Strand.NEGATIVE : alignment.isNegativeStrand());
        Table<Integer, Integer, SpliceJunctionFeature> startEndJunctionsTableThisStrand = isNegativeStrand ? this.negStartEndJunctionsMap : this.posStartEndJunctionsMap;
        List<Gap> gaps = alignment.getGaps();
        int minReadFlankingWidth = PreferencesManager.getPreferences("RNA").getAsInt("SAM.JUNCTION_MIN_FLANKING_WIDTH");
        if (gaps != null) {
            for (Gap gap : gaps) {
                if (!(gap instanceof SpliceGap)) continue;
                SpliceGap spliceGap = (SpliceGap)gap;
                if (minReadFlankingWidth != 0 && (spliceGap.getFlankingLeft() < minReadFlankingWidth || spliceGap.getFlankingRight() < minReadFlankingWidth)) continue;
                int junctionStart = spliceGap.getStart();
                int junctionEnd = junctionStart + spliceGap.getnBases();
                int flankingStart = junctionStart - spliceGap.getFlankingLeft();
                int flankingEnd = junctionEnd + spliceGap.getFlankingRight();
                SpliceJunctionFeature junction = (SpliceJunctionFeature)startEndJunctionsTableThisStrand.get((Object)junctionStart, (Object)junctionEnd);
                if (junction == null) {
                    junction = new SpliceJunctionFeature(alignment.getChr(), junctionStart, junctionEnd, isNegativeStrand ? Strand.NEGATIVE : Strand.POSITIVE);
                    startEndJunctionsTableThisStrand.put((Object)junctionStart, (Object)junctionEnd, (Object)junction);
                    this.allSpliceJunctionFeatures.add(junction);
                }
                junction.addRead(flankingStart, flankingEnd);
            }
        }
    }

    private List<SpliceJunctionFeature> combineStrandJunctionsMaps() {
        int junctionEnd;
        int junctionStart;
        HashBasedTable combinedMap = HashBasedTable.create();
        for (SpliceJunctionFeature posFeature : this.posStartEndJunctionsMap.values()) {
            junctionStart = posFeature.getJunctionStart();
            junctionEnd = posFeature.getJunctionEnd();
            SpliceJunctionFeature combinedFeature = new SpliceJunctionFeature(posFeature.getChr(), junctionStart, junctionEnd);
            combinedFeature.setJunctionDepth(posFeature.getJunctionDepth());
            combinedMap.put((Object)junctionStart, (Object)junctionEnd, (Object)combinedFeature);
        }
        for (SpliceJunctionFeature negFeature : this.negStartEndJunctionsMap.values()) {
            junctionStart = negFeature.getJunctionStart();
            junctionEnd = negFeature.getJunctionEnd();
            SpliceJunctionFeature junction = (SpliceJunctionFeature)combinedMap.get((Object)junctionStart, (Object)junctionEnd);
            if (junction == null) {
                SpliceJunctionFeature combinedFeature = new SpliceJunctionFeature(negFeature.getChr(), junctionStart, junctionEnd);
                combinedFeature.setJunctionDepth(negFeature.getJunctionDepth());
                combinedMap.put((Object)junctionStart, (Object)junctionEnd, (Object)negFeature);
                continue;
            }
            int newJunctionDepth = junction.getJunctionDepth() + negFeature.getJunctionDepth();
            junction.setJunctionDepth(newJunctionDepth);
        }
        return new ArrayList<SpliceJunctionFeature>(combinedMap.values());
    }
}

