/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.InsertionMarker;

public class InsertionManager {
    private static InsertionManager theInstance = new InsertionManager();
    private Map<String, Map<Integer, InsertionMarker>> insertionMaps = Collections.synchronizedMap(new HashMap(100));
    private Map<String, Integer> selectedInsertions = Collections.synchronizedMap(new HashMap(100));
    InsertionMarker selectedInsertion;

    public static InsertionManager getInstance() {
        return theInstance;
    }

    private InsertionManager() {
    }

    public void clear() {
        this.insertionMaps.clear();
        this.selectedInsertions.clear();
        this.selectedInsertion = null;
    }

    public List<InsertionMarker> getInsertions(String chrName, double start, double end) {
        Map<Integer, InsertionMarker> insertionMap = this.insertionMaps.get(chrName);
        if (insertionMap == null) {
            return null;
        }
        return insertionMap.values().stream().filter(im -> (double)(im.position + im.size) >= start && (double)im.position <= end).collect(Collectors.toList());
    }

    public void setSelected(InsertionMarker insertionMarker) {
        this.selectedInsertion = insertionMarker;
    }

    public synchronized void processAlignments(String chr, List<Alignment> alignments) {
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        chr = genome == null ? chr : genome.getCanonicalChrName(chr);
        Map<Integer, InsertionMarker> insertionMap = this.insertionMaps.get(chr);
        if (insertionMap == null) {
            insertionMap = Collections.synchronizedMap(new HashMap());
            this.insertionMaps.put(chr, insertionMap);
        }
        for (Alignment a : alignments) {
            AlignmentBlock[] blocks = a.getInsertions();
            if (blocks == null) continue;
            for (AlignmentBlock block : blocks) {
                Integer key = block.getStart();
                InsertionMarker insertionMarker = insertionMap.get(key);
                if (insertionMarker == null) {
                    insertionMarker = new InsertionMarker(block.getStart(), block.getLength());
                    insertionMap.put(key, insertionMarker);
                    continue;
                }
                insertionMarker.size = Math.max(insertionMarker.size, block.getLength());
            }
        }
    }
}

