/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import htsjdk.samtools.SAMTag;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingWorker;
import org.igv.Globals;
import org.igv.event.AlignmentTrackEvent;
import org.igv.event.IGVEventBus;
import org.igv.feature.Range;
import org.igv.feature.Strand;
import org.igv.jbrowse.CircularViewUtilities;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.IGVPreferences;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.AlignmentCounts;
import org.igv.sam.AlignmentDataManager;
import org.igv.sam.AlignmentInterval;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.AlignmentTrackUtils;
import org.igv.sam.ClippingCounts;
import org.igv.sam.ClusterUtils;
import org.igv.sam.CoverageTrack;
import org.igv.sam.ReadMate;
import org.igv.sam.SortOption;
import org.igv.sam.SpliceJunctionTrack;
import org.igv.sam.SupplementaryAlignment;
import org.igv.sam.mods.BaseModficationFilter;
import org.igv.sam.mods.BaseModificationKey;
import org.igv.sam.mods.BaseModificationUtils;
import org.igv.sashimi.SashimiPlot;
import org.igv.tools.PFMExporter;
import org.igv.track.SequenceTrack;
import org.igv.track.Track;
import org.igv.track.TrackClickEvent;
import org.igv.track.TrackMenuUtils;
import org.igv.ui.IGV;
import org.igv.ui.InsertSizeSettingsDialog;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.supdiagram.SupplementaryAlignmentDiagramDialog;
import org.igv.ui.util.MessageUtils;
import org.igv.ui.util.UIUtilities;
import org.igv.util.StringUtils;
import org.igv.util.blat.BlatClient;
import org.igv.util.extview.ExtendViewClient;

class AlignmentTrackMenu
extends IGVPopupMenu {
    private static final Logger log = LogManager.getLogger(AlignmentTrackMenu.class);
    private final AlignmentTrack alignmentTrack;
    private final AlignmentDataManager dataManager;
    private final AlignmentTrack.RenderOptions renderOptions;
    private static int nClusters = 2;

    AlignmentTrackMenu(AlignmentTrack alignmentTrack, TrackClickEvent e) {
        this.alignmentTrack = alignmentTrack;
        this.dataManager = alignmentTrack.getDataManager();
        this.renderOptions = alignmentTrack.getRenderOptions();
        Alignment clickedAlignment = alignmentTrack.getAlignmentAt(e);
        JLabel popupTitle = new JLabel("  " + alignmentTrack.getName(), 0);
        Font newFont = this.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        this.add(popupTitle);
        if (CircularViewUtilities.ping()) {
            this.addSeparator();
            JMenuItem item = new JMenuItem("Add Discordant Pairs to Circular View");
            item.setEnabled(alignmentTrack.getDataManager().isPairedEnd());
            this.add(item);
            item.addActionListener(ae -> alignmentTrack.sendPairsToCircularView(e));
            JMenuItem item2 = new JMenuItem("Add Split Reads to Circular View");
            this.add(item2);
            item2.addActionListener(ae -> alignmentTrack.sendSplitToCircularView(e));
        }
        List<Track> tracks = List.of(alignmentTrack);
        this.addSeparator();
        this.add(TrackMenuUtils.getTrackRenameItem(tracks));
        JMenuItem item = new JMenuItem("Change Track Color...");
        item.addActionListener(evt -> TrackMenuUtils.changeTrackColor(tracks));
        this.add(item);
        this.addSeparator();
        this.addExperimentTypeMenuItem();
        this.addSeparator();
        this.addGroupMenuItem(e);
        this.addSortMenuItem();
        this.addColorByMenuItem();
        this.addShadeAlignmentsMenuItem();
        this.addPackMenuItem();
        this.addSeparator();
        this.addShadeBaseByMenuItem();
        JMenuItem misMatchesItem = this.addShowMismatchesMenuItem();
        JMenuItem showAllItem = this.addShowAllBasesMenuItem();
        misMatchesItem.addActionListener(new Deselector(misMatchesItem, showAllItem));
        showAllItem.addActionListener(new Deselector(showAllItem, misMatchesItem));
        this.addDuplicatesMenuItem();
        JCheckBoxMenuItem smallIndelsItem = new JCheckBoxMenuItem("Hide small indels");
        smallIndelsItem.setSelected(this.renderOptions.isHideSmallIndels());
        smallIndelsItem.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            if (smallIndelsItem.isSelected()) {
                String sith = MessageUtils.showInputDialog("Small indel threshold: ", String.valueOf(this.renderOptions.getSmallIndelThreshold()));
                if (sith == null) {
                    return;
                }
                try {
                    this.renderOptions.setSmallIndelThreshold(Integer.parseInt(sith));
                }
                catch (NumberFormatException exc) {
                    log.error("Error setting small indel threshold - not an integer", exc);
                    return;
                }
            }
            this.renderOptions.setHideSmallIndels(smallIndelsItem.isSelected());
            alignmentTrack.repaint();
            IGV.getInstance().repaintHeaderPanels();
        }));
        this.add(smallIndelsItem);
        JMenuItem indelSizeItem = new JMenuItem("Set indel size threshold...");
        indelSizeItem.setEnabled(this.renderOptions.isHideSmallIndels());
        indelSizeItem.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            String sith = MessageUtils.showInputDialog("Small indel threshold: ", String.valueOf(this.renderOptions.getSmallIndelThreshold()));
            if (sith != null) {
                try {
                    this.renderOptions.setSmallIndelThreshold(Integer.parseInt(sith));
                    alignmentTrack.repaint();
                    IGV.getInstance().repaintHeaderPanels();
                }
                catch (NumberFormatException exc) {
                    log.error("Error setting small indel threshold - not an integer", exc);
                }
            }
        }));
        this.add(indelSizeItem);
        if (this.dataManager.isPairedEnd()) {
            this.addSeparator();
            this.addViewAsPairsMenuItem();
            if (clickedAlignment != null) {
                this.addGoToMate(e, clickedAlignment);
                this.showMateRegion(e, clickedAlignment);
            }
            this.addInsertSizeMenuItem();
        }
        this.addSeparator();
        this.addThirdGenItems(clickedAlignment, e);
        if (AlignmentTrack.ExperimentType.SBX == alignmentTrack.getExperimentType()) {
            this.addSBXItems(clickedAlignment, e);
        }
        this.addSeparator();
        TrackMenuUtils.addDisplayModeItems(tracks, this);
        this.addSeparator();
        this.addSelectByNameItem(alignmentTrack, e);
        this.addSelectByBaseAtPosition(alignmentTrack, e);
        this.addClearSelectionsMenuItem();
        this.addSeparator();
        this.addCopyToClipboardItem(e, clickedAlignment);
        this.addCopySequenceItems(e);
        this.addConsensusSequence(e);
        this.addSeparator();
        this.addBlatItem(e);
        this.addBlatClippingItems(e);
        AlignmentBlock insertion = alignmentTrack.getInsertion(clickedAlignment, e.getMouseEvent().getX());
        if (insertion != null) {
            this.addSeparator();
            this.addInsertionItems(insertion);
        }
        if (alignmentTrack.getExperimentType() == AlignmentTrack.ExperimentType.RNA) {
            this.addSeparator();
            JMenuItem sashimi = new JMenuItem("Sashimi Plot");
            sashimi.addActionListener(e1 -> SashimiPlot.openSashimiPlot());
            sashimi.setEnabled(alignmentTrack.getExperimentType() == AlignmentTrack.ExperimentType.RNA);
            this.add(sashimi);
        }
        if (alignmentTrack.getExperimentType() == AlignmentTrack.ExperimentType.THIRD_GEN) {
            this.addSeparator();
            this.addClusterItem(e);
        }
        this.addSeparator();
        this.addShowItems();
    }

    private void addDuplicatesMenuItem() {
        JMenu duplicatesMenu = new JMenu("Duplicates");
        for (AlignmentTrack.DuplicatesOption option : AlignmentTrack.DuplicatesOption.values()) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(option.label);
            AlignmentTrack.DuplicatesOption previous = this.renderOptions.getDuplicatesOption();
            mi.setSelected(previous == option);
            mi.addActionListener(aEvt -> {
                this.renderOptions.setDuplicatesOption(option);
                if (previous != option) {
                    if (previous.filtered != option.filtered) {
                        IGVEventBus.getInstance().post(new AlignmentTrackEvent(AlignmentTrackEvent.Type.RELOAD));
                    } else {
                        this.alignmentTrack.repaint();
                    }
                } else {
                    this.alignmentTrack.repaint();
                }
            });
            duplicatesMenu.add(mi);
        }
        this.add(duplicatesMenu);
    }

    private void addShowChimericRegions(AlignmentTrack alignmentTrack, TrackClickEvent e, Alignment clickedAlignment) {
        JMenuItem item = new JMenuItem("View chimeric alignments in split screen");
        if (clickedAlignment != null && clickedAlignment.getAttribute(SAMTag.SA.name()) != null) {
            item.setEnabled(true);
            item.addActionListener(aEvt -> {
                String saTag = clickedAlignment.getAttribute(SAMTag.SA.name()).toString();
                try {
                    List<SupplementaryAlignment> supplementaryAlignments = SupplementaryAlignment.parseFromSATag(saTag);
                    alignmentTrack.setSelectedAlignment(clickedAlignment);
                    this.conditionallyGroupBySelected();
                    FrameManager.addNewLociToFrames(e.getFrame(), supplementaryAlignments);
                }
                catch (Exception ex) {
                    MessageUtils.showMessage("Failed to handle SA tag: " + saTag + " due to " + ex.getMessage());
                    item.setEnabled(false);
                }
            });
        } else {
            item.setEnabled(false);
        }
        this.add(item);
    }

    private void addShowDiagram(TrackClickEvent e, Alignment clickedAlignment) {
        JMenuItem item = new JMenuItem("Supplementary Reads Diagram");
        if (clickedAlignment != null && clickedAlignment.getAttribute(SAMTag.SA.name()) != null) {
            item.setEnabled(true);
            item.addActionListener(aEvt -> {
                try {
                    SupplementaryAlignmentDiagramDialog frame = new SupplementaryAlignmentDiagramDialog(IGV.getInstance().getMainFrame(), clickedAlignment, new Dimension(500, 250));
                    frame.setVisible(true);
                }
                catch (Exception ex) {
                    MessageUtils.showMessage("Failed to handle SA tag: " + String.valueOf(clickedAlignment.getAttribute(SAMTag.SA.name())) + " due to " + ex.getMessage());
                    item.setEnabled(false);
                }
            });
        } else {
            item.setEnabled(false);
        }
        this.add(item);
    }

    private void addClusterItem(TrackClickEvent e) {
        JMenuItem item = new JMenuItem("Cluster alignments  *EXPERIMENTAL*");
        ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
        item.setEnabled(frame != null);
        this.add(item);
        item.addActionListener(ae -> {
            if (frame == null) {
                MessageUtils.showMessage("Unknown region bounds");
                return;
            }
            String nString = MessageUtils.showInputDialog("Enter the number of clusters", String.valueOf(nClusters));
            if (nString == null) {
                return;
            }
            try {
                nClusters = Integer.parseInt(nString);
            }
            catch (NumberFormatException e1) {
                MessageUtils.showMessage("Clusters size must be an integer");
                return;
            }
            int start = (int)frame.getOrigin();
            int end = (int)frame.getEnd();
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            ClusterUtils clusterUtils = new ClusterUtils(interval);
            boolean success = clusterUtils.clusterAlignments(frame.getChrName(), start, end, nClusters);
            if (success) {
                this.groupAlignments(AlignmentTrack.GroupOption.CLUSTER, null, null);
                this.alignmentTrack.repaint();
            }
        });
    }

    private void addConsensusSequence(TrackClickEvent e) {
        JMenuItem item = new JMenuItem("Copy consensus sequence");
        ReferenceFrame frame = e.getFrame() == null && FrameManager.getFrames().size() == 1 ? FrameManager.getFrames().get(0) : e.getFrame();
        item.setEnabled(frame != null);
        this.add(item);
        item.addActionListener(ae -> {
            if (frame == null) {
                MessageUtils.showMessage("Unknown region bounds, cannot export consensus");
                return;
            }
            int start = (int)frame.getOrigin();
            int end = (int)frame.getEnd();
            if (end - start > 1000000) {
                MessageUtils.showMessage("Cannot export region more than 1 Megabase");
                return;
            }
            AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
            AlignmentCounts counts = interval.getCounts();
            String text = PFMExporter.createPFMText(counts, frame.getChrName(), start, end);
            StringUtils.copyTextToClipboard(text);
        });
    }

    private JMenu getBisulfiteContextMenuItem(ButtonGroup group) {
        JMenu bisulfiteContextMenu = new JMenu("bisulfite mode");
        JRadioButtonMenuItem nomeESeqOption = null;
        boolean showNomeESeq = this.alignmentTrack.getPreferences().getAsBoolean("SAM.NOMESEQ_ENABLED");
        if (showNomeESeq) {
            nomeESeqOption = new JRadioButtonMenuItem("NOMe-seq bisulfite mode");
            nomeESeqOption.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.NOMESEQ);
            nomeESeqOption.addActionListener(aEvt -> {
                this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.NOMESEQ);
                this.alignmentTrack.repaint();
            });
            group.add(nomeESeqOption);
        }
        for (AlignmentTrack.BisulfiteContext item : AlignmentTrack.BisulfiteContext.values()) {
            JRadioButtonMenuItem m1 = new JRadioButtonMenuItem(item.getLabel());
            m1.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BISULFITE && this.renderOptions.bisulfiteContext == item);
            m1.addActionListener(aEvt -> {
                this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.BISULFITE);
                this.alignmentTrack.setBisulfiteContext(item);
                this.alignmentTrack.repaint();
            });
            bisulfiteContextMenu.add(m1);
            group.add(m1);
        }
        if (nomeESeqOption != null) {
            bisulfiteContextMenu.add(nomeESeqOption);
        }
        return bisulfiteContextMenu;
    }

    void addSelectByNameItem(AlignmentTrack track, TrackClickEvent e) {
        JMenuItem item = new JMenuItem("Select by name...");
        Alignment alignment = track.getAlignmentAt(e);
        String alignmentName = alignment == null ? "" : alignment.getReadName();
        item.addActionListener(aEvt -> {
            String val = MessageUtils.showInputDialog("Enter read name: ", alignmentName);
            if (val != null && val.trim().length() > 0) {
                String[] names;
                for (String name : names = val.split("\\s*,\\s*")) {
                    if (name.isEmpty()) continue;
                    this.alignmentTrack.getSelectedReadNames().put(name, this.alignmentTrack.getReadNamePalette().get(name));
                }
                this.alignmentTrack.repaint();
            }
        });
        this.add(item);
    }

    void addSelectByBaseAtPosition(AlignmentTrack track, TrackClickEvent e) {
        MouseEvent me = e.getMouseEvent();
        ReferenceFrame frame = e.getFrame() != null ? e.getFrame() : FrameManager.getDefaultFrame();
        int clickedPos = (int)frame.getChromosomePosition(me);
        JMenuItem item = new JMenuItem("Select by base at position (e.g " + (clickedPos + 1) + ":T) ...");
        Alignment clickedAlignment = track.getAlignmentAt(e);
        if (clickedAlignment == null) {
            item.setEnabled(false);
            item.setToolTipText("No alignment found at clicked position.");
        } else {
            byte clickedBase = clickedAlignment.getBase(clickedPos);
            item.addActionListener(aEvt -> {
                MessageUtils.ValueCheckboxHolder valHolder = MessageUtils.showInputDialog("Enter base: ", String.valueOf(clickedPos + 1) + ":" + (char)clickedBase, "clear other");
                if (valHolder == null) {
                    return;
                }
                String val = valHolder.value;
                if (valHolder.isChecked) {
                    this.alignmentTrack.getSelectedReadNames().clear();
                }
                if (val != null && val.trim().length() > 0) {
                    int selectedPos;
                    String[] selected = val.split("\\s*:\\s*");
                    if (selected.length != 2 || selected[1].length() != 1) {
                        MessageUtils.showMessage("Invalid format. Expected format: position:base (e.g., 12345:A)");
                        return;
                    }
                    try {
                        selectedPos = Integer.parseInt(selected[0]) - 1;
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showMessage("Invalid position. Expected a numeric value.");
                        return;
                    }
                    final byte selectedBase = selected[1].getBytes()[0];
                    final AlignmentInterval interval = this.dataManager.getLoadedInterval(frame);
                    if (interval == null) {
                        MessageUtils.showMessage("No alignments loaded in the current region.");
                        return;
                    }
                    new SwingWorker<Void, Void>(){

                        @Override
                        protected Void doInBackground() {
                            List<Alignment> alList = interval.getAlignments();
                            for (Alignment alignment : alList) {
                                if (selectedPos < alignment.getStart() || selectedPos >= alignment.getEnd() || alignment.getBase(selectedPos) != selectedBase) continue;
                                AlignmentTrackMenu.this.alignmentTrack.getSelectedReadNames().put(alignment.getReadName(), AlignmentTrackMenu.this.alignmentTrack.getReadNamePalette().get(alignment.getReadName()));
                            }
                            return null;
                        }

                        @Override
                        protected void done() {
                            AlignmentTrackMenu.this.alignmentTrack.repaint();
                        }
                    }.execute();
                }
            });
        }
        this.add(item);
    }

    void addExperimentTypeMenuItem() {
        LinkedHashMap<String, AlignmentTrack.ExperimentType> mappings = new LinkedHashMap<String, AlignmentTrack.ExperimentType>();
        mappings.put("Other", AlignmentTrack.ExperimentType.OTHER);
        mappings.put("RNA", AlignmentTrack.ExperimentType.RNA);
        mappings.put("3rd Gen", AlignmentTrack.ExperimentType.THIRD_GEN);
        mappings.put("SBX", AlignmentTrack.ExperimentType.SBX);
        JMenu groupMenu = new JMenu("Experiment Type");
        ButtonGroup group = new ButtonGroup();
        for (Map.Entry el : mappings.entrySet()) {
            JCheckBoxMenuItem mi = this.getExperimentTypeMenuItem((String)el.getKey(), (AlignmentTrack.ExperimentType)((Object)el.getValue()));
            groupMenu.add(mi);
            group.add(mi);
        }
        this.add(groupMenu);
    }

    private JCheckBoxMenuItem getExperimentTypeMenuItem(String label, AlignmentTrack.ExperimentType option) {
        JCheckBoxMenuItem mi = new JCheckBoxMenuItem(label);
        mi.setSelected(this.alignmentTrack.getExperimentType() == option);
        mi.addActionListener(aEvt -> this.alignmentTrack.setExperimentType(option));
        return mi;
    }

    void addGroupMenuItem(TrackClickEvent te) {
        AlignmentTrack.GroupOption[] groupOptions;
        MouseEvent me = te.getMouseEvent();
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            frame = FrameManager.getDefaultFrame();
        }
        Range range = frame.getCurrentRange();
        String chrom = range.getChr();
        int chromStart = (int)frame.getChromosomePosition(me);
        JMenu groupMenu = new JMenu("Group alignments by");
        ButtonGroup group = new ButtonGroup();
        for (AlignmentTrack.GroupOption option : groupOptions = new AlignmentTrack.GroupOption[]{AlignmentTrack.GroupOption.NONE, AlignmentTrack.GroupOption.STRAND, AlignmentTrack.GroupOption.FIRST_OF_PAIR_STRAND, AlignmentTrack.GroupOption.SAMPLE, AlignmentTrack.GroupOption.LIBRARY, AlignmentTrack.GroupOption.READ_GROUP, AlignmentTrack.GroupOption.MATE_CHROMOSOME, AlignmentTrack.GroupOption.PAIR_ORIENTATION, AlignmentTrack.GroupOption.CHIMERIC, AlignmentTrack.GroupOption.SUPPLEMENTARY, AlignmentTrack.GroupOption.REFERENCE_CONCORDANCE, AlignmentTrack.GroupOption.MOVIE, AlignmentTrack.GroupOption.ZMW, AlignmentTrack.GroupOption.READ_ORDER, AlignmentTrack.GroupOption.LINKED, AlignmentTrack.GroupOption.PHASE, AlignmentTrack.GroupOption.MAPPING_QUALITY, AlignmentTrack.GroupOption.SELECTED, AlignmentTrack.GroupOption.DUPLICATE}) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem(option.label);
            mi.setSelected(this.renderOptions.getGroupByOption() == option);
            mi.addActionListener(aEvt -> this.groupAlignments(option, null, null));
            groupMenu.add(mi);
            group.add(mi);
        }
        JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
        tagOption.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getGroupByTag());
            if (tag != null) {
                if (tag.trim().length() > 0) {
                    this.groupAlignments(AlignmentTrack.GroupOption.TAG, tag, null);
                } else {
                    this.groupAlignments(AlignmentTrack.GroupOption.NONE, null, null);
                }
            }
        });
        tagOption.setSelected(this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.TAG);
        groupMenu.add(tagOption);
        group.add(tagOption);
        JCheckBoxMenuItem newGroupByPosOption = new JCheckBoxMenuItem("base at " + chrom + ":" + Globals.DECIMAL_FORMAT.format(1 + chromStart));
        newGroupByPosOption.addActionListener(aEvt -> {
            Range groupByPos = new Range(chrom, chromStart, chromStart + 1);
            this.groupAlignments(AlignmentTrack.GroupOption.BASE_AT_POS, null, groupByPos);
        });
        groupMenu.add(newGroupByPosOption);
        group.add(newGroupByPosOption);
        JCheckBoxMenuItem newGroupByInsOption = new JCheckBoxMenuItem("insertion at " + chrom + ":" + Globals.DECIMAL_FORMAT.format(1 + chromStart));
        newGroupByInsOption.addActionListener(aEvt -> {
            Range groupByPos = new Range(chrom, chromStart, chromStart + 1);
            this.groupAlignments(AlignmentTrack.GroupOption.INSERTION_AT_POS, null, groupByPos);
        });
        groupMenu.add(newGroupByInsOption);
        group.add(newGroupByInsOption);
        groupMenu.add(new JPopupMenu.Separator());
        JCheckBoxMenuItem invertGroupNameSortingOption = new JCheckBoxMenuItem("Reverse group order");
        invertGroupNameSortingOption.setSelected(this.renderOptions.isInvertGroupSorting());
        invertGroupNameSortingOption.addActionListener(aEvt -> {
            this.renderOptions.setInvertGroupSorting(!this.renderOptions.isInvertGroupSorting());
            this.alignmentTrack.packAlignments();
            this.alignmentTrack.repaint();
        });
        groupMenu.add(invertGroupNameSortingOption);
        JCheckBoxMenuItem groupAllOption = new JCheckBoxMenuItem("Group all tracks");
        groupAllOption.setSelected(this.alignmentTrack.getPreferences().getAsBoolean("SAM.GROUP_ALL"));
        groupAllOption.addActionListener(aEvt -> this.alignmentTrack.getPreferences().put("SAM.GROUP_ALL", groupAllOption.getState()));
        groupMenu.add(groupAllOption);
        this.add(groupMenu);
    }

    private void groupAlignments(AlignmentTrack.GroupOption option, String tag, Range pos) {
        if (this.alignmentTrack.getPreferences().getAsBoolean("SAM.GROUP_ALL")) {
            for (AlignmentTrack t : IGV.getInstance().getAlignmentTracks()) {
                t.groupAlignments(option, tag, pos);
            }
        } else {
            this.alignmentTrack.groupAlignments(option, tag, pos);
        }
    }

    void addSortMenuItem() {
        JMenu sortMenu = new JMenu("Sort alignments by");
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, SortOption> mappings = new LinkedHashMap<String, SortOption>();
        mappings.put("base", SortOption.BASE);
        mappings.put("read strand", SortOption.STRAND);
        mappings.put("first-of-pair strand", SortOption.FIRST_OF_PAIR_STRAND);
        mappings.put("mapping quality", SortOption.QUALITY);
        mappings.put("sample", SortOption.SAMPLE);
        mappings.put("read group", SortOption.READ_GROUP);
        mappings.put("read order", SortOption.READ_ORDER);
        mappings.put("read name", SortOption.READ_NAME);
        mappings.put("aligned read length", SortOption.ALIGNED_READ_LENGTH);
        mappings.put("left clip", SortOption.LEFT_CLIP);
        mappings.put("right clip", SortOption.RIGHT_CLIP);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("insert size", SortOption.INSERT_SIZE);
            mappings.put("chromosome of mate", SortOption.MATE_CHR);
        }
        mappings.put("start location", SortOption.START);
        mappings.put("none", SortOption.NONE);
        SortOption currentSortOption = this.renderOptions.getSortOption();
        for (Map.Entry el : mappings.entrySet()) {
            JCheckBoxMenuItem mi = new JCheckBoxMenuItem((String)el.getKey());
            mi.setSelected(currentSortOption == el.getValue());
            mi.addActionListener(aEvt -> {
                SortOption option = (SortOption)((Object)((Object)el.getValue()));
                this.renderOptions.setSortOption(option);
                this.sortAlignmentTracks(option, null, this.renderOptions.isInvertSorting());
            });
            sortMenu.add(mi);
            group.add(mi);
        }
        JCheckBoxMenuItem tagOption = new JCheckBoxMenuItem("tag");
        tagOption.setSelected(currentSortOption == SortOption.TAG);
        tagOption.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getSortByTag());
            if (tag != null && tag.trim().length() > 0) {
                this.renderOptions.setSortByTag(tag);
                this.renderOptions.setSortOption(SortOption.TAG);
                this.sortAlignmentTracks(SortOption.TAG, tag, this.renderOptions.isInvertSorting());
            }
        });
        sortMenu.add(tagOption);
        group.add(tagOption);
        sortMenu.add(new JPopupMenu.Separator());
        JCheckBoxMenuItem invertGroupNameSortingOption = new JCheckBoxMenuItem("reverse sorting");
        invertGroupNameSortingOption.setSelected(this.renderOptions.isInvertSorting());
        invertGroupNameSortingOption.addActionListener(aEvt -> {
            boolean updatedInvertSorting = !this.renderOptions.isInvertSorting();
            this.renderOptions.setInvertSorting(updatedInvertSorting);
            this.sortAlignmentTracks(this.renderOptions.getSortOption(), this.renderOptions.getSortByTag(), updatedInvertSorting);
        });
        sortMenu.add(invertGroupNameSortingOption);
        this.add(sortMenu);
    }

    public void addFilterMenuItem() {
        JMenu filterMenu = new JMenu("Filter alignments by");
        JMenuItem mi = new JMenuItem("mapping quality");
        mi.addActionListener(aEvt -> {
            String defString = PreferencesManager.getPreferences().get("SAM.QUALITY_THRESHOLD");
            if (defString == null) {
                defString = "";
            }
            String mqString = MessageUtils.showInputDialog("Minimum mapping quality: ", defString);
            try {
                int n = Integer.parseInt(mqString);
            }
            catch (NumberFormatException e) {
                MessageUtils.showMessage("Mapping quality must be an integer");
            }
        });
        filterMenu.add(mi);
        this.add(filterMenu);
    }

    private JRadioButtonMenuItem getColorMenuItem(String label, AlignmentTrack.ColorOption option) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
        mi.setSelected(this.renderOptions.getColorOption() == option);
        mi.addActionListener(aEvt -> {
            this.alignmentTrack.setColorOption(option);
            this.alignmentTrack.repaint();
        });
        return mi;
    }

    private JRadioButtonMenuItem getBasemodColorMenuItem(String label, AlignmentTrack.ColorOption option, boolean groupByStrand, String filter) {
        JRadioButtonMenuItem mi = new JRadioButtonMenuItem(label);
        mi.setSelected(this.renderOptions.getColorOption() == option);
        mi.addActionListener(aEvt -> {
            this.alignmentTrack.setColorOption(option);
            this.renderOptions.setBasemodFilter(filter == null ? null : new BaseModficationFilter(filter));
            if (groupByStrand) {
                this.alignmentTrack.groupAlignments(AlignmentTrack.GroupOption.FIRST_OF_PAIR_STRAND, null, null);
            } else {
                this.alignmentTrack.repaint();
            }
        });
        return mi;
    }

    void addColorByMenuItem() {
        JMenu colorMenu = new JMenu("Color alignments by");
        ButtonGroup group = new ButtonGroup();
        LinkedHashMap<String, AlignmentTrack.ColorOption> mappings = new LinkedHashMap<String, AlignmentTrack.ColorOption>();
        mappings.put("none", AlignmentTrack.ColorOption.NONE);
        if (this.dataManager.hasYCTags()) {
            mappings.put("YC tag", AlignmentTrack.ColorOption.YC_TAG);
        }
        if (this.dataManager.isPairedEnd()) {
            mappings.put("insert size", AlignmentTrack.ColorOption.INSERT_SIZE);
            mappings.put("pair orientation", AlignmentTrack.ColorOption.PAIR_ORIENTATION);
            mappings.put("insert size and pair orientation", AlignmentTrack.ColorOption.UNEXPECTED_PAIR);
        }
        mappings.put("read strand", AlignmentTrack.ColorOption.READ_STRAND);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("first-of-pair strand", AlignmentTrack.ColorOption.FIRST_OF_PAIR_STRAND);
        }
        mappings.put("read group", AlignmentTrack.ColorOption.READ_GROUP);
        if (this.dataManager.isPairedEnd()) {
            mappings.put("read order", AlignmentTrack.ColorOption.READ_ORDER);
        }
        mappings.put("sample", AlignmentTrack.ColorOption.SAMPLE);
        mappings.put("library", AlignmentTrack.ColorOption.LIBRARY);
        mappings.put("movie", AlignmentTrack.ColorOption.MOVIE);
        mappings.put("ZMW", AlignmentTrack.ColorOption.ZMW);
        mappings.put("split", AlignmentTrack.ColorOption.SPLIT);
        for (Map.Entry el : mappings.entrySet()) {
            JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (AlignmentTrack.ColorOption)((Object)el.getValue()));
            colorMenu.add(mi);
            group.add(mi);
        }
        JRadioButtonMenuItem tagOption = new JRadioButtonMenuItem("tag");
        tagOption.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.TAG);
        tagOption.addActionListener(aEvt -> {
            this.alignmentTrack.setColorOption(AlignmentTrack.ColorOption.TAG);
            String tag = MessageUtils.showInputDialog("Enter tag", this.renderOptions.getColorByTag());
            if (tag != null && tag.trim().length() > 0) {
                this.alignmentTrack.setColorByTag(tag);
                this.alignmentTrack.repaint();
            }
        });
        colorMenu.add(tagOption);
        group.add(tagOption);
        colorMenu.add(this.getBisulfiteContextMenuItem(group));
        Set allModifications = this.dataManager.getAllBaseModificationKeys().stream().map(BaseModificationKey::getModification).collect(Collectors.toSet());
        int modificationCount = allModifications.size();
        if (modificationCount > 0) {
            String name;
            JRadioButtonMenuItem bmMenuItem;
            BaseModficationFilter filter = this.renderOptions.getBasemodFilter();
            boolean groupByStrand = this.alignmentTrack.getPreferences().getAsBoolean("BASEMOD.GROUP_BY_STRAND");
            colorMenu.addSeparator();
            if (modificationCount > 1) {
                bmMenuItem = this.getBasemodColorMenuItem("base modification (all)", AlignmentTrack.ColorOption.BASE_MODIFICATION, groupByStrand, null);
                bmMenuItem.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION && filter == null);
                colorMenu.add(bmMenuItem);
                group.add(bmMenuItem);
            }
            for (String m : allModifications) {
                name = BaseModificationUtils.modificationName(m);
                bmMenuItem = this.getBasemodColorMenuItem("base modification (" + name + ")", AlignmentTrack.ColorOption.BASE_MODIFICATION, groupByStrand, m);
                bmMenuItem.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION && filter != null && filter.pass(m));
                colorMenu.add(bmMenuItem);
                group.add(bmMenuItem);
            }
            colorMenu.addSeparator();
            if (modificationCount > 1) {
                bmMenuItem = this.getBasemodColorMenuItem("base modification 2-color (all)", AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR, groupByStrand, null);
                bmMenuItem.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR && filter == null);
                colorMenu.add(bmMenuItem);
                group.add(bmMenuItem);
            }
            for (String m : allModifications) {
                name = BaseModificationUtils.modificationName(m);
                bmMenuItem = this.getBasemodColorMenuItem("base modification 2-color (" + name + ")", AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR, groupByStrand, m);
                bmMenuItem.setSelected(this.renderOptions.getColorOption() == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR && filter != null && filter.pass(m));
                colorMenu.add(bmMenuItem);
                group.add(bmMenuItem);
            }
        }
        if (this.alignmentTrack.getPreferences().getAsBoolean("SMRT_KINETICS.SHOW_OPTIONS")) {
            mappings.clear();
            mappings.put("SMRT subread IPD", AlignmentTrack.ColorOption.SMRT_SUBREAD_IPD);
            mappings.put("SMRT subread PW", AlignmentTrack.ColorOption.SMRT_SUBREAD_PW);
            mappings.put("SMRT CCS fwd-strand aligned IPD", AlignmentTrack.ColorOption.SMRT_CCS_FWD_IPD);
            mappings.put("SMRT CCS fwd-strand aligned PW", AlignmentTrack.ColorOption.SMRT_CCS_FWD_PW);
            mappings.put("SMRT CCS rev-strand aligned IPD", AlignmentTrack.ColorOption.SMRT_CCS_REV_IPD);
            mappings.put("SMRT CCS rev-strand aligned PW", AlignmentTrack.ColorOption.SMRT_CCS_REV_PW);
            colorMenu.addSeparator();
            for (Map.Entry el : mappings.entrySet()) {
                JRadioButtonMenuItem mi = this.getColorMenuItem((String)el.getKey(), (AlignmentTrack.ColorOption)((Object)el.getValue()));
                colorMenu.add(mi);
                group.add(mi);
            }
        }
        this.add(colorMenu);
    }

    void addShadeAlignmentsMenuItem() {
        JMenu shadeMenu = new JMenu("Shade alignments by");
        for (AlignmentTrack.ShadeAlignmentsOption option : AlignmentTrack.ShadeAlignmentsOption.values()) {
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(option.label);
            mi.setSelected(this.renderOptions.getShadeAlignmentsOption() == option);
            mi.addActionListener(aEvt -> {
                this.alignmentTrack.setShadeAlignmentsOptions(option);
                this.alignmentTrack.repaint();
            });
            shadeMenu.add(mi);
        }
        this.add(shadeMenu);
    }

    void addPackMenuItem() {
        JMenuItem item = new JMenuItem("Re-pack alignments (undo sort)");
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            AlignmentTrackUtils.packAlignmentTracks();
            this.renderOptions.setSortOption(SortOption.NONE);
            this.alignmentTrack.repaint();
        }));
        this.add(item);
    }

    void addCopyToClipboardItem(TrackClickEvent te, Alignment alignment) {
        MouseEvent me = te.getMouseEvent();
        JMenuItem item = new JMenuItem("Copy read details");
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            item.setEnabled(false);
        } else {
            double location = frame.getChromosomePosition(me);
            item.addActionListener(aEvt -> this.copyToClipboard(te, alignment, location, me.getX()));
            if (alignment == null) {
                item.setEnabled(false);
            }
        }
        this.add(item);
    }

    void addViewAsPairsMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("View as pairs");
        item.setSelected(this.renderOptions.isViewPairs());
        item.addActionListener(aEvt -> {
            boolean viewAsPairs = item.isSelected();
            this.alignmentTrack.setViewAsPairs(viewAsPairs);
        });
        item.setEnabled(this.dataManager.isPairedEnd());
        this.add(item);
    }

    void addGoToMate(TrackClickEvent te, Alignment clickedAlignment) {
        JMenuItem item = new JMenuItem("Go to mate");
        this.addActionIfMatesAreMapped(te, clickedAlignment, item, this::gotoMate);
        this.add(item);
    }

    void showMateRegion(TrackClickEvent te, Alignment clickedAlignment) {
        JMenuItem item = new JMenuItem("View mate region in split screen");
        this.addActionIfMatesAreMapped(te, clickedAlignment, item, this::splitScreenMate);
        this.add(item);
    }

    private void addActionIfMatesAreMapped(TrackClickEvent te, Alignment clickedAlignment, JMenuItem item, BiConsumer<ReferenceFrame, Alignment> action) {
        ReferenceFrame frame = te.getFrame();
        if (frame == null) {
            item.setEnabled(false);
        } else {
            Alignment alignment = clickedAlignment.getSpecificAlignment(te.getChromosomePosition());
            item.addActionListener(aEvt -> action.accept(frame, alignment));
            if (alignment == null || !alignment.isPaired() || !alignment.getMate().isMapped()) {
                item.setEnabled(false);
            }
        }
    }

    void addClearSelectionsMenuItem() {
        JMenuItem item = new JMenuItem("Clear selections");
        item.addActionListener(aEvt -> {
            this.alignmentTrack.getSelectedReadNames().clear();
            AlignmentTrack.RenderOptions renderOptions = this.alignmentTrack.getRenderOptions();
            if (renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.SELECTED) {
                renderOptions.setGroupByOption(AlignmentTrack.GroupOption.NONE);
                this.dataManager.packAlignments(renderOptions, this.alignmentTrack.getDisplayMode());
            }
            this.alignmentTrack.repaint();
        });
        this.add(item);
    }

    JMenuItem addShowAllBasesMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show all bases");
        if (this.renderOptions.getColorOption() != AlignmentTrack.ColorOption.BISULFITE && this.renderOptions.getColorOption() != AlignmentTrack.ColorOption.NOMESEQ) {
            item.setSelected(this.renderOptions.isShowAllBases());
        }
        item.addActionListener(aEvt -> {
            this.renderOptions.setShowAllBases(item.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(item);
        return item;
    }

    JMenuItem addShowMismatchesMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show mismatched bases");
        item.setSelected(this.renderOptions.isShowMismatches());
        item.addActionListener(aEvt -> {
            this.renderOptions.setShowMismatches(item.isSelected());
            this.alignmentTrack.repaint();
        });
        this.add(item);
        return item;
    }

    void addInsertSizeMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Set insert size options ...");
        item.addActionListener(aEvt -> {
            InsertSizeSettingsDialog dlg = new InsertSizeSettingsDialog(IGV.getInstance().getMainFrame(), this.renderOptions);
            dlg.setModal(true);
            dlg.setVisible(true);
            if (!dlg.isCanceled()) {
                this.renderOptions.setComputeIsizes(dlg.isComputeIsize());
                this.renderOptions.setMinInsertSizePercentile(dlg.getMinPercentile());
                this.renderOptions.setMaxInsertSizePercentile(dlg.getMaxPercentile());
                if (this.renderOptions.computeIsizes.booleanValue()) {
                    this.dataManager.updatePEStats(this.renderOptions);
                }
                this.renderOptions.setMinInsertSize(dlg.getMinThreshold());
                this.renderOptions.setMaxInsertSize(dlg.getMaxThreshold());
                this.alignmentTrack.repaint();
            }
        });
        item.setEnabled(this.dataManager.isPairedEnd());
        this.add(item);
    }

    void addShadeBaseByMenuItem() {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Shade base by quality");
        item.setSelected(this.renderOptions.getShadeBasesOption());
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setShadeBasesOption(item.isSelected());
            this.alignmentTrack.repaint();
        }));
        this.add(item);
    }

    void addShowItems() {
        SpliceJunctionTrack spliceJunctionTrack;
        CoverageTrack coverageTrack = this.alignmentTrack.getCoverageTrack();
        if (coverageTrack != null) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Coverage Track");
            item.setSelected(coverageTrack.isVisible());
            item.setEnabled(!coverageTrack.isRemoved());
            item.addActionListener(aEvt -> {
                coverageTrack.setVisible(item.isSelected());
                IGV.getInstance().repaint(Arrays.asList(coverageTrack));
            });
            this.add(item);
        }
        if ((spliceJunctionTrack = this.alignmentTrack.getSpliceJunctionTrack()) != null) {
            JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Splice Junction Track");
            item.setSelected(spliceJunctionTrack.isVisible());
            item.setEnabled(!spliceJunctionTrack.isRemoved());
            item.addActionListener(aEvt -> {
                this.alignmentTrack.setVisible(item.isSelected());
                IGV.getInstance().repaint(Arrays.asList(spliceJunctionTrack));
            });
            this.add(item);
        }
        JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
        alignmentItem.setSelected(true);
        alignmentItem.addActionListener(e -> {
            this.alignmentTrack.setVisible(alignmentItem.isSelected());
            IGV.getInstance().repaint(Arrays.asList(this.alignmentTrack));
        });
        if (!(coverageTrack != null && coverageTrack.isVisible() || spliceJunctionTrack != null && spliceJunctionTrack.isVisible())) {
            alignmentItem.setEnabled(false);
        }
        this.add(alignmentItem);
    }

    void addCopySequenceItems(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("Copy read sequence");
        this.add(item);
        Alignment alignment = this.getSpecificAlignment(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(seq));
        int minimumBlatLength = 20;
        ClippingCounts clipping = alignment.getClippingCounts();
        if (clipping.getLeftSoft() > 0) {
            String lcSeq = this.getClippedSequence(alignment.getReadSequence(), 0, clipping.getLeftSoft());
            JMenuItem lccItem = new JMenuItem("Copy left-clipped sequence");
            this.add(lccItem);
            lccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(lcSeq));
        }
        if (clipping.getRightSoft() > 0) {
            int seqLength = seq.length();
            String rcSeq = this.getClippedSequence(alignment.getReadSequence(), seqLength - clipping.getRightSoft(), seqLength);
            JMenuItem rccItem = new JMenuItem("Copy right-clipped sequence");
            this.add(rccItem);
            rccItem.addActionListener(aEvt -> StringUtils.copyTextToClipboard(rcSeq));
        }
    }

    void addBlatItem(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("BLAT read sequence");
        this.add(item);
        Alignment alignment = this.getSpecificAlignment(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null || seq.equals("*")) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> {
            String blatSeq = alignment.getReadStrand() == Strand.NEGATIVE ? SequenceTrack.getReverseComplement(seq) : seq;
            BlatClient.doBlatQuery(blatSeq, alignment.getReadName());
        });
    }

    void addBlatClippingItems(TrackClickEvent te) {
        Alignment alignment = this.getSpecificAlignment(te);
        if (alignment == null) {
            return;
        }
        int minimumBlatLength = 20;
        ClippingCounts clipping = alignment.getClippingCounts();
        if (clipping.getLeftSoft() > minimumBlatLength) {
            String lcSeq = this.getClippedSequence(alignment.getReadSequence(), 0, clipping.getLeftSoft());
            String blatSeq = alignment.isNegativeStrand() ? SequenceTrack.getReverseComplement(lcSeq) : lcSeq;
            JMenuItem lcbItem = new JMenuItem("BLAT left-clipped sequence");
            this.add(lcbItem);
            lcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(blatSeq, alignment.getReadName() + " - left clip"));
        }
        if (clipping.getRightSoft() > minimumBlatLength) {
            String seq = alignment.getReadSequence();
            int seqLength = seq.length();
            String rcSeq = this.getClippedSequence(alignment.getReadSequence(), seqLength - clipping.getRightSoft(), seqLength);
            String blatSeq = alignment.isNegativeStrand() ? SequenceTrack.getReverseComplement(rcSeq) : rcSeq;
            JMenuItem rcbItem = new JMenuItem("BLAT right-clipped sequence");
            this.add(rcbItem);
            rcbItem.addActionListener(aEvt -> BlatClient.doBlatQuery(blatSeq, alignment.getReadName() + " - right clip"));
        }
    }

    private String getClippedSequence(String readSequence, int i, int i2) {
        if (readSequence == null || readSequence.equals("*")) {
            return "*";
        }
        return readSequence.substring(i, i2);
    }

    void addExtViewItem(TrackClickEvent te) {
        JMenuItem item = new JMenuItem("ExtView");
        this.add(item);
        Alignment alignment = this.alignmentTrack.getAlignmentAt(te);
        if (alignment == null) {
            item.setEnabled(false);
            return;
        }
        String seq = alignment.getReadSequence();
        if (seq == null) {
            item.setEnabled(false);
            return;
        }
        item.addActionListener(aEvt -> ExtendViewClient.postExtendView(alignment));
    }

    void addLinkedReadItems() {
        JCheckBoxMenuItem supplementalItem = new JCheckBoxMenuItem("Link supplementary alignments");
        supplementalItem.setSelected(this.alignmentTrack.isLinkedReads() && "READNAME".equals(this.renderOptions.getLinkByTag()));
        supplementalItem.addActionListener(aEvt -> {
            boolean linkedReads = supplementalItem.isSelected();
            this.setLinkByTag(linkedReads, "READNAME");
        });
        this.add(supplementalItem);
        String linkedTagsString = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
        if (linkedTagsString != null) {
            String[] t;
            for (String tag : t = Globals.commaPattern.split(linkedTagsString)) {
                if (tag.length() <= 0) continue;
                this.add(this.linkedReadItem(tag));
            }
        }
        JMenuItem linkByTagItem = new JMenuItem("Link by tag...");
        linkByTagItem.addActionListener(aEvt -> {
            String tag = MessageUtils.showInputDialog("Link by tag:");
            if (tag != null) {
                this.setLinkByTag(true, tag);
                Object linkedTags = PreferencesManager.getPreferences().get("SAM.LINK_BY_TAGS");
                linkedTags = linkedTags == null ? tag : (String)linkedTags + "," + tag;
                PreferencesManager.getPreferences().put("SAM.LINK_BY_TAGS", (String)linkedTags);
            }
        });
        this.add(linkByTagItem);
    }

    private JCheckBoxMenuItem linkedReadItem(String tag) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("Link by " + tag);
        item.setSelected(!this.alignmentTrack.isLinkedReadView() && this.alignmentTrack.isLinkedReads() && tag.equals(this.renderOptions.getLinkByTag()));
        item.addActionListener(aEvt -> {
            boolean linkedReads = item.isSelected();
            if ("BX".equals(tag) || "MI".equals(tag)) {
                this.alignmentTrack.setLinkedReadView(linkedReads, tag);
            } else {
                this.setLinkByTag(linkedReads, tag);
            }
        });
        return item;
    }

    private void addInsertionItems(AlignmentBlock insertion) {
        JMenuItem item = new JMenuItem("Copy insert sequence");
        this.add(item);
        item.addActionListener(aEvt -> StringUtils.copyTextToClipboard(insertion.getBases().getString()));
        if (insertion.getBases() != null && insertion.getBases().length >= 10) {
            JMenuItem blatItem = new JMenuItem("BLAT insert sequence");
            this.add(blatItem);
            blatItem.addActionListener(aEvt -> {
                String blatSeq = insertion.getBases().getString();
                BlatClient.doBlatQuery(blatSeq, "BLAT insert sequence");
            });
        }
    }

    void addThirdGenItems(Alignment clickedAlignment, TrackClickEvent tce) {
        this.addLinkedReadItems();
        this.addShowChimericRegions(this.alignmentTrack, tce, clickedAlignment);
        this.addShowDiagram(tce, clickedAlignment);
    }

    void addSBXItems(Alignment clickedAlignment, TrackClickEvent tce) {
        this.addSeparator();
        JCheckBoxMenuItem item = new JCheckBoxMenuItem("INDEL coloring uses grey (SBX)");
        item.setSelected(this.renderOptions.isIndelQualSbx());
        item.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setIndelQualSbx(item.isSelected());
            this.alignmentTrack.repaint();
        }));
        this.add(item);
        JCheckBoxMenuItem item2 = new JCheckBoxMenuItem("Simplex tail coloring (SBX)");
        item2.setSelected(this.renderOptions.isTailQualSbx());
        item2.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setTailQualSbx(item2.isSelected());
            this.alignmentTrack.repaint();
        }));
        this.add(item2);
        JCheckBoxMenuItem item3 = new JCheckBoxMenuItem("Hide simplex tails (SBX)");
        item3.setSelected(this.renderOptions.isHideTailSbx());
        item3.addActionListener(aEvt -> UIUtilities.invokeOnEventThread(() -> {
            this.renderOptions.setHideTailSbx(item3.isSelected());
            this.alignmentTrack.repaint();
        }));
        this.add(item3);
    }

    private void copyToClipboard(TrackClickEvent e, Alignment alignment, double location, int mouseX) {
        if (alignment != null) {
            String clipboardString = alignment.getClipboardString(location, mouseX).replace("<b>", "").replace("</b>", "").replace("<br>", "\n").replace("<br/>", "\n").replace("<hr>", "\n------------------\n").replace("<hr/>", "\n------------------\n");
            StringSelection stringSelection = new StringSelection(clipboardString);
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            clipboard.setContents(stringSelection, null);
        }
    }

    private void gotoMate(ReferenceFrame frame, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.alignmentTrack.setSelectedAlignment(alignment);
                String chr = mate.getChr();
                int start = mate.start - 1;
                double range = frame.getEnd() - frame.getOrigin();
                int newStart = (int)Math.max(0.0, (double)(start + (alignment.getEnd() - alignment.getStart()) / 2) - range / 2.0);
                int newEnd = newStart + (int)range;
                frame.jumpTo(chr, newStart, newEnd);
                frame.recordHistory();
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    private void splitScreenMate(ReferenceFrame frame, Alignment alignment) {
        if (alignment != null) {
            ReadMate mate = alignment.getMate();
            if (mate != null && mate.isMapped()) {
                this.alignmentTrack.setSelectedAlignment(alignment);
                this.conditionallyGroupBySelected();
                FrameManager.addNewLociToFrames(frame, List.of(mate));
            } else {
                MessageUtils.showMessage("Alignment does not have mate, or it is not mapped.");
            }
        }
    }

    private void conditionallyGroupBySelected() {
        AlignmentTrack.RenderOptions renderOptions = this.alignmentTrack.getRenderOptions();
        if (renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.NONE) {
            renderOptions.setGroupByOption(AlignmentTrack.GroupOption.SELECTED);
            this.dataManager.packAlignments(renderOptions, this.alignmentTrack.getDisplayMode());
        }
    }

    Alignment getSpecificAlignment(TrackClickEvent te) {
        Alignment alignment = this.alignmentTrack.getAlignmentAt(te);
        if (alignment != null) {
            alignment = alignment.getSpecificAlignment(te.getChromosomePosition());
        }
        return alignment;
    }

    private void setLinkByTag(boolean linkReads, String tag) {
        if (this.alignmentTrack.isLinkedReadView()) {
            this.alignmentTrack.undoLinkedReadView();
        }
        if (linkReads) {
            this.renderOptions.setLinkByTag(tag);
            if (this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.NONE) {
                this.renderOptions.setGroupByOption(AlignmentTrack.GroupOption.LINKED);
            }
        } else {
            this.renderOptions.setLinkByTag(null);
            if (this.renderOptions.getGroupByOption() == AlignmentTrack.GroupOption.LINKED) {
                this.renderOptions.setGroupByOption(AlignmentTrack.GroupOption.NONE);
            }
        }
        this.renderOptions.setLinkedReads(linkReads);
        this.alignmentTrack.packAlignments();
        this.alignmentTrack.repaint();
    }

    private void sortAlignmentTracks(SortOption option, String tag, boolean invertSort) {
        List<AlignmentTrack> tracksToSort = PreferencesManager.getPreferences().getAsBoolean("SAM.SORT_ALL") ? IGV.getInstance().getAlignmentTracks() : List.of(this.alignmentTrack);
        for (AlignmentTrack track : tracksToSort) {
            track.renderOptions.setSortOption(option);
            track.renderOptions.setSortByTag(tag);
            track.renderOptions.setInvertSorting(invertSort);
            track.sortRows(option, tag, invertSort);
        }
        IGV.getInstance().repaint(tracksToSort);
        Collection<IGVPreferences> allPrefs = PreferencesManager.getAllPreferences();
        for (IGVPreferences prefs : allPrefs) {
            prefs.put("SAM.SORT_OPTION", option.toString());
            prefs.put("SAM.SORT_BY_TAG", tag);
            prefs.put("SAM.INVERT_SORT", invertSort);
        }
    }

    private static class Deselector
    implements ActionListener {
        private final JMenuItem toDeselect;
        private final JMenuItem parent;

        Deselector(JMenuItem parent, JMenuItem toDeselect) {
            this.parent = parent;
            this.toDeselect = toDeselect;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.parent.isSelected()) {
                this.toDeselect.setSelected(false);
            }
        }
    }
}

