/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.List;
import org.igv.feature.LocusScore;
import org.igv.renderer.DataRenderer;
import org.igv.track.RenderContext;
import org.igv.track.Track;

public class FeatureDensityRenderer
extends DataRenderer {
    public String getDisplayName() {
        return "Feature Density";
    }

    @Override
    public void renderScores(Track track, List<LocusScore> scores, RenderContext context, Rectangle rect) {
        double origin = context.getOrigin();
        double locScale = context.getScale();
        double maxValue = track.getDataRange().getMaximum();
        double yScaleFactor = rect.getHeight() / maxValue;
        int pX = -1;
        Graphics2D g = context.getGraphics();
        for (LocusScore score : scores) {
            pX = (int)(((double)score.getStart() - origin) / locScale);
            if (pX < 0) continue;
            float dataY = (float)((double)(score.getScore() * 1000000.0f) / locScale);
            if (Float.isNaN(dataY)) {
                g.setColor(Color.LIGHT_GRAY.brighter());
                g.drawLine(pX, (int)rect.getY(), pX, (int)rect.getMaxY());
            } else {
                g.setColor(Color.CYAN.darker());
                double scaledY = (double)dataY * yScaleFactor;
                int pY = (int)Math.max(rect.getY(), rect.getMaxY() - scaledY);
                g.drawLine(pX, (int)rect.getMaxY(), pX, pY);
            }
            if ((double)pX > rect.getMaxX()) break;
            g.setColor(Color.BLACK);
            g.drawLine((int)rect.getX(), (int)rect.getMaxY(), (int)rect.getMaxX(), (int)rect.getMaxY());
        }
    }
}

