/*
 * Decompiled with CFR 0.152.
 */
package org.igv.maf;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class MAFTile {
    int start;
    int end;
    MASequence refSeq;
    int[] gapAdjustedIdx;
    List<Gap> gaps = new ArrayList<Gap>();
    Map<String, MASequence> alignedSequences;

    public MAFTile() {
    }

    public MAFTile(int start, int end) {
        this.start = start;
        this.end = end;
        this.alignedSequences = null;
        this.gapAdjustedIdx = null;
    }

    public MAFTile(int start, int end, Map<String, String> bases, int[] gapAdjustedCoordinates) {
        this(start, end, bases, gapAdjustedCoordinates, "hg18");
    }

    public MAFTile(int start, int end, Map<String, String> bases, int[] gapAdjustedCoordinates, String refSeqId) {
        this.start = start;
        this.end = end;
        this.gapAdjustedIdx = gapAdjustedCoordinates;
        int expectedGapAdjustedIdx = 0;
        for (int i = start; i < end; ++i) {
            int idx = i - start;
            int gapAdjIdx = this.gapAdjustedIdx[idx];
            if (gapAdjIdx != expectedGapAdjustedIdx) {
                this.gaps.add(new Gap(i, expectedGapAdjustedIdx, gapAdjIdx));
            }
            expectedGapAdjustedIdx = gapAdjIdx + 1;
        }
        this.refSeq = new MASequence(bases.get(refSeqId));
        this.alignedSequences = new LinkedHashMap<String, MASequence>();
        for (Map.Entry<String, String> entry : bases.entrySet()) {
            String spId = entry.getKey();
            String b = entry.getValue();
            this.alignedSequences.put(spId, new MASequence(b));
        }
    }

    public List<Gap> getGaps() {
        return this.gaps;
    }

    public static class Gap {
        int position;
        int startIdx;
        int endIdx;

        public Gap(int position, int startIdx, int endIdx) {
            this.position = position;
            this.startIdx = startIdx;
            this.endIdx = endIdx;
        }

        public int getPosition() {
            return this.position;
        }

        public int getCount() {
            return this.endIdx - this.startIdx;
        }

        public String toString() {
            return this.position + "(" + (this.endIdx - this.startIdx + 1) + ")";
        }
    }

    public class MASequence {
        String bases;

        public MASequence(String bases) {
            this.bases = bases;
        }

        public char getGapAdjustedBase(int refCoord) {
            int relCoord = refCoord - MAFTile.this.start;
            int idx = MAFTile.this.gapAdjustedIdx[relCoord];
            return idx > 0 && idx < this.bases.length() ? this.bases.charAt(idx) : (char)'\u0000';
        }

        public int getStart() {
            return MAFTile.this.start;
        }

        public int getEnd() {
            return MAFTile.this.end;
        }
    }
}

