/*
 * Decompiled with CFR 0.152.
 */
package org.igv.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.function.Supplier;
import java.util.logging.ConsoleHandler;
import org.igv.logging.Level;
import org.igv.logging.LogFileHandler;
import org.igv.logging.LogFormatter;

public class Logger {
    java.util.logging.Logger wrappedLogger;

    public Logger(String name) {
        this.wrappedLogger = java.util.logging.Logger.getLogger(name);
        this.wrappedLogger.setUseParentHandlers(false);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setFormatter(new LogFormatter());
        this.wrappedLogger.addHandler(handler);
        this.wrappedLogger.addHandler(LogFileHandler.getInstance());
    }

    public void info(String message) {
        this.wrappedLogger.info(message);
    }

    public void error(String message) {
        this.wrappedLogger.severe(message);
    }

    public void error(String message, Throwable e) {
        this.wrappedLogger.severe(message);
        if (e != null) {
            this.logThrowable(e);
        }
    }

    public void error(Throwable e) {
        this.logThrowable(e);
    }

    public void log(Level level, String message) {
        switch (level) {
            case ERROR: {
                this.error(message);
                break;
            }
            case WARN: {
                this.warn(message);
                break;
            }
            default: {
                this.info(message);
            }
        }
    }

    public void warn(String message) {
        this.wrappedLogger.warning(message);
    }

    public void warn(String message, Throwable e1) {
        this.wrappedLogger.warning(message);
        this.wrappedLogger.warning(e1.toString());
    }

    public void debug(String message) {
        if (this.isDebugEnabled()) {
            this.wrappedLogger.fine(message);
        }
    }

    public void debug(List<String> message) {
        if (this.isDebugEnabled()) {
            StringBuffer buf = new StringBuffer();
            for (String m : message) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append(m);
            }
            this.wrappedLogger.fine(buf.toString());
        }
    }

    public void trace(Object message) {
        if (this.isTraceEnabled()) {
            this.wrappedLogger.finest(message.toString());
        }
    }

    public boolean isDebugEnabled() {
        return false;
    }

    public boolean isTraceEnabled() {
        return false;
    }

    private void logThrowable(Throwable e) {
        Supplier<String> s = () -> {
            StringWriter writer = new StringWriter();
            PrintWriter pw = new PrintWriter(writer);
            e.printStackTrace(pw);
            pw.flush();
            return writer.toString();
        };
        this.wrappedLogger.severe(s);
    }
}

