/*
 * Decompiled with CFR 0.152.
 */
package org.igv.lists;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.igv.lists.GeneList;
import org.igv.lists.GeneListManager;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.IGVDialog;
import org.igv.ui.util.MessageUtils;

public class GeneListEditDialog
extends IGVDialog {
    private GeneList geneList;
    private boolean canceled = true;
    private boolean bedOptionChanged = false;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JLabel label1;
    private JTextField listNameField;
    private JLabel label2;
    private JScrollPane scrollPane1;
    private JTextArea genesField;
    private JScrollPane scrollPane2;
    private JTextArea descriptionField;
    private JLabel label3;
    private JCheckBox bedCB;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;

    public GeneListEditDialog(Dialog owner, GeneList geneList) {
        super(owner);
        this.initComponents();
        this.geneList = geneList;
        String name = geneList.getName();
        if (name != null) {
            this.listNameField.setText(name);
        }
        StringBuffer buf = new StringBuffer();
        List<String> loci = geneList.getLoci();
        if (loci != null) {
            for (String gene : geneList.getLoci()) {
                buf.append(gene);
                buf.append("\n");
            }
            this.genesField.setText(buf.toString());
        }
        this.bedCB.setSelected(PreferencesManager.getPreferences().getAsBoolean("GENE_LIST_BED_FORMAT"));
    }

    private String[] parseGenes(String text) {
        return text.trim().split("\\s+");
    }

    private void okButtonActionPerformed(ActionEvent e) {
        String name = this.listNameField.getText();
        if (name == null || name.length() == 0) {
            MessageUtils.showMessage("Name is required");
            return;
        }
        if (this.bedCB.isSelected()) {
            this.saveGeneList(name.trim(), this.parseBed(this.genesField.getText()));
        } else {
            String[] genes = this.parseGenes(this.genesField.getText());
            if (genes != null & genes.length == 0) {
                MessageUtils.showMessage("Lists must contain at least 1 locus");
                return;
            }
            this.saveGeneList(name.trim(), Arrays.asList(genes));
        }
        if (this.bedOptionChanged) {
            PreferencesManager.getPreferences().put("GENE_LIST_BED_FORMAT", this.bedCB.isSelected());
        }
        this.setVisible(false);
    }

    private List<String> parseBed(String string) {
        ArrayList<String> loci = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new StringReader(string));
        try {
            String nextLine;
            while ((nextLine = br.readLine()) != null) {
                String[] tokens = nextLine.split("\\s+");
                if (tokens.length <= 2) continue;
                loci.add(tokens[0] + ":" + (Integer.parseInt(tokens[1]) + 1) + "-" + tokens[2]);
            }
        }
        catch (IOException e) {
            MessageUtils.showErrorMessage("Error parsing bed data", e);
        }
        return loci;
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.setVisible(false);
    }

    private void bedCBActionPerformed(ActionEvent e) {
        this.bedOptionChanged = true;
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.label1 = new JLabel();
        this.listNameField = new JTextField();
        this.label2 = new JLabel();
        this.scrollPane1 = new JScrollPane();
        this.genesField = new JTextArea();
        this.scrollPane2 = new JScrollPane();
        this.descriptionField = new JTextArea();
        this.label3 = new JLabel();
        this.bedCB = new JCheckBox();
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new BorderLayout());
        this.contentPanel.setPreferredSize(new Dimension(435, 600));
        this.contentPanel.setLayout(null);
        this.label1.setText("Name: ");
        this.contentPanel.add(this.label1);
        this.label1.setBounds(5, 15, this.label1.getPreferredSize().width, 15);
        this.listNameField.setPreferredSize(new Dimension(520, 28));
        this.contentPanel.add(this.listNameField);
        this.listNameField.setBounds(new Rectangle(new Point(65, 9), this.listNameField.getPreferredSize()));
        this.label2.setText("<html>Enter or paste genes or loci below &nbsp;&nbsp;<i>(e.g EGFR or chr1:1000-2000)");
        this.contentPanel.add(this.label2);
        this.label2.setBounds(5, 155, 425, 37);
        this.scrollPane1.setViewportView(this.genesField);
        this.contentPanel.add(this.scrollPane1);
        this.scrollPane1.setBounds(6, 195, 579, 415);
        this.scrollPane2.setViewportView(this.descriptionField);
        this.contentPanel.add(this.scrollPane2);
        this.scrollPane2.setBounds(5, 75, 579, 70);
        this.label3.setText("Description: ");
        this.contentPanel.add(this.label3);
        this.label3.setBounds(new Rectangle(new Point(5, 50), this.label3.getPreferredSize()));
        this.bedCB.setText("BED format");
        this.bedCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListEditDialog.this.bedCBActionPerformed(e);
            }
        });
        this.contentPanel.add(this.bedCB);
        this.bedCB.setBounds(new Rectangle(new Point(475, 160), this.bedCB.getPreferredSize()));
        Dimension preferredSize = new Dimension();
        for (int i = 0; i < this.contentPanel.getComponentCount(); ++i) {
            Rectangle bounds = this.contentPanel.getComponent(i).getBounds();
            preferredSize.width = Math.max(bounds.x + bounds.width, preferredSize.width);
            preferredSize.height = Math.max(bounds.y + bounds.height, preferredSize.height);
        }
        Insets insets = this.contentPanel.getInsets();
        preferredSize.width += insets.right;
        preferredSize.height += insets.bottom;
        this.contentPanel.setMinimumSize(preferredSize);
        this.contentPanel.setPreferredSize(preferredSize);
        this.dialogPane.add((Component)this.contentPanel, "Center");
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListEditDialog.this.okButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListEditDialog.this.cancelButtonActionPerformed(e);
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, "South");
        contentPane.add((Component)this.dialogPane, "Center");
        this.setSize(650, 710);
        this.setLocationRelativeTo(this.getOwner());
    }

    private void saveGeneList(String name, List<String> genes) {
        this.canceled = false;
        this.geneList.setName(name);
        this.geneList.setLoci(genes);
        this.geneList.setDescription(this.descriptionField.getText().trim());
        GeneListManager.getInstance().saveGeneList(this.geneList);
    }

    public boolean isCanceled() {
        return this.canceled;
    }
}

