/*
 * Decompiled with CFR 0.152.
 */
package org.igv.htsget;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.igv.htsget.HtsgetUtils;
import org.igv.util.HttpUtils;
import org.json.JSONArray;
import org.json.JSONObject;

class HtsgetReader {
    private String url;
    private String format;

    static HtsgetReader getReader(HtsgetUtils.Metadata metadata) {
        String format = metadata.getFormat();
        return new HtsgetReader(metadata.getUrl(), format);
    }

    HtsgetReader(String url, String format) {
        this.url = url;
        this.format = format.toUpperCase();
    }

    byte[] readHeader() throws IOException {
        URL headerURL = HtsgetUtils.addQueryString(this.url, "class=header&format=" + this.format);
        String ticketString = HttpUtils.getInstance().getContentsAsJSON(headerURL);
        JSONObject ticket = new JSONObject(ticketString);
        return this.loadURLs(ticket);
    }

    byte[] readData(String chr, int start, int end) throws IOException {
        String queryString = "format=" + this.format + "&referenceName=" + chr + "&start=" + start + "&end=" + end;
        URL queryURL = HtsgetUtils.addQueryString(this.url, queryString);
        String ticketString = HttpUtils.getInstance().getContentsAsJSON(queryURL);
        JSONObject ticket = new JSONObject(ticketString);
        return this.loadURLs(ticket);
    }

    private byte[] loadURLs(JSONObject ticket) throws IOException {
        JSONObject container = ticket.getJSONObject("htsget");
        JSONArray urls = container.getJSONArray("urls");
        byte[] bytes = null;
        for (int i = 0; i < urls.length(); ++i) {
            JSONObject next = urls.getJSONObject(i);
            String urlString = next.getString("url");
            if (urlString.startsWith("data:")) {
                throw new RuntimeException("Data URLs are not currently supported");
            }
            URL url = new URL(urlString);
            HashMap<String, String> headers = new HashMap<String, String>();
            if (next.has("headers")) {
                JSONObject headerObj = next.getJSONObject("headers");
                for (String key : headerObj.keySet()) {
                    headers.put(key, headerObj.getString(key));
                }
            }
            byte[] b = HttpUtils.getInstance().getContentsAsBytes(url, headers);
            if (bytes == null) {
                bytes = b;
                continue;
            }
            byte[] newBytes = new byte[bytes.length + b.length];
            System.arraycopy(bytes, 0, newBytes, 0, bytes.length);
            System.arraycopy(b, 0, newBytes, bytes.length, b.length);
            bytes = newBytes;
        }
        return bytes;
    }
}

