/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.igv.ucsc.twobit.UnsignedByteBuffer;

public class StaticBlockIndex {
    private final Map<Integer, BlockIndexEntry> blockIndex = new HashMap<Integer, BlockIndexEntry>();

    public StaticBlockIndex(int nBlocks, UnsignedByteBuffer dis) throws IOException {
        while (nBlocks-- > 0) {
            int blockNumber = dis.getInt();
            long filePosition = dis.getLong();
            int size = dis.getInt();
            this.blockIndex.put(blockNumber, new BlockIndexEntry(filePosition, size));
        }
    }

    public BlockIndexEntry getBlockIndexEntry(int blockNumber) {
        return this.blockIndex.get(blockNumber);
    }

    public static class BlockIndexEntry {
        public final long filePosition;
        public final int size;

        public BlockIndexEntry(long filePosition, int size) {
            this.filePosition = filePosition;
            this.size = size;
        }
    }
}

