/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.igv.feature.Chromosome;
import org.igv.hic.Region;
import org.igv.hic.StaticBlockIndex;
import org.igv.ucsc.twobit.UnsignedByteBuffer;

public class MatrixZoomData {
    private final Chromosome chr1;
    private final Chromosome chr2;
    private Zoom zoom;
    int blockBinCount;
    int blockColumnCount;
    private StaticBlockIndex blockIndex;
    double averageCount;
    double sumCounts;
    double stdDev;
    double occupiedCellCount;
    double percent95;

    public MatrixZoomData(Chromosome chr1, Chromosome chr2) {
        this.chr1 = chr1;
        this.chr2 = chr2;
    }

    public String getKey() {
        return this.chr1.getName() + "_" + this.chr2.getName() + "_" + this.zoom.unit + "_" + this.zoom.binSize;
    }

    public List<Integer> getBlockNumbers(Region region1, Region region2, int version) {
        if (region1.chr().equals(this.chr2.getName()) && region2.chr().equals(this.chr1.getName())) {
            Region tmp = region1;
            region1 = region2;
            region2 = tmp;
        }
        boolean sameChr = this.chr1 == this.chr2;
        int binsize = this.zoom.binSize;
        int blockBinCount = this.blockBinCount;
        int blockColumnCount = this.blockColumnCount;
        if (version < 9 || !sameChr) {
            return this.getBlockNumbersV8(region1, region2, binsize, blockBinCount, blockColumnCount, sameChr);
        }
        return this.getBlockNumbersV9(region1, region2, binsize, blockBinCount, blockColumnCount);
    }

    private List<Integer> getBlockNumbersV8(Region region1, Region region2, int binsize, int blockBinCount, int blockColumnCount, boolean sameChr) {
        long x1 = region1.start() / binsize;
        long x2 = region1.end() / binsize;
        long y1 = region2.start() / binsize;
        long y2 = region2.end() / binsize;
        int col1 = (int)Math.floor((double)x1 / (double)blockBinCount);
        int col2 = (int)Math.floor((double)(x2 - 1L) / (double)blockBinCount);
        int row1 = (int)Math.floor((double)y1 / (double)blockBinCount);
        int row2 = (int)Math.floor((double)(y2 - 1L) / (double)blockBinCount);
        ArrayList<Integer> blockNumbers = new ArrayList<Integer>();
        for (int row = row1; row <= row2; ++row) {
            for (int column = col1; column <= col2; ++column) {
                int blockNumber = sameChr && row < column ? column * blockColumnCount + row : row * blockColumnCount + column;
                if (blockNumbers.contains(blockNumber)) continue;
                blockNumbers.add(blockNumber);
            }
        }
        return blockNumbers;
    }

    private List<Integer> getBlockNumbersV9(Region region1, Region region2, int binsize, int blockBinCount, int blockColumnCount) {
        long binX1 = region1.start() / binsize;
        long binX2 = region1.end() / binsize;
        long binY1 = region2.start() / binsize;
        long binY2 = region2.end() / binsize;
        int translatedLowerPAD = (int)Math.floor((double)(binX1 + binY1) / 2.0 / (double)blockBinCount);
        int translatedHigherPAD = (int)Math.floor((double)(binX2 + binY2) / 2.0 / (double)blockBinCount);
        int translatedNearerDepth = (int)Math.floor(Math.log(1.0 + (double)Math.abs(binX1 - binY2) / Math.sqrt(2.0) / (double)blockBinCount) / Math.log(2.0));
        int translatedFurtherDepth = (int)Math.floor(Math.log(1.0 + (double)Math.abs(binX2 - binY1) / Math.sqrt(2.0) / (double)blockBinCount) / Math.log(2.0));
        boolean containsDiagonal = (binX2 - binY1) * (binX1 - binY2) < 0L;
        int nearerDepth = containsDiagonal ? 0 : Math.min(translatedNearerDepth, translatedFurtherDepth);
        int furtherDepth = Math.max(translatedNearerDepth, translatedFurtherDepth);
        ArrayList<Integer> blockNumbers = new ArrayList<Integer>();
        for (int depth = nearerDepth; depth <= furtherDepth; ++depth) {
            for (int pad = translatedLowerPAD; pad <= translatedHigherPAD; ++pad) {
                int blockNumber = depth * blockColumnCount + pad;
                blockNumbers.add(blockNumber);
            }
        }
        return blockNumbers;
    }

    public static MatrixZoomData parseMatrixZoomData(Chromosome chr1, Chromosome chr2, UnsignedByteBuffer dis) throws IOException {
        double avgCount;
        MatrixZoomData zd = new MatrixZoomData(chr1, chr2);
        String unit = dis.getString();
        int zoomIndex = dis.getInt();
        double sumCounts = dis.getFloat();
        double occupiedCellCount = dis.getFloat();
        double stdDev = dis.getFloat();
        double percent95 = dis.getFloat();
        int binSize = dis.getInt();
        zd.blockBinCount = dis.getInt();
        zd.blockColumnCount = dis.getInt();
        int nBlocks = dis.getInt();
        zd.zoom = new Zoom(zoomIndex, unit, binSize);
        zd.blockIndex = new StaticBlockIndex(nBlocks, dis);
        int nBins1 = chr1.getLength() / binSize;
        int nBins2 = chr2.getLength() / binSize;
        zd.averageCount = avgCount = sumCounts / (double)nBins1 / (double)nBins2;
        zd.sumCounts = sumCounts;
        zd.stdDev = stdDev;
        zd.occupiedCellCount = occupiedCellCount;
        zd.percent95 = percent95;
        return zd;
    }

    public Chromosome getChr1() {
        return this.chr1;
    }

    public Chromosome getChr2() {
        return this.chr2;
    }

    public Zoom getZoom() {
        return this.zoom;
    }

    public StaticBlockIndex getBlockIndex() {
        return this.blockIndex;
    }

    public double getAverageCount() {
        return this.averageCount;
    }

    public double getSumCounts() {
        return this.sumCounts;
    }

    public record Zoom(int index, String unit, int binSize) {
    }
}

