/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.igv.feature.Chromosome;
import org.igv.hic.MatrixZoomData;
import org.igv.ucsc.twobit.UnsignedByteBuffer;
import org.igv.ucsc.twobit.UnsignedByteBufferImpl;

public class Matrix {
    private final int chr1;
    private final int chr2;
    private final List<MatrixZoomData> bpZoomData = new ArrayList<MatrixZoomData>();
    private final List<MatrixZoomData> fragZoomData = new ArrayList<MatrixZoomData>();

    public Matrix(int chr1, int chr2, List<MatrixZoomData> zoomDataList) {
        this.chr1 = chr1;
        this.chr2 = chr2;
        for (MatrixZoomData zd : zoomDataList) {
            if ("BP".equals(zd.getZoom().unit())) {
                this.bpZoomData.add(zd);
                continue;
            }
            this.fragZoomData.add(zd);
        }
    }

    public int findZoomForResolution(int binSize, String unit) {
        List<MatrixZoomData> zdArray = "FRAG".equals(unit) ? this.fragZoomData : this.bpZoomData;
        for (int i = 1; i < zdArray.size(); ++i) {
            MatrixZoomData zd = zdArray.get(i);
            if (zd.getZoom().binSize() >= binSize) continue;
            return i - 1;
        }
        return Math.max(0, zdArray.size() - 1);
    }

    public MatrixZoomData getZoomData(int binSize, String unit) {
        if (unit == null) {
            unit = "BP";
        }
        List<MatrixZoomData> zdArray = "BP".equals(unit) ? this.bpZoomData : this.fragZoomData;
        for (MatrixZoomData zd : zdArray) {
            if (binSize != zd.getZoom().binSize()) continue;
            return zd;
        }
        return null;
    }

    public MatrixZoomData getZoomDataByIndex(int index, String unit) {
        List<MatrixZoomData> zdArray = "FRAG".equals(unit) ? this.fragZoomData : this.bpZoomData;
        return zdArray.get(index);
    }

    public int getChr1() {
        return this.chr1;
    }

    public int getChr2() {
        return this.chr2;
    }

    public List<MatrixZoomData> getBpZoomData() {
        return this.bpZoomData;
    }

    public List<MatrixZoomData> getFragZoomData() {
        return this.fragZoomData;
    }

    public static String getKey(int chrIdx1, int chrIdx2) {
        if (chrIdx1 > chrIdx2) {
            int tmp = chrIdx1;
            chrIdx1 = chrIdx2;
            chrIdx2 = tmp;
        }
        return chrIdx1 + "_" + chrIdx2;
    }

    public static Matrix parseMatrix(byte[] data, List<Chromosome> chromosomes) throws IOException {
        UnsignedByteBuffer dis = UnsignedByteBufferImpl.wrap(data);
        int c1 = dis.getInt();
        int c2 = dis.getInt();
        Chromosome chr1 = chromosomes.get(c1);
        Chromosome chr2 = chromosomes.get(c2);
        int nResolutions = dis.getInt();
        ArrayList<MatrixZoomData> zdList = new ArrayList<MatrixZoomData>(nResolutions);
        while (nResolutions-- > 0) {
            MatrixZoomData zd = MatrixZoomData.parseMatrixZoomData(chr1, chr2, dis);
            zdList.add(zd);
        }
        return new Matrix(c1, c2, zdList);
    }
}

