/*
 * Decompiled with CFR 0.152.
 */
package org.igv.hic;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.Map;
import org.igv.hic.StaticBlockIndex;

public class DynamicBlockIndex {
    private final FileChannel fileChannel;
    private final long minPosition;
    private final long maxPosition;
    private final int nBlocks;
    private final int maxBlock;
    private Map<Integer, StaticBlockIndex.BlockIndexEntry> blockIndexMap;
    private Range blockNumberRange;
    private MapFileBounds mapFileBounds;
    private static final long ENTRY_SIZE = 16L;

    public DynamicBlockIndex(FileChannel fileChannel, long position, int nBlocks, int maxBlock) {
        this.fileChannel = fileChannel;
        this.minPosition = position;
        this.maxPosition = position + (long)nBlocks * 16L;
        this.nBlocks = nBlocks;
        this.maxBlock = maxBlock;
    }

    public StaticBlockIndex.BlockIndexEntry getBlockIndexEntry(int blockNumber) throws IOException {
        if (blockNumber > this.maxBlock) {
            return null;
        }
        if (this.blockNumberRange != null && blockNumber >= this.blockNumberRange.first && blockNumber <= this.blockNumberRange.last) {
            return this.blockIndexMap.get(blockNumber);
        }
        long minPos = this.minPosition;
        long maxPos = this.maxPosition;
        if (this.blockNumberRange != null && this.mapFileBounds != null) {
            if (blockNumber < this.blockNumberRange.first) {
                maxPos = this.mapFileBounds.min;
            } else if (blockNumber > this.blockNumberRange.last) {
                minPos = this.mapFileBounds.max;
            }
        }
        if (maxPos - minPos < 16L) {
            return null;
        }
        return this.searchForBlockIndexEntry(blockNumber, minPos, maxPos);
    }

    private StaticBlockIndex.BlockIndexEntry searchForBlockIndexEntry(int blockNumber, long boundsMin, long boundsMax) throws IOException {
        long chunkSize = 1600000L;
        if (boundsMax - boundsMin < 1600000L) {
            int len = (int)(boundsMax - boundsMin);
            ByteBuffer buf = ByteBuffer.allocate(len);
            buf.order(ByteOrder.LITTLE_ENDIAN);
            this.fileChannel.read(buf, boundsMin);
            buf.flip();
            HashMap<Integer, StaticBlockIndex.BlockIndexEntry> localIndex = new HashMap<Integer, StaticBlockIndex.BlockIndexEntry>();
            int ptr = 0;
            Integer firstBlockNumber = null;
            Integer lastBlockNumber = null;
            while (ptr < len) {
                int bn = buf.getInt();
                long filePosition = buf.getLong();
                int blockSizeInBytes = buf.getInt();
                localIndex.put(bn, new StaticBlockIndex.BlockIndexEntry(filePosition, blockSizeInBytes));
                if (firstBlockNumber == null) {
                    firstBlockNumber = bn;
                }
                lastBlockNumber = bn;
                ptr = (int)((long)ptr + 16L);
            }
            this.mapFileBounds = new MapFileBounds(boundsMin, boundsMax);
            this.blockNumberRange = new Range(firstBlockNumber, lastBlockNumber);
            this.blockIndexMap = localIndex;
            return (StaticBlockIndex.BlockIndexEntry)localIndex.get(blockNumber);
        }
        long nEntries = (boundsMax - boundsMin) / 16L;
        long pos1 = boundsMin + nEntries / 2L * 16L;
        ByteBuffer buf = ByteBuffer.allocate(16);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        this.fileChannel.read(buf, pos1);
        buf.flip();
        int bn = buf.getInt();
        if (bn == blockNumber) {
            long filePosition = buf.getLong();
            int blockSizeInBytes = buf.getInt();
            return new StaticBlockIndex.BlockIndexEntry(filePosition, blockSizeInBytes);
        }
        if (blockNumber > bn) {
            return this.searchForBlockIndexEntry(blockNumber, pos1 + 16L, boundsMax);
        }
        return this.searchForBlockIndexEntry(blockNumber, boundsMin, pos1);
    }

    private static class Range {
        final int first;
        final int last;

        Range(int first, int last) {
            this.first = first;
            this.last = last;
        }
    }

    private static class MapFileBounds {
        final long min;
        final long max;

        MapFileBounds(long min, long max) {
            this.min = min;
            this.max = max;
        }
    }
}

