/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.tribble;

import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.Feature;
import htsjdk.tribble.exception.CodecLineParsingException;
import htsjdk.tribble.readers.LineIterator;
import java.util.regex.Pattern;
import org.igv.Globals;
import org.igv.feature.FeatureType;
import org.igv.feature.IGVFeature;
import org.igv.feature.tribble.FeatureFileHeader;
import org.igv.feature.tribble.GFFCodec;
import org.igv.renderer.SpliceJunctionRenderer;
import org.igv.track.TrackProperties;
import org.igv.track.TrackType;
import org.igv.util.ParsingUtils;

public abstract class UCSCCodec<T extends IGVFeature>
extends AsciiFeatureCodec<T> {
    GFFCodec.GFF3Helper tagHelper = new GFFCodec.GFF3Helper();
    protected boolean gffTags = false;
    FeatureFileHeader header;
    FeatureType featureType;
    private Pattern delimiter = null;

    protected UCSCCodec(Class myClass) {
        super(myClass);
    }

    protected UCSCCodec(Class myClass, FeatureType featureType) {
        super(myClass);
        this.featureType = featureType;
    }

    public Object readActualHeader(LineIterator reader) {
        try {
            String line;
            while (reader.hasNext() && ((line = reader.peek()).startsWith("#") || line.startsWith("track") || line.startsWith("browser"))) {
                this.readHeaderLine(line);
                reader.next();
            }
            return this.header;
        }
        catch (Exception e) {
            throw new CodecLineParsingException("Error parsing header", (Throwable)e);
        }
    }

    protected boolean readHeaderLine(String line) {
        if (this.header == null) {
            this.header = new FeatureFileHeader();
        }
        if (line.startsWith("#type")) {
            String[] tokens = line.split("=");
            if (tokens.length > 1) {
                try {
                    this.header.setTrackType(TrackType.valueOf(tokens[1]));
                }
                catch (Exception exception) {}
            }
        } else if (line.startsWith("#track") || line.startsWith("track")) {
            Class rendererClass;
            TrackProperties tp = new TrackProperties();
            ParsingUtils.parseTrackLine(line, tp);
            this.header.setTrackProperties(tp);
            if (!this.gffTags) {
                this.gffTags = tp.isGffTags();
            }
            if ((rendererClass = tp.getRendererClass()) != null && rendererClass.isAssignableFrom(SpliceJunctionRenderer.class)) {
                this.featureType = FeatureType.SPLICE_JUNCTION;
            }
        } else if (line.toLowerCase().contains("#gfftags")) {
            this.gffTags = true;
        } else {
            return false;
        }
        return true;
    }

    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    public void setGffTags(boolean gffTags) {
        this.gffTags = gffTags;
    }

    public boolean isGffTags() {
        return this.gffTags;
    }

    public void setFeatureType(FeatureType featureType) {
        this.featureType = featureType;
    }

    public T decode(String nextLine) {
        String trimLine = nextLine.trim();
        if (trimLine.length() == 0) {
            return null;
        }
        if (nextLine.startsWith("#") || nextLine.startsWith("track") || nextLine.startsWith("browser")) {
            return null;
        }
        if (this.delimiter == null) {
            this.delimiter = this.featureType == FeatureType.BED_METHYL ? Globals.whitespacePattern : (trimLine.contains("\t") ? Globals.multiTabPattern : Globals.whitespacePattern);
        }
        String[] tokens = this.delimiter.split(trimLine);
        T feature = this.decode(tokens);
        return feature;
    }

    public abstract T decode(String[] var1);
}

