/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome.load;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import org.igv.feature.Cytoband;
import org.igv.feature.genome.Sequence;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.json.JSONObject;

public class GenomeConfig
implements Cloneable {
    private static Logger log = LogManager.getLogger(GenomeConfig.class);
    public String id;
    public String fastaURL;
    public String indexURL;
    public String gziIndexURL;
    public String compressedIndexURL;
    public String twoBitURL;
    public String twoBitBptURL;
    public String nameSet;
    public String defaultPos;
    public String description;
    public String blat;
    public String chromAliasBbURL;
    public String chromSizesURL;
    public String infoURL;
    public String cytobandURL;
    public String cytobandBbURL;
    public Boolean ordered;
    public String blatDB;
    public String ucscID;
    public String aliasURL;
    public String accession;
    public String taxId;
    public String organism;
    public String scientificName;
    public String maneBbURL;
    public String maneTrixURL;
    public String rsdbURL;
    public String[] chromosomeOrder;
    public boolean wholeGenomeView = true;
    private String name;
    private List<TrackConfig> tracks;
    private List<String> hubs;
    private Sequence sequence;
    private LinkedHashMap<String, List<Cytoband>> cytobands;
    private List<List<String>> chromAliases;

    public static GenomeConfig fromJson(String json) {
        int i;
        if (json.contains("chromosomeOrder")) {
            json = GenomeConfig.fixChromosomeOrder(json);
        }
        GenomeConfig config = new GenomeConfig();
        JSONObject jsonObj = new JSONObject(json);
        config.id = jsonObj.optString("id");
        config.name = jsonObj.optString("name", null);
        config.fastaURL = jsonObj.optString("fastaURL", null);
        config.indexURL = jsonObj.optString("indexURL", null);
        config.gziIndexURL = jsonObj.optString("gziIndexURL", null);
        config.compressedIndexURL = jsonObj.optString("compressedIndexURL", null);
        config.twoBitURL = jsonObj.optString("twoBitURL", null);
        config.twoBitBptURL = jsonObj.optString("twoBitBptURL", null);
        config.nameSet = jsonObj.optString("nameSet", null);
        config.defaultPos = jsonObj.optString("defaultPos", null);
        config.description = jsonObj.optString("description", null);
        config.blat = jsonObj.optString("blat", null);
        config.chromAliasBbURL = jsonObj.optString("chromAliasBbURL", null);
        config.chromSizesURL = jsonObj.optString("chromSizesURL", null);
        config.infoURL = jsonObj.optString("infoURL", null);
        config.cytobandURL = jsonObj.optString("cytobandURL", null);
        config.cytobandBbURL = jsonObj.optString("cytobandBbURL", null);
        config.ordered = jsonObj.has("ordered") ? Boolean.valueOf(jsonObj.optBoolean("ordered")) : null;
        config.blatDB = jsonObj.optString("blatDB", null);
        config.ucscID = jsonObj.optString("ucscID", null);
        config.aliasURL = jsonObj.optString("aliasURL", null);
        config.accession = jsonObj.optString("accession", null);
        config.taxId = jsonObj.optString("taxId", null);
        config.organism = jsonObj.optString("organism", null);
        config.scientificName = jsonObj.optString("scientificName", null);
        config.maneBbURL = jsonObj.optString("maneBbURL", null);
        config.maneTrixURL = jsonObj.optString("maneTrixURL", null);
        config.rsdbURL = jsonObj.optString("rsdbURL", null);
        config.chromosomeOrder = jsonObj.has("chromosomeOrder") ? jsonObj.getJSONArray("chromosomeOrder").toList().toArray(new String[0]) : null;
        config.wholeGenomeView = jsonObj.optBoolean("wholeGenomeView", true);
        config.hubs = new ArrayList<String>();
        if (jsonObj.has("hubs")) {
            for (i = 0; i < jsonObj.getJSONArray("hubs").length(); ++i) {
                config.hubs.add(jsonObj.getJSONArray("hubs").getString(i));
            }
        }
        if (jsonObj.has("tracks")) {
            config.tracks = new ArrayList<TrackConfig>();
            for (i = 0; i < jsonObj.getJSONArray("tracks").length(); ++i) {
                JSONObject track = jsonObj.getJSONArray("tracks").getJSONObject(i);
                config.tracks.add(TrackConfig.fromJSON(track.toString()));
            }
        }
        return config;
    }

    public JSONObject toJSON() {
        JSONObject jsonObj = new JSONObject();
        if (this.id != null) {
            jsonObj.put("id", (Object)this.id);
        }
        if (this.name != null) {
            jsonObj.put("name", (Object)this.name);
        }
        if (this.fastaURL != null) {
            jsonObj.put("fastaURL", (Object)this.fastaURL);
        }
        if (this.indexURL != null) {
            jsonObj.put("indexURL", (Object)this.indexURL);
        }
        if (this.gziIndexURL != null) {
            jsonObj.put("gziIndexURL", (Object)this.gziIndexURL);
        }
        if (this.compressedIndexURL != null) {
            jsonObj.put("compressedIndexURL", (Object)this.compressedIndexURL);
        }
        if (this.twoBitURL != null) {
            jsonObj.put("twoBitURL", (Object)this.twoBitURL);
        }
        if (this.twoBitBptURL != null) {
            jsonObj.put("twoBitBptURL", (Object)this.twoBitBptURL);
        }
        if (this.nameSet != null) {
            jsonObj.put("nameSet", (Object)this.nameSet);
        }
        if (this.defaultPos != null) {
            jsonObj.put("defaultPos", (Object)this.defaultPos);
        }
        if (this.description != null) {
            jsonObj.put("description", (Object)this.description);
        }
        if (this.blat != null) {
            jsonObj.put("blat", (Object)this.blat);
        }
        if (this.chromAliasBbURL != null) {
            jsonObj.put("chromAliasBbURL", (Object)this.chromAliasBbURL);
        }
        if (this.chromSizesURL != null) {
            jsonObj.put("chromSizesURL", (Object)this.chromSizesURL);
        }
        if (this.infoURL != null) {
            jsonObj.put("infoURL", (Object)this.infoURL);
        }
        if (this.cytobandURL != null) {
            jsonObj.put("cytobandURL", (Object)this.cytobandURL);
        }
        if (this.cytobandBbURL != null) {
            jsonObj.put("cytobandBbURL", (Object)this.cytobandBbURL);
        }
        if (this.ordered != null) {
            jsonObj.put("ordered", (Object)this.ordered);
        }
        if (this.blatDB != null) {
            jsonObj.put("blatDB", (Object)this.blatDB);
        }
        if (this.ucscID != null) {
            jsonObj.put("ucscID", (Object)this.ucscID);
        }
        if (this.aliasURL != null) {
            jsonObj.put("aliasURL", (Object)this.aliasURL);
        }
        if (this.accession != null) {
            jsonObj.put("accession", (Object)this.accession);
        }
        if (this.taxId != null) {
            jsonObj.put("taxId", (Object)this.taxId);
        }
        if (this.organism != null) {
            jsonObj.put("organism", (Object)this.organism);
        }
        if (this.scientificName != null) {
            jsonObj.put("scientificName", (Object)this.scientificName);
        }
        if (this.chromosomeOrder != null) {
            jsonObj.put("chromosomeOrder", (Object)this.chromosomeOrder);
        }
        if (this.maneBbURL != null) {
            jsonObj.put("maneBbURL", (Object)this.maneBbURL);
        }
        if (this.maneTrixURL != null) {
            jsonObj.put("maneTrixURL", (Object)this.maneTrixURL);
        }
        if (this.rsdbURL != null) {
            jsonObj.put("rsdbURL", (Object)this.rsdbURL);
        }
        jsonObj.put("wholeGenomeView", this.wholeGenomeView);
        if (this.hubs != null && !this.hubs.isEmpty()) {
            jsonObj.put("hubs", this.hubs);
        }
        if (this.tracks != null && !this.tracks.isEmpty()) {
            ArrayList<JSONObject> trackJsons = new ArrayList<JSONObject>();
            for (TrackConfig track : this.tracks) {
                trackJsons.add(track.toJSON());
            }
            jsonObj.put("tracks", trackJsons);
        }
        return jsonObj;
    }

    public List<String> getHubs() {
        return this.hubs;
    }

    public void setHubs(List<String> hubs) {
        this.hubs = hubs;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.name == null) {
            if (this.scientificName != null) {
                this.name = this.scientificName;
            } else if (this.organism != null) {
                this.name = this.organism;
            } else if (this.description != null) {
                this.name = this.description;
            }
            this.name = this.name == null ? this.id : this.name + " (" + this.id + ")";
        }
        return this.name;
    }

    public String getUcscID() {
        return this.ucscID == null ? this.id : this.ucscID;
    }

    public String[] getChromosomeOrder() {
        return this.chromosomeOrder;
    }

    public List<TrackConfig> getTrackConfigs() {
        return this.tracks;
    }

    public void setTracks(List<TrackConfig> tracks) {
        this.tracks = tracks;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public LinkedHashMap<String, List<Cytoband>> getCytobands() {
        return this.cytobands;
    }

    public void setCytobands(LinkedHashMap<String, List<Cytoband>> cytobands) {
        this.cytobands = cytobands;
    }

    public List<List<String>> getChromAliases() {
        return this.chromAliases;
    }

    public void setChromAliases(List<List<String>> chromAliases) {
        this.chromAliases = chromAliases;
    }

    public GenomeConfig copy() {
        return this.clone();
    }

    protected GenomeConfig clone() {
        try {
            GenomeConfig clone = (GenomeConfig)super.clone();
            if (this.tracks != null) {
                clone.tracks = new ArrayList<TrackConfig>();
                for (TrackConfig trackConfig : this.tracks) {
                    clone.tracks.add(trackConfig.clone());
                }
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            log.error("Cloning not supported", e);
            return this;
        }
    }

    private static String fixChromosomeOrder(String jsonString) {
        JSONObject obj = new JSONObject(jsonString);
        Object chromosomeOrder = obj.opt("chromosomeOrder");
        if (chromosomeOrder != null && chromosomeOrder instanceof String) {
            obj.put("chromosomeOrder", Arrays.stream(((String)chromosomeOrder).split(",")).map(String::trim).toArray(String[]::new));
        }
        return obj.toString();
    }

    public void removeHub(String url) {
        this.hubs.remove(url);
    }
}

