/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome.fasta;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.Chromosome;
import org.igv.feature.genome.Sequence;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.ParsingUtils;
import org.igv.util.collections.ByteArrayList;

public class FastaNonIndexedSequence
implements Sequence {
    static Logger log = LogManager.getLogger(FastaNonIndexedSequence.class);
    private ArrayList<String> chromoNamesList;
    private Map<String, byte[]> sequenceMap;
    private Map<String, Integer> chromSizesMap;
    private List<Chromosome> chromosomes;

    public FastaNonIndexedSequence(String path) throws IOException {
        this.read(path);
    }

    private void read(String path) throws IOException {
        try (BufferedReader reader = ParsingUtils.openBufferedReader(path);){
            String line;
            String lastName = null;
            this.sequenceMap = new HashMap<String, byte[]>();
            this.chromoNamesList = new ArrayList();
            this.chromSizesMap = new HashMap<String, Integer>();
            this.chromosomes = new ArrayList<Chromosome>();
            int idx = 0;
            ByteArrayList byteArrayList = new ByteArrayList(100000);
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(">")) {
                    String name = line.substring(1).trim();
                    this.chromoNamesList.add(name);
                    if (lastName != null) {
                        int size = byteArrayList.size();
                        this.sequenceMap.put(lastName, byteArrayList.toArray());
                        this.chromSizesMap.put(lastName, size);
                        this.chromosomes.add(new Chromosome(idx++, lastName, size));
                    }
                    lastName = name;
                    byteArrayList = new ByteArrayList(100000);
                    continue;
                }
                byteArrayList.addAll(line.getBytes());
            }
        }
    }

    @Override
    public byte[] getSequence(String chr, int qstart, int qend) {
        byte[] seq = this.sequenceMap.get(chr);
        if (seq == null) {
            log.warn("No fasta sequence entry for: " + chr);
            return null;
        }
        if (qstart < 0 || qstart >= seq.length) {
            throw new IllegalArgumentException("Start position out of bounds: " + qstart);
        }
        if (qend <= qstart || qend >= seq.length) {
            throw new IllegalArgumentException("End position out of bounds: " + qend);
        }
        return Arrays.copyOfRange(seq, qstart, qend);
    }

    @Override
    public byte getBase(String chr, int position) {
        throw new RuntimeException("getBase() is not implemented for class " + FastaNonIndexedSequence.class.getName());
    }

    @Override
    public List<String> getChromosomeNames() {
        return this.chromoNamesList;
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return this.chromSizesMap.get(chrname);
    }

    @Override
    public List<Chromosome> getChromosomes() {
        return this.chromosomes;
    }
}

