/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.genome;

import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import org.json.JSONObject;

public class ClinVar {
    public static String getClinVarURL(String hgvsNotation) {
        try {
            String encodedHgvs = URLEncoder.encode(hgvsNotation, StandardCharsets.UTF_8);
            String esearchUrl = "https://eutils.ncbi.nlm.nih.gov/entrez/eutils/esearch.fcgi?db=clinvar&term=" + encodedHgvs + "&retmode=json";
            HttpClient client = HttpClient.newHttpClient();
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(esearchUrl)).build();
            HttpResponse<String> response = client.send(request, HttpResponse.BodyHandlers.ofString());
            String body = response.body();
            JSONObject json = new JSONObject(body);
            JSONObject esearchResult = json.getJSONObject("esearchresult");
            if (esearchResult.getInt("count") > 0) {
                String uid = esearchResult.getJSONArray("idlist").getString(0);
                return "https://www.ncbi.nlm.nih.gov/clinvar/variation/" + uid + "/";
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }
}

