/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.dranger;

import htsjdk.tribble.readers.AsciiLineReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.igv.Globals;
import org.igv.exceptions.ParserException;
import org.igv.feature.Strand;
import org.igv.feature.dranger.DRangerFeature;
import org.igv.feature.dranger.DRangerRenderer;
import org.igv.feature.genome.Genome;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.FeatureCollectionSource;
import org.igv.track.FeatureTrack;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;

public class DRangerParser {
    int numColumn;
    int chr1Column;
    int str1Column;
    int pos1Column;
    int chr2Column;
    int str2Column;
    int pos2Column;
    int tumreadsColumn;
    int normreadsColumn;
    int classColumn;
    int spanColumn;
    int site1Column;
    int site2Column;
    int qualityColumn;
    int scoreColumn;
    static Logger log = LogManager.getLogger(DRangerParser.class);

    public List<FeatureTrack> loadTracks(ResourceLocator locator, Genome genome) {
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        AsciiLineReader reader = null;
        ArrayList<DRangerFeature> features = new ArrayList<DRangerFeature>(5000);
        int parseColumn = -1;
        String nextLine = null;
        int rowCounter = 0;
        try {
            reader = ParsingUtils.openAsciiReader(locator);
            this.setColumns(reader.readLine());
            ++rowCounter;
            while ((nextLine = reader.readLine()) != null) {
                String[] tokens = Globals.tabPattern.split(nextLine, -1);
                ++rowCounter;
                int nTokens = tokens.length;
                if (nTokens <= this.pos2Column) continue;
                int index = Integer.parseInt(tokens[this.numColumn]);
                String chr1 = genome.getCanonicalChrName(tokens[this.chr1Column]);
                int pos1 = Integer.parseInt(tokens[this.pos1Column]);
                String str1 = tokens[this.str1Column];
                Strand strand1 = str1.equals("0") || str1.equals("(+)") ? Strand.POSITIVE : Strand.NEGATIVE;
                String chr2 = genome.getCanonicalChrName(tokens[this.chr2Column]);
                int pos2 = Integer.parseInt(tokens[this.pos2Column]);
                String str2 = tokens[this.str2Column];
                Strand strand2 = str2.equals("0") || str2.equals("(+)") ? Strand.POSITIVE : Strand.NEGATIVE;
                DRangerFeature feature = new DRangerFeature(chr1, pos1, strand1, chr2, pos2, strand2);
                feature.setIndex(index);
                if (this.tumreadsColumn > 0) {
                    feature.setTumreads(this.toInt(tokens[this.tumreadsColumn]));
                }
                if (this.normreadsColumn > 0) {
                    feature.setNormreads(this.toInt(tokens[this.normreadsColumn]));
                }
                if (this.classColumn > 0) {
                    feature.setFeatureClass(tokens[this.classColumn]);
                }
                if (this.spanColumn > 0) {
                    feature.setSpan(this.toInt(tokens[this.spanColumn]));
                }
                if (this.site1Column > 0) {
                    feature.setSite1(tokens[this.site1Column]);
                }
                if (this.site2Column > 0) {
                    feature.setSite2(tokens[this.site2Column]);
                }
                if (this.qualityColumn > 0) {
                    feature.setQuality(this.toInt(tokens[this.qualityColumn]));
                }
                if (this.scoreColumn > 0) {
                    feature.setScore(this.toInt(tokens[this.scoreColumn]));
                }
                features.add(feature);
            }
        }
        catch (NumberFormatException ne) {
            throw new ParserException("Column " + parseColumn + " must be a numeric value", rowCounter, nextLine);
        }
        catch (Exception e) {
            log.error("Error parsing dRanger file", e);
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        FeatureTrack track = new FeatureTrack(locator, new FeatureCollectionSource(features, genome));
        track.setName(locator.getTrackName());
        track.setRenderer(new DRangerRenderer());
        tracks.add(track);
        return tracks;
    }

    private int toInt(String token) {
        try {
            return Integer.parseInt(token);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private void setColumns(String header) throws Exception {
        String[] tokens = header.split("\t");
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < tokens.length; ++i) {
            map.put(tokens[i].toLowerCase(), i);
        }
        this.chr1Column = (Integer)map.get("chr1");
        this.str1Column = (Integer)map.get("str1");
        this.pos1Column = (Integer)map.get("pos1");
        this.chr2Column = (Integer)map.get("chr2");
        this.str2Column = (Integer)map.get("str2");
        this.pos2Column = (Integer)map.get("pos2");
        if (map.containsKey("num")) {
            this.numColumn = (Integer)map.get("num");
        }
        if (map.containsKey("tumreads")) {
            this.tumreadsColumn = (Integer)map.get("tumreads");
        }
        if (map.containsKey("normreads")) {
            this.tumreadsColumn = (Integer)map.get("normreads");
        }
        if (map.containsKey("class")) {
            this.classColumn = (Integer)map.get("class");
        }
        if (map.containsKey("span")) {
            this.spanColumn = (Integer)map.get("span");
        }
        if (map.containsKey("site1")) {
            this.site1Column = (Integer)map.get("site1");
        }
        if (map.containsKey("site2")) {
            this.site2Column = (Integer)map.get("site2");
        }
        if (map.containsKey("quality")) {
            this.qualityColumn = (Integer)map.get("quality");
        }
        if (map.containsKey("score")) {
            this.scoreColumn = (Integer)map.get("score");
        }
    }
}

