/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature.aa;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Scanner;
import org.igv.feature.aa.AminoAcidManager;
import org.igv.feature.aa.CodonTable;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.ParsingUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CodonTableManager {
    private static final Logger log = LogManager.getLogger(CodonTableManager.class);
    public static final String DEFAULT_CODON_TABLE_PATH = "resources/geneticCode.json";
    static final String DEFAULT_TRANS_TABLE_PATH = "resources/defaultTranslationTables.json";
    public static final int STANDARD_TABLE_ID = 1;
    private Map<String, CodonTableMap> genomeChromoTable = new HashMap<String, CodonTableMap>();
    private LinkedHashMap<Integer, CodonTable> allCodonTables = new LinkedHashMap(20);
    private CodonTable defaultCodonTable;
    private CodonTable currentCodonTable;
    private static CodonTableManager instance;

    public static synchronized CodonTableManager getInstance() {
        if (instance == null) {
            AminoAcidManager.initAANameMap();
            instance = new CodonTableManager();
        }
        return instance;
    }

    private CodonTableManager() {
        this.init();
    }

    private void init() {
        try {
            this.loadDefaultTranslationTables();
            this.loadCodonTables(DEFAULT_CODON_TABLE_PATH);
        }
        catch (IOException e) {
            CodonTableManager.handleExceptionLoading(e);
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private static void handleExceptionLoading(Exception e) {
        log.error(e);
        if (instance == null) {
            throw new IllegalStateException("No codon table present, and error loading resources/geneticCode.json", e);
        }
    }

    public void resetToDefaults() {
        this.currentCodonTable = null;
        this.genomeChromoTable = new HashMap<String, CodonTableMap>();
        this.allCodonTables = new LinkedHashMap(20);
        this.init();
    }

    public CodonTable getCodonTableForChromosome(String genomeID, String chr) {
        if (this.currentCodonTable != null) {
            return this.currentCodonTable;
        }
        CodonTableMap map = this.genomeChromoTable.get(genomeID);
        if (map == null) {
            return this.defaultCodonTable;
        }
        Integer tableID = map.getTableIdForChr(chr);
        return this.allCodonTables.get(tableID);
    }

    public CodonTable getCodonTableForChromosome(String chr) {
        return this.getCodonTableForChromosome(GenomeManager.getInstance().getGenomeId(), chr);
    }

    public Collection<CodonTable> getAllCodonTables() {
        return Collections.unmodifiableCollection(this.allCodonTables.values());
    }

    public void setCurrentCodonTable(CodonTable codonTable) {
        this.currentCodonTable = codonTable;
    }

    synchronized void loadCodonTables(String codonTablesPath) throws IOException {
        LinkedHashMap<Integer, CodonTable> newCodonTables = new LinkedHashMap<Integer, CodonTable>(20);
        InputStream is = AminoAcidManager.class.getResourceAsStream(codonTablesPath);
        if (is == null) {
            is = ParsingUtils.openInputStream(codonTablesPath);
        }
        if (codonTablesPath.endsWith(".json")) {
            StringBuilder sb = new StringBuilder();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line;
                while ((line = reader.readLine()) != null) {
                    sb.append(line);
                }
            }
            JSONObject allData = new JSONObject(sb.toString());
            int defaultId = allData.getInt("defaultid");
            JSONArray codonArray = allData.getJSONArray("Genetic-code-table");
            if (codonArray.length() == 0) {
                throw new RuntimeException("JSON File has empty array for Genetic-code-table");
            }
            for (int ca = 0; ca < codonArray.length(); ++ca) {
                JSONObject codonObj = codonArray.getJSONObject(ca);
                CodonTable curTable = CodonTable.createFromJSON(codonTablesPath, codonObj);
                newCodonTables.put(curTable.getId(), curTable);
                if (this.defaultCodonTable != null && curTable.getId() != defaultId) continue;
                this.defaultCodonTable = curTable;
            }
        } else {
            throw new IllegalArgumentException("Unknown file type, must be .json");
        }
        this.allCodonTables.putAll(newCodonTables);
        is.close();
    }

    private void loadDefaultTranslationTables() throws JSONException {
        InputStream is = CodonTableManager.class.getResourceAsStream(DEFAULT_TRANS_TABLE_PATH);
        JSONObject allData = new JSONObject(new Scanner(is).useDelimiter("\\A").next());
        JSONArray organisms = allData.getJSONArray("organisms");
        for (int ind = 0; ind < organisms.length(); ++ind) {
            JSONObject obj = organisms.getJSONObject(ind);
            String genomeId = obj.getString("genomeId");
            this.genomeChromoTable.put(genomeId, new CodonTableMap(obj));
        }
    }

    public CodonTable getDefaultCodonTable() {
        return this.defaultCodonTable;
    }

    public CodonTable getCurrentCodonTable() {
        return this.currentCodonTable;
    }

    public CodonTable getCodonTableByID(Integer id) {
        return this.allCodonTables.get(id);
    }

    static class CodonTableMap {
        String genomeID;
        Integer defaultID;
        Map<String, Integer> chromosomeIDs;

        CodonTableMap(JSONObject obj) {
            this.genomeID = obj.getString("genomeId");
            this.chromosomeIDs = new HashMap<String, Integer>();
            JSONObject chromosomes = obj.getJSONObject("chromosomes");
            this.defaultID = chromosomes.getInt("default");
            Iterator keys = chromosomes.keys();
            while (keys.hasNext()) {
                String chromoName = (String)keys.next();
                if (chromoName.equals("default")) continue;
                int id = chromosomes.getInt(chromoName);
                this.chromosomeIDs.put(chromoName, id);
            }
        }

        Integer getTableIdForChr(String chr) {
            if (this.chromosomeIDs.containsKey(chr)) {
                return this.chromosomeIDs.get(chr);
            }
            return this.defaultID;
        }
    }
}

