/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import htsjdk.tribble.Feature;
import java.util.ArrayList;
import java.util.List;
import org.igv.feature.BasicFeature;
import org.igv.feature.Exon;
import org.igv.feature.Strand;
import org.igv.track.WindowFunction;

public class SpliceJunctionFeature
extends BasicFeature {
    protected int junctionDepth = 0;
    private int junctionStart = 0;
    private int junctionEnd = 0;
    int[] startFlankingRegionDepthArray;
    int[] endFlankingRegionDepthArray;

    public SpliceJunctionFeature(String chr, int start, int end) {
        super(chr, start, end);
        this.junctionStart = start;
        this.junctionEnd = end;
    }

    public SpliceJunctionFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
        this.junctionStart = start;
        this.junctionEnd = end;
    }

    public boolean isSameJunction(Feature otherFeature) {
        return otherFeature != null && otherFeature instanceof SpliceJunctionFeature && ((SpliceJunctionFeature)otherFeature).getJunctionStart() == this.getJunctionStart() && ((SpliceJunctionFeature)otherFeature).getJunctionEnd() == this.getJunctionEnd();
    }

    public void addRead(int readStart, int readEnd) {
        ++this.junctionDepth;
        int newStartFlankingRegionSize = this.junctionStart - readStart;
        if (readStart < this.start) {
            int[] newStartFlankArray = new int[newStartFlankingRegionSize];
            if (this.startFlankingRegionDepthArray != null) {
                int offset = newStartFlankingRegionSize - this.getStartFlankingRegionLength();
                System.arraycopy(this.startFlankingRegionDepthArray, 0, newStartFlankArray, offset, this.getStartFlankingRegionLength());
            }
            this.startFlankingRegionDepthArray = newStartFlankArray;
            this.start = readStart;
        }
        for (int i = this.getStartFlankingRegionLength() - newStartFlankingRegionSize; i < this.getStartFlankingRegionLength(); ++i) {
            this.startFlankingRegionDepthArray[i] = this.startFlankingRegionDepthArray[i] + 1;
        }
        int newEndFlankingRegionSize = readEnd - this.junctionEnd;
        if (readEnd > this.end) {
            int[] newEndFlankArray = new int[newEndFlankingRegionSize];
            if (this.endFlankingRegionDepthArray != null) {
                System.arraycopy(this.endFlankingRegionDepthArray, 0, newEndFlankArray, 0, this.getEndFlankingRegionLength());
            }
            this.endFlankingRegionDepthArray = newEndFlankArray;
            this.end = readEnd;
        }
        for (int i = 0; i < newEndFlankingRegionSize; ++i) {
            this.endFlankingRegionDepthArray[i] = this.endFlankingRegionDepthArray[i] + 1;
        }
    }

    @Override
    public float getScore() {
        return this.junctionDepth;
    }

    @Override
    public List<Exon> getExons() {
        if (this.exons == null) {
            this.exons = new ArrayList(2);
            this.exons.add(new Exon(this.getChr(), this.start, this.junctionStart, this.getStrand()));
            this.exons.add(new Exon(this.getChr(), this.junctionEnd, this.end, this.getStrand()));
        }
        return this.exons;
    }

    @Override
    public int getExonCount() {
        return this.getExons().size();
    }

    public int getJunctionDepth() {
        return this.junctionDepth;
    }

    public void setJunctionDepth(int junctionDepth) {
        this.junctionDepth = junctionDepth;
    }

    public int getJunctionStart() {
        return this.junctionStart;
    }

    public void setJunctionStart(int junctionStart) {
        this.junctionStart = junctionStart;
    }

    public int getJunctionEnd() {
        return this.junctionEnd;
    }

    public void setJunctionEnd(int junctionEnd) {
        this.junctionEnd = junctionEnd;
    }

    public int getStartFlankingRegionLength() {
        return this.junctionStart - this.start;
    }

    public int getEndFlankingRegionLength() {
        return this.end - this.junctionEnd;
    }

    public int[] getStartFlankingRegionDepthArray() {
        return this.startFlankingRegionDepthArray;
    }

    public void setStartFlankingRegionDepthArray(int[] startFlankingRegionDepthArray) {
        this.startFlankingRegionDepthArray = startFlankingRegionDepthArray;
    }

    public int[] getEndFlankingRegionDepthArray() {
        return this.endFlankingRegionDepthArray;
    }

    public void setEndFlankingRegionDepthArray(int[] endFlankingRegionDepthArray) {
        this.endFlankingRegionDepthArray = endFlankingRegionDepthArray;
    }

    public boolean hasFlankingRegionDepthArrays() {
        return this.startFlankingRegionDepthArray != null && this.endFlankingRegionDepthArray != null;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        String name = this.getName();
        if (name != null) {
            valueString.append(name);
        }
        if (!(this.identifier == null || name != null && name.equals(this.identifier))) {
            valueString.append("<br>" + this.identifier);
        }
        valueString.append("<br>");
        valueString.append(this.chr + ":" + this.junctionStart + "-" + this.junctionEnd);
        valueString.append("<br>Strand: " + (this.getStrand().equals((Object)Strand.POSITIVE) ? "+" : "-"));
        valueString.append("<br>Depth = " + this.junctionDepth + ", Flanking Widths: (" + this.getStartFlankingRegionLength() + "," + this.getEndFlankingRegionLength() + ")");
        if (this.hasFlankingRegionDepthArrays()) {
            int index;
            if (position >= (double)this.start && position < (double)this.junctionStart) {
                int index2 = (int)position - this.start;
                if (index2 < this.startFlankingRegionDepthArray.length) {
                    valueString.append("<br>Start Flanking, Depth = " + this.startFlankingRegionDepthArray[index2]);
                }
            } else if (position > (double)this.junctionEnd && position <= (double)this.end && (index = (int)position - this.junctionEnd) < this.endFlankingRegionDepthArray.length) {
                valueString.append("<br>End Flanking, Depth = " + this.endFlankingRegionDepthArray[index]);
            }
        }
        if (this.description != null) {
            valueString.append("<br>" + this.description);
        }
        return valueString.toString();
    }
}

